package com.hyphenate.push.platform.meizu;

import android.content.Context;
import android.text.TextUtils;

import com.hyphenate.EMError;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.IPush;
import com.meizu.cloud.pushsdk.PushManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：http://open.res.flyme.cn/fileserver/upload/file/201612/728a49f530c64c5a832d7ba1de69e356.pdf
 */
public class EMMzPush extends IPush {
    private static final String TAG = "EMMzPush";

    @Override
    public EMPushType getPushType() {
        return EMPushType.MEIZUPUSH;
    }

    @Override
    public void onRegister(Context context, EMPushConfig config, PushListener pushListener) {
        boolean support = MzSystemUtils.isBrandMeizu(context);
        if (!support) {
            EMPushHelper.getInstance().onErrorResponse(getPushType(), EMError.PUSH_NOT_SUPPORT);
            return;
        }

        String pushId = PushManager.getPushId(context);
        if (TextUtils.isEmpty(pushId)) {
//            PushManager.register(context, "118654", "eaf530ff717f479cab93714d45972ff6");
            PushManager.register(context, config.getMzAppId(), config.getMzAppKey());
        } else {
            // upload pushId to hyphenate server.
            EMPushHelper.getInstance().onReceiveToken(getPushType(), pushId);
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(EMPushConfig config) {
        return config.getMzAppId();
    }
}
