package com.hyphenate.chat.adapter.message;

import com.hyphenate.chat.EMMessageBody;

import java.util.Map;

public class EMACustomMessageBody extends EMAMessageBody {

    public EMACustomMessageBody(String event) {
        nativeInit(event);
    }

    // used by jni_util.cpp: getJObject
    private EMACustomMessageBody() {
        nativeInit("");
    }

    public EMACustomMessageBody(EMACustomMessageBody body) {
        nativeInit(body);
    }

    public String event() { return  nativeEvent(); }
    public void setEvent(String event) {
        nativeSetEvent(event);
    }

    public Map<String, String> params() {return  nativeParams(); }
    public void setParams(Map<String, String> params) {
        nativeSetParams(params);
    }

    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }

    native void nativeInit(String event);
    native void nativeInit(EMACustomMessageBody body);
    native void nativeFinalize();
    native String nativeEvent();
    native Map<String, String> nativeParams();
    native void nativeSetEvent(String event);
    native void nativeSetParams(Map<String, String> params);

}
