/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMPageResult;

import java.util.List;
import java.util.Map;

public class EMAChatRoomManager extends EMABase {
    /**
     * \brief Add a listener to chatroom manager.
     *
     * @param  A chatroom manager listener.
     * @return NA
     */
   public void addListener(EMAChatRoomManagerListener listener) {
	   nativeAddListener(listener);
   }
   native void nativeAddListener(EMAChatRoomManagerListener listener);
   
   /**
     * \brief Remove a listener.
     *
     * @param  A chatroom manager listener.
     * @return NA
     */
   public void removeListener(EMAChatRoomManagerListener listener) {
	   nativeRemoveListener(listener);
   }
   native void nativeRemoveListener(EMAChatRoomManagerListener listener);
   
   /**
     * \brief Remove all the listeners.
     *
     * @param  NA
     * @return NA
     */
   public void clearListeners() {
	   nativeClearListeners();
   }
   native void nativeClearListeners();
   
   /**
     * \brief Fetch app's chatrooms.
     *
     * @param  EMError used for output.
     * @return Chatroom list.
     */
   public List<EMAChatRoom> fetchAllChatrooms(EMAError error) {
	   return nativeFetchAllChatrooms(error);
   }
   
   native List<EMAChatRoom> nativeFetchAllChatrooms(EMAError error);
   
   public EMPageResult<EMAChatRoom> fetchChatroomsWithPage(int pageNum, int pageSize, EMAError error) {
       return nativefetchChatroomsWithPage(pageNum, pageSize, error);
   }
   native EMPageResult<EMAChatRoom> nativefetchChatroomsWithPage(int pageNum, int pageSize, EMAError error);
   
   /**
     * \brief Get chatroom's specification.
     *
     * @param  Chatroom's ID.
     * @param  EMError used for output.
     * @return The chatroom that update it's specification.
     */
   public EMAChatRoom fetchChatroomSpecification(String chatroomId, EMAError error, boolean fetchMembers) {
	   return nativeFetchChatroomSpecification(chatroomId, error, fetchMembers);
   }
   native EMAChatRoom nativeFetchChatroomSpecification(String chatroomId, EMAError error, boolean fetchMembers);
   
   /**
     * \brief Join a chatroom.
     *
     * @param  Chatroom's ID.
     * @param  EMError used for output.
     * @return The joined chatroom.
     */
   public EMAChatRoom joinChatRoom(String chatRoomId,boolean leaveOtherRooms,String ext, EMAError error) {
	   return nativeJoinChatRoom(chatRoomId,leaveOtherRooms,ext, error);
   }
   native EMAChatRoom nativeJoinChatRoom(String chatRoomId,boolean leaveOtherRooms,String ext, EMAError error);
   
   /**
     * \brief Leave a chatroom.
     *
     * @param  Chatroom's ID.
     * @param  EMError used for output.
     * @return The leaved chatroom.
     */
   public void leaveChatRoom(String chatRoomId,EMAError error) {
	   nativeLeaveChatRoom(chatRoomId, error);
   }
   native void nativeLeaveChatRoom(String chatRoomId,EMAError error);
   
   public EMAChatRoom getChatroom(String roomid){
	   return nativeGetChatroom(roomid);
   }
   
   native EMAChatRoom nativeGetChatroom(String roomid);

    // ============================= group_reform new add api begin
    public EMAChatRoom createChatRoom(
            String subject,
            String description,
            String welcomeMessage,
            int styleIndex,
            int maxUserCount,
            List<String> members,
            EMAError error) {
        return nativeCreateChatRoom(subject, description, welcomeMessage, styleIndex, maxUserCount, members, error);
    }
    native EMAChatRoom nativeCreateChatRoom(String subject,
                                            String description,
                                            String welcomeMessage,
                                            int styleIndex,
                                            int maxUserCount,
                                            List<String> members,
                                            EMAError error);

    public void destroyChatroom(
            String chatRoomId,
            EMAError error) {
        nativeDestroyChatroom(chatRoomId, error);
    }

    native void nativeDestroyChatroom(
            String chatRoomId,
            EMAError error);


    public EMAChatRoom changeChatroomSubject(
            String chatRoomId,
            String newSubject,
            EMAError error) {
        return nativeChangeChatroomSubject(chatRoomId, newSubject, error);
    }

    native EMAChatRoom nativeChangeChatroomSubject(
            String chatRoomId,
            String newSubject,
            EMAError error);

    public EMAChatRoom changeChatroomDescription(
            String chatRoomId,
            String newDescription,
            EMAError error) {
        return nativeChangeChatroomDescription(chatRoomId, newDescription, error);
    }

    native EMAChatRoom nativeChangeChatroomDescription(
            String chatRoomId,
            String newDescription,
            EMAError error);

    public EMCursorResult<String> fetchChatroomMembers(
            String chatRoomId,
            String cursor,
            int pageSize,
            EMAError error) {
            return nativeFetchChatroomMembers(chatRoomId, cursor, pageSize, error);
    }

    native EMCursorResult<String> nativeFetchChatroomMembers(
            String chatRoomId,
            String cursor,
            int pageSize,
            EMAError error);

    public EMAChatRoom muteChatroomMembers(
            String chatRoomId,
            List<String> muteMembers,
            long duration,
            EMAError error) {
        return nativeMuteChatroomMembers(
                chatRoomId,
                muteMembers,
                duration,
                error);
    }

    native EMAChatRoom nativeMuteChatroomMembers(
            String chatRoomId,
            List<String> muteMembers,
            long duration,
            EMAError error);


    public EMAChatRoom unmuteChatRoomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error) {
        return nativeUnmuteChatroomMembers(chatRoomId, members, error);
    }

    native EMAChatRoom nativeUnmuteChatroomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error);

    public EMAChatRoom transferChatroomOwner(
            String chatRoomId,
            String newOwner,
            EMAError error) {
        return nativeTransferChatroomOwner(chatRoomId, newOwner, error);
    }

    native EMAChatRoom nativeTransferChatroomOwner(
            String chatRoomId,
            String newOwner,
            EMAError error);

    public EMAChatRoom addChatroomAdmin(
            String chatRoomId,
            String admin,
            EMAError error) {
        return nativeAddChatroomAdmin(chatRoomId, admin, error);
    }

    native EMAChatRoom nativeAddChatroomAdmin(
            String chatRoomId,
            String admin,
            EMAError error);

    public EMAChatRoom removeChatRoomAdmin(
            String chatRoomId,
            String admin,
            EMAError error) {
        return nativeRemoveChatroomAdmin(chatRoomId, admin, error);
    }

    native EMAChatRoom nativeRemoveChatroomAdmin(
            String chatRoomId,
            String admin,
            EMAError error);

    public Map<String, Long> fetchChatRoomMuteList(
            String chatRoomId,
            int pageNum,
            int pageSize,
            EMAError error) {
        return nativeFetchChatroomMutes(chatRoomId, pageNum, pageSize, error);
    }

    native Map<String, Long> nativeFetchChatroomMutes(
            String chatRoomId,
            int pageNum,
            int pageSize,
            EMAError error);

    public EMAChatRoom removeChatRoomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error) {
        return nativeRemoveChatRoomMembers(chatRoomId, members, error);
    }

    native EMAChatRoom nativeRemoveChatRoomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error);

    public EMAChatRoom blockChatroomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error) {
        return nativeBlockChatroomMembers(chatRoomId, members, error);
    }

    native EMAChatRoom nativeBlockChatroomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error);

    public EMAChatRoom unblockChatRoomMembers(
           String chatRoomId,
           List<String> members,
           EMAError error) {
        return nativeUnblockChatroomMembers(chatRoomId, members, error);
    }

    native EMAChatRoom nativeUnblockChatroomMembers(
            String chatRoomId,
            List<String> members,
            EMAError error);

    public List<String> fetchChatRoomBlackList(
            String chatRoomId,
            int pageNum,
            int pageSize,
            EMAError error) {
        return nativeFetchChatRoomBlackList(chatRoomId, pageNum, pageSize, error);
    }

    native List<String> nativeFetchChatRoomBlackList(
            String chatRoomId,
            int pageNum,
            int pageSize,
            EMAError error);

    public EMAChatRoom addToWhiteList(
            String chatRoomId,
            List<String> members,
            EMAError error) {
        return nativeAddToWhiteList(chatRoomId, members, error);
    }

    native EMAChatRoom nativeAddToWhiteList(
            String chatRoomId,
            List<String> members,
            EMAError error);

    public EMAChatRoom removeFromWhiteList(
            String chatRoomId,
            List<String> members,
            EMAError error) {
        return nativeRemoveFromWhiteList(chatRoomId, members, error);
    }

    native EMAChatRoom nativeRemoveFromWhiteList(
            String chatRoomId,
            List<String> members,
            EMAError error);

    public boolean checkIfInWhiteList(String chatRoomId, EMAError error) {
        return nativeCheckIfInWhiteList(chatRoomId, error);
    }
    native boolean nativeCheckIfInWhiteList(String chatRoomId, EMAError error);

    public List<String> fetchChatRoomWhiteList(String chatRoomId, EMAError error) {
        return  nativeFetchChatRoomWhiteList(chatRoomId, error);
    }
    native List<String> nativeFetchChatRoomWhiteList(String chatRoomId, EMAError error);

    public EMAChatRoom muteAllMembers(String chatRoomId, EMAError error) {
        return nativeMuteAllMembers(chatRoomId, error);
    }
    native EMAChatRoom nativeMuteAllMembers(String chatRoomId, EMAError error);

    public EMAChatRoom unmuteAllMembers(String chatRoomId, EMAError error) {
        return nativeUnmuteAllMembers(chatRoomId, error);
    }
    native EMAChatRoom nativeUnmuteAllMembers(String chatRoomId, EMAError error);

    public EMCursorResult<EMAChatRoom> fetchChatroomsWithCursor(
            String cursor,
            int pageSize,
            EMAError error) {
        return nativeFetchChatroomsWithCursor(cursor, pageSize, error);
    }
    native EMCursorResult<EMAChatRoom> nativeFetchChatroomsWithCursor(
            String cursor,
            int pageSize,
            EMAError error);
    // ============================= group_reform new add api end

    public String fetchChatRoomAnnouncement(String chatRoomId, EMAError error){
        return nativeFetchChatroomAnnouncement(chatRoomId, error);
    }
    native String nativeFetchChatroomAnnouncement(String chatRoomId, EMAError error);

    public void updateChatRoomAnnouncement(String chatRoomId, String announcement, EMAError error){
        nativeUpdateChatroomAnnouncement(chatRoomId, announcement, error);
    }
    native void nativeUpdateChatroomAnnouncement(String chatRoomId, String announcement, EMAError error);

    public String setChatroomAttributes(String chatRoomId, String jsonString , boolean forced,EMAError error){
       return nativeSetChatroomAttributes(chatRoomId,jsonString,forced,error);
    }

    native String nativeSetChatroomAttributes(String chatRoomId, String jsonString , boolean forced,EMAError error);

    public String fetchChatroomAttributes(String chatRoomId, List<String> key, EMAError error){
        return nativeFetchChatroomAttributes(chatRoomId,key,error);
    }

    native String nativeFetchChatroomAttributes(String chatRoomId, List<String> key, EMAError error);

    public String removeChatroomAttributes(String chatRoomId, List<String> key, boolean forced,EMAError error){
        return nativeRemoveChatroomAttributes(chatRoomId,key,forced,error);
    }

    native String nativeRemoveChatroomAttributes(String chatRoomId, List<String> key,boolean forced,EMAError error);

    public boolean checkIfBeMuted(String chatRoomId, EMAError error) {
        return nativeCheckIfBeMuted(chatRoomId, error);
    }
    native boolean nativeCheckIfBeMuted(String chatRoomId, EMAError error);
}
