/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMRTCTokenInfo;

import java.util.List;
import java.util.Map;

/**
 * Easemob Adapter
 * @author linan
 *
 */
public class EMAChatClient extends EMABase {
	
	public static EMAChatClient create(EMAChatConfig chatConfig) {
		EMAChatClient obj = new EMAChatClient();
		obj.nativeHandler = native_create(chatConfig);
		
		if (obj.getChatManager() == null) {
			obj.chatManager = new EMAChatManager();
			obj.getChatManager().nativeHandler = obj.native_getChatManager();
		}
		
		if (obj.getChatRoomManager() == null) {
			obj.chatRoomManager = new EMAChatRoomManager();
			obj.getChatRoomManager().nativeHandler = obj.native_getChatRoomManager();
		}

		if (obj.getGroupManager() == null) {
			obj.groupManager = new EMAGroupManager();
			obj.getGroupManager().nativeHandler = obj.native_getGroupManager();
		}
		
		if (obj.getContactManager() == null) {
			obj.contactManager = new EMAContactManager();
			obj.getContactManager().nativeHandler = obj.native_getContactManager();
		}

		if (obj.getPushMnager() == null) {
			obj.pushManager = new EMAPushManager();
			obj.getPushMnager().nativeHandler = obj.native_getPushManager();
		}

		if (obj.getUserInfoManager() == null) {
			obj.userInfoManager = new EMAUserInfoManager();
			obj.getUserInfoManager().nativeHandler = obj.native_getUserInfoManager();
		}

		if(obj.getSessionManager() == null) {
		    obj.sessionManager = new EMASessionManager();
		    obj.getSessionManager().nativeHandler = obj.native_getSessionManager();
		}

		if(obj.getTranslateManager() == null){
			obj.translateManager = new EMATranslateManager();
			obj.getTranslateManager().nativeHandler = obj.native_getTranslateManager();
		}
		if(obj.getPresenceManager() == null){
			obj.presenceManager = new EMAPresenceManager();
			obj.getPresenceManager().nativeHandler = obj.native_getPresenceManager();
		}

		if (obj.getReactionManager() == null) {
			obj.reactionManager = new EMAReactionManager();
			obj.getReactionManager().nativeHandler = obj.native_getReactionManager();
		}

		if(obj.getThreadManager() == null){
			obj.threadManager = new EMAThreadManager();
			obj.getThreadManager().nativeHandler = obj.native_getThreadManager();
		}

		if(obj.getStatisticsManager() == null){
			obj.statisticsManager = new EMAStatisticsManager();
			obj.getStatisticsManager().nativeHandler = obj.native_getStatisticsManager();
		}
		return obj;
	}

	public void login(String username, String code, boolean autoLogin, int loginType, EMAError error) {
		native_login(username, code, autoLogin, loginType, error);
	}

	public String getUserToken(boolean fetchFromServer, EMAError error) {
		return native_getUserToken(fetchFromServer, error);
	}

	public String getUserTokenFromServer(String username, String password, EMAError error) {
		return native_getUserTokenFromServer(username, password, error);
	}
	
	public void logout() {
		native_logout();
	}
	
	public EMAError createAccount(String username, String password) {
		return native_createAccount(username, password); 
	}

	public EMAError changeAppkey(String appkey) {
	    return native_changeAppkey(appkey);
	}

	public EMAError changeAppId(String appId) {
		return native_changeAppId(appId);
	}
	
	public EMAChatManager getChatManager() {
		return chatManager;
	}

	public EMAChatRoomManager getChatRoomManager() {
		return chatRoomManager;
	}
	
	public EMAGroupManager getGroupManager() {
		return groupManager;
	}

	public EMAPushManager getPushMnager() {
		return pushManager;
	}

	public EMAContactManager getContactManager() {
		return contactManager;
	}

	public EMAUserInfoManager getUserInfoManager() {return  userInfoManager;}

	public EMASessionManager getSessionManager() {return sessionManager;}

	public EMATranslateManager getTranslateManager() {return translateManager;}

	public EMAPresenceManager getPresenceManager() {return presenceManager;}

	public EMAReactionManager getReactionManager() {return reactionManager;}

	public EMAThreadManager getThreadManager() {
		return threadManager;
	}

	public EMAStatisticsManager getStatisticsManager() {
		return statisticsManager;
	}


	public void addConnectionListener(EMAConnectionListener listener) {
		native_addConnectionListener(listener);
	}
	
	public void removeConnectionListener(EMAConnectionListener listener) {
		native_removeConnectionListener(listener);
	}

	public void addMultiDeviceListener(EMAMultiDeviceListener listener) {
		native_addMultiDeviceListener(listener);
	}

	public void addLogCallbackListener(EMALogCallbackListener listener) {
		native_addLogCallbackListener(listener);
	}

	public void removeLogCallbackListener(EMALogCallbackListener listener) {
		native_removeLogCallbackListener(listener);
	}

	public boolean sendPing(boolean waitPong, long timeout){
		return native_sendPing(waitPong,timeout);
	}
	
	public void disconnect(){
		native_disconnect();
	}
	
	public void reconnect(){
		natvie_reconnect();
	}
	
	public void onNetworkChanged(EMANetwork network) {
	    native_onNetworkChanged(network.ordinal());
	}
	
	public boolean isConnected(){
		return native_isConnected();
	}

	public boolean isLogout() { return native_isLogout(); }

	public String compressLogs(EMAError error) {
		return native_compressLogs(error);
	}

	public List<EMADeviceInfo> getLoggedInDevicesFromServer(String username, String password, EMAError error) {
		return nativeGetLoggedInDevicesFromServer(username, password, error);
	}
	public List<EMADeviceInfo> getLoggedInDevicesFromServerWithToken(String username, String token, EMAError error) {
		return nativeGetLoggedInDevicesFromServerWithToken(username, token, error);
	}

	public void kickDevice(String username, String password, String resource, EMAError error) {
		nativeKickDevice(username, password, resource, error);
	}

	public void kickAllDevices(String username, String password, EMAError error) {
		nativeKickAllDevices(username, password, error);
	}

	public void kickDeviceWithToken(String username, String token, String resource, EMAError error) {
		nativeKickDeviceWithToken(username, token, resource, error);
	}

	public void kickAllDevicesWithToken(String username, String token, EMAError error) {
		nativeKickAllDevicesWithToken(username, token, error);
	}

	// Add by zhangsong for service check.
	public void check(String username, String password, CheckResultListener listener) {
		nativeCheck(username, password, listener);
	}

	public boolean isLoggedIn() { return native_isLoggedIn(); }

	public void renewToken(String newTokn) {  native_renewToken(newTokn); }

	public long getTokenExpiredTs(String newToken, EMAError error) {
		return nativeGetTokenExpiredTs(newToken, error);
	}

	public static class CheckResultListener {
		public void onResult(int type, int result, String desc) {}
	}

	public EMRTCTokenInfo getRTCTokenInfoWithChannelName(String channelName, EMAError error) {
		return nativeGetRTCTokenInfoWithChannelName(channelName, error);
	}

	native EMRTCTokenInfo nativeGetRTCTokenInfoWithChannelName(String channelName, EMAError error) ;

	public Map<Integer, String> mapUserIdsWithRTCUids(List<Integer> uIds, EMAError error) {
		return nativeMapUserIdsWithRTCUids(uIds, error);
	}

	native Map<Integer, String> nativeMapUserIdsWithRTCUids(List<Integer> uIds, EMAError error);

	native static long native_create(EMAChatConfig chatConfig);
	native EMAError native_createAccount(String username, String password);
	native void native_login(String username, String code, boolean autoLogin, int loginType, EMAError error);
	native String native_getUserToken(boolean fetchFromServer, EMAError error);
	native String native_getUserTokenFromServer(String username, String password, EMAError error);
	native void native_logout();
	native EMAError native_changeAppkey(String appkey);
	native EMAError native_changeAppId(String appId);
	native long native_getChatManager();
	native long native_getCallManager();
	native long native_getGroupManager();
	native long native_getContactManager();
	native long native_getChatRoomManager();
	native long native_getPushManager();
	native long native_getRtcConfigManager();
	native long native_getUserInfoManager();
	native long native_getSessionManager();
	native long native_getTranslateManager();
	native long native_getPresenceManager();
	native long native_getReactionManager();
	native long native_getThreadManager();
	native long native_getStatisticsManager();
	native void native_onNetworkChanged(int network);
	native List<EMADeviceInfo> nativeGetLoggedInDevicesFromServer(String username, String password, EMAError error);
	native List<EMADeviceInfo> nativeGetLoggedInDevicesFromServerWithToken(String username, String token, EMAError error);
	native void nativeKickDevice(String username, String password, String resource, EMAError error);
	native void nativeKickAllDevices(String username, String password, EMAError error);
	native void nativeKickDeviceWithToken(String username, String token, String resource, EMAError error);
	native void nativeKickAllDevicesWithToken(String username, String token, EMAError error);

	public enum EMANetwork {
	    NETWORK_NONE,
	    NETWORK_CABLE,
	    NETWORK_WIFI,
	    NETWORK_MOBILE
	}

	native void native_addConnectionListener(EMAConnectionListener listener);
	native void native_removeConnectionListener(EMAConnectionListener listener);
	native void native_addMultiDeviceListener(EMAMultiDeviceListener listener);
	native void native_removeMultiDeviceListener(EMAMultiDeviceListener listener);
	native void native_addLogCallbackListener(EMALogCallbackListener listener);
	native void native_removeLogCallbackListener(EMALogCallbackListener listener);

	native boolean native_sendPing(boolean waitPong, long timeout);
	native void native_disconnect();
	native void natvie_reconnect();
	native boolean native_isConnected();
	native boolean native_isLogout();
	native boolean native_isLoggedIn();
	native void native_renewToken(String newToken);
	native String native_compressLogs(EMAError error);
	// Add by zhangsong for service check.
	native void nativeCheck(String username, String password, CheckResultListener listener);

	native long nativeGetTokenExpiredTs(String newToken, EMAError error);

	private EMAChatManager chatManager = null;
	private EMAChatRoomManager chatRoomManager = null;
	private EMAGroupManager groupManager = null;
	private EMAContactManager contactManager = null;
	private EMAPushManager pushManager = null;
	private EMAUserInfoManager userInfoManager = null;
	private EMASessionManager sessionManager = null;
	private EMATranslateManager translateManager = null;
	private EMAPresenceManager presenceManager = null;
	private EMAReactionManager reactionManager = null;
	private EMAThreadManager threadManager = null;
	private EMAStatisticsManager statisticsManager = null;
}
