package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMASilentModeTime;

/**
 * \~chinese
 * 离线推送免打扰时间类。
 * 
 * 对于免打扰时间段，你需要设置该时间段的开始时间和结束时间。
 *
 * \~english
 * 
 * The do-not-disturb time class.
 * 
 * For the do-not-disturb time frame, you need to set both the start time and end time of the period.
 *
 */
public class EMSilentModeTime extends EMBase<EMASilentModeTime> {

    public EMSilentModeTime(int hour, int minute){
        emaObject = new EMASilentModeTime(hour, minute);
    }

    public EMSilentModeTime(EMASilentModeTime time){
        emaObject = time;
    }

    /**
     * \~chinese
     * 设置免打扰时间段的开始或结束的小时数。
     * 
     * 该时间采用 24 小时制，取值范围为 [0,23]。
     * 
     * @param hour 免打扰时间段的开始或结束的小时数。
     *
     * \~english
     * Sets the start or end hour of the do-not-disturb time frame.
     * 
     * The time is based on a 24-hour clock. The value range is [0,23].
     * 
     * @param hour The start or end hour of the do-not-disturb time frame.
     */
    public void setHour(int hour){
        emaObject.setHour(hour);
    }

    /**
     * \~chinese
     * 获取免打扰时间段的开始或结束的小时数。
     * 
     * 该时间为 24 小时制。
     * 
     * @return 免打扰时间段的开始或结束的小时数。
     *
     * \~english
     * Gets the start or end hour of the do-not-disturb time frame.
     * 
     * The time is based on a 24-hour clock.
     * 
     * @return The start or end hour of the do-not-disturb time frame.
     */
    public int getHour(){
        if(emaObject != null){
            return emaObject.getHour();
        }
        return 0;
    }

    /**
     * \~chinese
     * 设置免打扰时间段的开始或结束的分钟数。
     * 
     * @param minute 免打扰时间段的开始或结束的分钟数。
     *
     * \~english
     * Sets the start or end minute of the do-not-disturb time frame.
     * 
     * @param minute The start or end minute of the do-not-disturb time frame.
     *
     */
    public void setMinute(int minute){
        emaObject.setMinute(minute);
    }

    /**
     * \~chinese
     * 获取免打扰时间段的开始或结束的分钟数。
     * 
     * @return 免打扰时间段的开始或结束的分钟数。
     *
     * \~english
     * Gets the start or end minute of the do-not-disturb time frame.
     * 
     * @return The start or end minute of the do-not-disturb time frame.
     *
     */
    public int getMinute(){
        if(emaObject != null) {
            return emaObject.getMinute();
        }
        return 0;
    }
}
