/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.util.Base64;

import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;

public class EMEncryptUtils {
    private static final String TAG = "encrypt";   
    
    static String encryptMessage(String plainMsg, String toUserName) {
        try {
            EMEncryptProvider provider = EMClient.getInstance().getEncryptProvider();
            
            byte[] stringBytes = plainMsg.getBytes("UTF-8");
            EMLog.d(TAG, "utf-8 bytes:" + EasyUtils.convertByteArrayToString(stringBytes));

            byte[] encryptedBytes = provider.encrypt(stringBytes, toUserName);
            EMLog.d(TAG, "encrypted bytes:" + EasyUtils.convertByteArrayToString(encryptedBytes));
            byte[] base64Bytes = Base64.encode(encryptedBytes, Base64.DEFAULT);
            EMLog.d(TAG, "base64 bytes:" + EasyUtils.convertByteArrayToString(base64Bytes));
            
            String encryptedStr = new String(base64Bytes);
            EMLog.d(TAG, "encrypted str:" + encryptedStr);
            
            return encryptedStr;
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "encryption error, send plain msg");
            return plainMsg;
        }

    }
    
    static String decryptMessage(String encryptedMsg, String fromUserName) {
        try{ 
            EMLog.d(TAG, "encrypted str:" +encryptedMsg);
            byte[] input = Base64.decode(encryptedMsg, Base64.DEFAULT);
            EMLog.d(TAG, "base64 decode bytes:" + EasyUtils.convertByteArrayToString(input));
        
            EMEncryptProvider provider = EMClient.getInstance().getEncryptProvider();
            byte[] decriptedBytes = provider.decrypt(input, fromUserName);
            EMLog.d(TAG, "decrypt bytes:" + EasyUtils.convertByteArrayToString(decriptedBytes));
            String decryptedStr =  new String(decriptedBytes, "UTF-8");
        
            EMLog.d(TAG, "descripted str:" + decryptedStr);
            return decryptedStr;
        } catch (Exception e) {
            e.printStackTrace();
            return encryptedMsg;
        }
    }
    
    /**
     * \~chinese
     * 加密文件。
     * @param filePath 被加密的文件路径。
     * @param toUserName 对方的用户 ID。
     * @return 返回一个加密后的文件的临时路径。
     * 
     * \~english
     * Encrypts the attachment file.
     * @param filePath  The absolute path of the attachment file.
     * @param toUserName The user ID of the message receiver.
     * @return Returns a encrypted file's temporary path.
     */
    public static String encryptFile(String filePath, String toUserName) {
        RandomAccessFile f = null;
        FileOutputStream fos = null;
        try {
            EMLog.d(TAG, "try to encrypt file:" + filePath);
            f = new RandomAccessFile(filePath, "r");
            int fileLen = (int)f.length();
            EMLog.d(TAG, "try to encrypt file:" + filePath + " original len:" + fileLen);
            byte[] b = new byte[fileLen];
            int readLen = f.read(b);
            if (readLen != fileLen) {
                EMLog.e(TAG, "error read file, file len:" + fileLen + " readLen:" + readLen);
                f.close();
                return filePath;
            }
            //The encrypt bytes
            EMEncryptProvider provider = EMClient.getInstance().getEncryptProvider();
            byte[] encryptedBytes = provider.encrypt(b, toUserName);
            
            //The read file into byte array.
            String extension = null;
            int i = filePath.lastIndexOf('.');
            if (i >= 0) {
                extension = filePath.substring(i);
            }
            File tempFile = File.createTempFile("encrypted", extension);
            fos = new FileOutputStream(tempFile);
            fos.write(encryptedBytes);
            String retPath = tempFile.getAbsolutePath();
            EMLog.d(TAG, "generated encrypted file:" + retPath);
            return retPath;
        } catch (Exception e) {
            e.printStackTrace();
            return filePath;
        } finally {
            if (f != null){
                try {
                    f.close();
                } catch (Exception ignore) {

                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (Exception ignore) {

                }
            }
        }
    }
    
    /**
     * \~chinese
     * 解密文件，会覆盖原来文件。
     * 
     * @param filePath 文件路径。
     * @param fromUserName 对方的用户 ID。
     * 
     * \~english
     * Decrypts the attachment file, the action will overwrite the original file.
     * @param filePath The attachment file's absolute path.
     * @param fromUserName The username of the message sender.
     */
    public static void decryptFile(String filePath, String fromUserName) {
        RandomAccessFile f = null;
        FileOutputStream fos = null;
        try {
            EMLog.d(TAG, "decrypt file:" + filePath);
            //read file into bytes[]
            f = new RandomAccessFile(filePath, "r");
            int fileLen = (int)f.length();
            byte[] b = new byte[fileLen];
            int readLen = f.read(b);
            if (readLen != fileLen) {
                EMLog.e(TAG, "error read file, file len:" + fileLen + " readLen:" + readLen);
                return;
            }
        
            //get decrypted bytes[]
            EMEncryptProvider provider = EMClient.getInstance().getEncryptProvider();
            byte[] decryptedBytes = provider.decrypt(b, fromUserName);
    
            //write back to origin file
            fos = new FileOutputStream(filePath, false);
            fos.write(decryptedBytes);
            EMLog.d(TAG, "decrypted file:" + filePath);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (f != null){
                try {
                    f.close();
                } catch (Exception ignore) {

                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (Exception ignore) {

                }
            }
        }
    }
}
