/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMACmdMessageBody;

import java.util.Map;

/**
 * \~chinese
 * 命令消息体。
 *
 * ```java
 *     EMCmdMessageBody body = new EMCmdMessageBody("delete", null);
 * ```
 *
 * \~english
 * The command message body.
 *
 * ```java
 *     EMCmdMessageBody body = new EMCmdMessageBody("delete", null);
 * ```
 *
 */
public class EMCmdMessageBody extends EMMessageBody implements Parcelable {
	
    /**
     * \~chinese
     * 创建一个命令消息。
     *
     * @param action  命令内容。
     * 
     * \~english
     * Creates a command message.
     *
     * @param action The command action content.
     */
    public EMCmdMessageBody(String action) {
    	emaObject = new EMACmdMessageBody(action);
    }
    
    EMCmdMessageBody(EMACmdMessageBody body) {
    	this.emaObject = body;
    }
    
    /**
     * \~chinese
     * 获取 CMD 消息中的命令内容。
     *
     * @return CMD 消息中的命令内容。
     *
     * \~english
     * Gets the command action content.
     *
     * @return The command action content.
     */
    public String action() {
    	return ((EMACmdMessageBody)emaObject).action();
    }

    /**
     * \~chinese
     * 判断当前 CMD 类型消息是否只投递在线用户。
     * @return - `true`：只投递在线用户。
     * - `false`：投递所有用户。
     *
     * \~english
     * Checks whether this CMD message is only delivered to online users.
     * @return Whether this CMD message is only delivered to online users
     * - `true`: Only delivers to online users.
     * - `false`: Delivers to all users. 
     */
    public boolean isDeliverOnlineOnly() {
        return ((EMACmdMessageBody)emaObject).isDeliverOnlineOnly();
    }

    /**
     * \~chinese
     * 设置当前 CMD 类型消息是否只投递在线用户。
     *
     * @param onlineOnly    是否只投递给在线用户。
     *                      - （默认） `false`：投递所有用户；
     *                      - `true` ：只投递在线用户，这样离线用户上线时不会收到该消息。
     *
     * \~english
     * Sets whether the current cmd msg is only delivered to online users. 
     *
     * @param onlineOnly    Whether to deliver to online users only. 
     *                      - (Default)`false`: The message is delivered to all users. 
     *                      - `true`: The message is delivered to the online users only, so the offline users won't receive the message when they log in later.
     */
    public void deliverOnlineOnly(boolean onlineOnly) {
        ((EMACmdMessageBody)emaObject).deliverOnlineOnly(onlineOnly);
    }

    /**
     * \~chinese
     * 展示 CMD 消息的命令。
     * @return  命令的内容展示。
     *
     * \~english
     * Gets and displays the content of the CMD message.
     * @return   The content of the action of the CMD message.
     */
    public String toString() {
        return "cmd:\"" + ((EMACmdMessageBody)emaObject).action() + "\"";
    }

	@Override
	public int describeContents() {
		return 0;
	}

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACmdMessageBody)emaObject).action());
    }
    
    public static final Parcelable.Creator<EMCmdMessageBody> CREATOR
            = new Parcelable.Creator<EMCmdMessageBody>() {
        public EMCmdMessageBody createFromParcel(Parcel in) {
            return new EMCmdMessageBody(in);
        }

        public EMCmdMessageBody[] newArray(int size) {
            return new EMCmdMessageBody[size];
        }
    };

    private EMCmdMessageBody(Parcel in) {
    	emaObject = new EMACmdMessageBody(in.readString());
    }
}
