package com.hyphenate;


/**
 *  \~chinese
 * 带参数的回调函数。
 * 不带参数的回调函数见 {@link EMCallBack}。
 *
 * @param <T> 参数类型。
 *
 *  \~english
 * The callback function with a parameter.
 * For the callback function without a parameter, see {@link EMCallBack}.
 *
 * @param <T> value     The parameter type.
 */
public interface EMResultCallBack<T> {
    /**
     * \~chinese
     * 回调结果
     *
     * @param code      参考 EMError code
     * @param value     value 的 class 类型是 T。
     *
     * \~english
     * Callback result
     *
     * @param code     Reference EMError code
     * @param value    The class type of value is T.
     *
     */
    void onResult(final int code,T value);

}
