package com.hyphenate.cloud;


import com.hyphenate.chat.EMClient;

import java.net.HttpURLConnection;
import java.util.Map;


public class HttpClientConfig {
    private static final String TAG = HttpClientConfig.class.getSimpleName();
    private static final String EASEMOB_USERSERVER_DOMAIN_ID = "hyphenate.com";
    private static final String EASEMOB_PLATFORM="Android";
    public static String EM_TIME_OUT_KEY = "em_timeout";
    public static int EM_DEFAULT_TIMEOUT = 60*1000;


    /**
     * if is hyphenate server , https replace http, because http is quickly than
     * https
     */
    public static String getEaseMobUserServerDomainId() {
        return EASEMOB_USERSERVER_DOMAIN_ID;
    }

    /**
     * 为每个HttpClient添加User-Agent
     * @return
     */
    public static String getDefaultUserAgent() {
        String sb = "Easemob-SDK(" +
                EASEMOB_PLATFORM +
                ") " +
                EMClient.getInstance().VERSION;
        return sb;
    }

    static String getNewHost(final String reqUrl, final String baseUrl) {
        String s = reqUrl.substring(reqUrl.indexOf("/", 8));	// trim base part
        s = s.substring(s.indexOf("/", 1));						// trim appkey_pre#
        s = s.substring(s.indexOf("/", 1));						// trim #appkey_post
        return baseUrl + s;
    }

    public static Map<String,String> addDomainToHeaders(Map<String,String> headers){
        return headers;
    }

    /**
     * 检测remoteFilePath是完整的url还是uuid，如果是uuid则需要拼接成真正的url
     * @param remoteFilePath
     * @return
     */
    public static String getFileRemoteUrl(String remoteFilePath) {
        if (remoteFilePath.startsWith("http")) {
            return remoteFilePath;
        }
        String remoteUrl = getFileDirRemoteUrl();
        remoteUrl += remoteFilePath;
        return remoteUrl;
    }

    /**
     * get upload download remote-url eg.image audio ect.
     * @return
     */
    public static String getFileDirRemoteUrl() {
        String remoteUrl = getBaseUrlByAppKey();
        remoteUrl += "/chatfiles/";
        return remoteUrl;
    }

    /**
     * the base remote url with appkey
     * @return
     */
    public static String getBaseUrlByAppKey(){
        return EMHttpClient.getInstance().chatConfig().getBaseUrl(true, false);
    }

    public static String processUrl(String remoteUrl){
        if (remoteUrl.contains("+")) {
            remoteUrl = remoteUrl.replaceAll("\\+", "%2B");
        }

        if (remoteUrl.contains("#")) {
            remoteUrl = remoteUrl.replaceAll("#", "%23");
        }

        return remoteUrl;
    }

    public static int getTimeout(Map<String,String> headers){
        int timeout = HttpClientConfig.EM_DEFAULT_TIMEOUT;

        if(headers != null && headers.get(HttpClientConfig.EM_TIME_OUT_KEY) != null){
            timeout = Integer.valueOf(headers.get(HttpClientConfig.EM_TIME_OUT_KEY));
            headers.remove(HttpClientConfig.EM_TIME_OUT_KEY);
        }

        return timeout;
    }

    static void checkAndProcessSSL(String url, HttpURLConnection conn) {
    }

}
