/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

/**
 * \~chinese
 * 加解密接口类。
 * SDK 内置了基于 AES 的加密算法。
 * 用户可以实现 EncryptProvider，提供自己的加解密算法，对消息和附件进行加密/解密。
 * 
 * 设置消息加密：
 * ```java
 *       EaseMobChat.getInstance().setEncryptionMode(true);
 *       EaseMobChat.getInstance().setEncryptProvider(new MyEncryptProvider());
 * ```
 * 
 * 发送消息时：如果设置了消息加密系统会在发送消息前，调用用户设置的 EncryptProvider 来加密。
 * 收到消息时：如果是加密消息，SDK 会调用用户设置的 EncryptProvider 来解密。
 *
 * \~english
 * The encryption and decryption class.
 * 
 * You can use built-in encryption and decryption alogrithms based on AES or build your own algorithms by usin EncryptProvider to encrypt or decrypt messages and attachments.
 * 
 * For example, encryption:
 * ```java
 *       EaseMobChat.getInstance().setEncryptionMode(true);
 *       EaseMobChat.getInstance().setEncryptProvider(new MyEncryptProvider());
 * ```
 * 
 * When sending a message, if EncryptProvider is configured, the SDK will call the encryption method to encrypt the message before delivery.
 * While receiving a message, if this message is encrypted, the SDK will call the EncryptProvider to decrypt it.
 * 
 */
interface EMEncryptProvider {
    
    /**
     * \~chinese
     * 加密函数。
     * 
     * @param input 输入未加密的 byte array。
     * @param toUserName 消息接收方的用户名。
     * @return 返回加密后的 byte array。
     * 
     * \~english
     * The encryption method.
     * 
     * @param input The byte array to be encrypted.
     * @param toUserName The user ID of the other side of the conversation.
     * @return Returns the encrypted byte array.
     */
    byte[] encrypt(byte[] input, String toUserName);
    
    /**
     * \~chinese
     * 解密函数。
     * @param input 输入已加密的 byte array。
     * @param fromUserName 消息发送方的用户名。
     * @return 返回解密后的 byte array。
     * 
     * \~english
     * The decryption method.
     *
     * @param input The encrypted byte array.
     * @param fromUserName The username of the message sender.
     * 
     * @return Returns the decrypted byte array.
     * 
     */
    byte[] decrypt(byte[] input, String fromUserName);
    
}
