/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.format.Time;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class VoiceRecorder {
    static final String PREFIX = "voice";
    static final String EXTENSION = ".amr";
    MediaRecorder recorder;
    private boolean isRecording = false;
    private long startTime;
    private String voiceFileName = null;
    private File file;
    private Handler handler;

    /*
     * WARNING - void declaration
     */
    public VoiceRecorder(Handler handler) {
        void var1_1;
        this.handler = var1_1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String startRecording(String appKey, String userId, Context appContext) {
        long l;
        block8: {
            block7: {
                File file;
                File file2;
                MediaRecorder mediaRecorder;
                Object object;
                block6: {
                    this.file = null;
                    try {
                        object = this.recorder;
                        if (object == null) break block6;
                    }
                    catch (IOException iOException) {
                        break block7;
                    }
                    {
                        object.release();
                        this.recorder = null;
                    }
                }
                object = mediaRecorder;
                {
                    this.recorder = object;
                    new MediaRecorder().setAudioSource(1);
                    this.recorder.setOutputFormat(3);
                    this.recorder.setAudioEncoder(1);
                    this.recorder.setAudioChannels(1);
                    this.recorder.setAudioSamplingRate(8000);
                    this.recorder.setAudioEncodingBitRate(64);
                    this.voiceFileName = this.getVoiceFileName((String)((Object)file2));
                    object = this.getVoiceFilePath();
                }
                file2 = file;
                {
                    file = new File((String)object);
                    this.file = file2;
                    this.recorder.setOutputFile(file2.getAbsolutePath());
                    this.recorder.prepare();
                    this.isRecording = true;
                    this.recorder.start();
                    break block8;
                }
            }
            EMLog.e(PREFIX, "prepare() failed");
        }
        new Thread(new Runnable(this){
            final /* synthetic */ VoiceRecorder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block7: {
                    while (true) {
                        Message message;
                        if (!this.this$0.isRecording) break block7;
                        1 v0 = this;
                        Message message2 = message;
                        message2();
                        int n = this.this$0.recorder.getMaxAmplitude();
                        message.what = n * 13 / Short.MAX_VALUE;
                        v0.this$0.handler.sendMessage(message2);
                        SystemClock.sleep((long)100L);
                        continue;
                        break;
                    }
                    catch (Exception exception) {
                        EMLog.e(VoiceRecorder.PREFIX, ((Object)exception).toString());
                    }
                }
            }
        }).start();
        this.startTime = l = new Date().getTime();
        EMLog.d(PREFIX, "start voice recording to file:" + this.file.getAbsolutePath());
        return this.file.getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardRecording() {
        block5: {
            block4: {
                Object object = this.recorder;
                if (object == null) break block5;
                try {
                    VoiceRecorder voiceRecorder = this;
                    object.stop();
                    voiceRecorder.recorder.release();
                    voiceRecorder.recorder = null;
                    object = voiceRecorder.file;
                    if (object == null || !((File)object).exists() || this.file.isDirectory()) break block4;
                    this.file.delete();
                }
                catch (RuntimeException runtimeException) {
                }
                catch (IllegalStateException illegalStateException) {}
            }
            this.isRecording = false;
        }
    }

    public int stopRecoding() {
        Object object = this.recorder;
        if (object != null) {
            VoiceRecorder voiceRecorder = this;
            this.isRecording = false;
            object.stop();
            voiceRecorder.recorder.release();
            voiceRecorder.recorder = null;
            object = voiceRecorder.file;
            if (object != null && ((File)object).exists() && this.file.isFile()) {
                if (this.file.length() == 0L) {
                    this.file.delete();
                    return 401;
                }
                int n = (int)(new Date().getTime() - this.startTime) / 1000;
                EMLog.d(PREFIX, "voice recording finished. seconds:" + n + " file length:" + this.file.length());
                return n;
            }
            return 401;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        VoiceRecorder voiceRecorder = this_;
        super.finalize();
        VoiceRecorder this_ = voiceRecorder.recorder;
        if (this_ != null) {
            this_.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getVoiceFileName(String uid) {
        void var1_1;
        Time time;
        VoiceRecorder voiceRecorder = time;
        new Time().setToNow();
        return (String)var1_1 + voiceRecorder.toString().substring(0, 15) + EXTENSION;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public String getVoiceFilePath() {
        return PathUtil.getInstance().getVoicePath() + "/" + this.voiceFileName;
    }
}

