/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.UriUtils;
import com.hyphenate.util.VersionUtils;
import java.io.File;

public class EMFileHelper {
    private Context mContext = EMClient.getInstance().getContext();
    private IFilePresenter mHelper = new FilePresenterImpl();

    private EMFileHelper() {
    }

    public static EMFileHelper getInstance() {
        return EMFileHelperInstance.instance;
    }

    /*
     * WARNING - void declaration
     */
    public void setFileHelper(IFilePresenter presenter) {
        void var1_1;
        this.mHelper = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFileExist(Uri fileUri) {
        void var1_1;
        return this.mHelper.isFileExist(this.mContext, (Uri)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFileExist(String stringUri) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)stringUri)) {
            return false;
        }
        return this.isFileExist(Uri.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFileExist(Context context, Uri fileUri) {
        void var2_2;
        void var1_1;
        return this.mHelper.isFileExist((Context)var1_1, (Uri)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFileExist(Context context, String stringUri) {
        void var2_2;
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)stringUri)) {
            return false;
        }
        return this.isFileExist((Context)var1_1, Uri.parse((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String getFilename(Uri fileUri) {
        void var1_1;
        return this.mHelper.getFilename(this.mContext, (Uri)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getFilename(String filePath) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        return this.getFilename(Uri.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getFilePath(Uri fileUri) {
        void var1_1;
        return this.mHelper.getFilePath(this.mContext, (Uri)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getFilePath(String filePath) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return var1_1;
        }
        return this.getFilePath(Uri.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getFilePath(Context context, Uri fileUri) {
        void var2_2;
        void var1_1;
        return this.mHelper.getFilePath((Context)var1_1, (Uri)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String getFilePath(Context context, String filePath) {
        void var1_1;
        void var2_2;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return var2_2;
        }
        return this.getFilePath((Context)var1_1, Uri.parse((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public long getFileLength(Uri fileUri) {
        void var1_1;
        if (fileUri == null) {
            return 0L;
        }
        return this.mHelper.getFileLength(this.mContext, (Uri)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long getFileLength(String filePath) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return 0L;
        }
        return this.getFileLength(Uri.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getFileMimeType(Uri fileUri) {
        void var1_1;
        return this.mHelper.getFileMimeType(this.mContext, (Uri)var1_1);
    }

    public boolean deletePrivateFile(String filePath) {
        File file;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        if (!((EMFileHelper)this).isFileExist((String)((Object)file))) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((EMFileHelper)this).getFilePath(Uri.parse((String)((Object)file)))))) {
            File file2;
            file = file2;
            if (new File((String)this).exists()) {
                return file.delete();
            }
        }
        return false;
    }

    public Uri formatInUri(Uri fileUri) {
        Uri uri;
        if (fileUri == null) {
            return null;
        }
        if (VersionUtils.isTargetQ(((EMFileHelper)this).mContext) && UriUtils.uriStartWithContent(uri)) {
            return uri;
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((EMFileHelper)this).getFilePath(uri)))) {
            uri = Uri.parse((String)this);
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    public Uri formatInUri(File file) {
        void var1_1;
        if (file == null) {
            return null;
        }
        return Uri.parse((String)var1_1.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     */
    public Uri formatInUri(String filePath) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        return this.formatInUri(Uri.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String formatInUriToString(Uri uri) {
        void var1_1;
        if ((this = this.formatInUri((Uri)var1_1)) == null) {
            return "";
        }
        return this.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String formatInUriToString(File file) {
        void var1_1;
        if ((this = this.formatInUri((File)var1_1)) == null) {
            return "";
        }
        return this.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String formatInUriToString(String filePath) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        return this.formatInUriToString(Uri.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String formatOutLocalUrl(String filePath) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return var1_1;
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((EMFileHelper)this).getFilePath((String)var1_1)))) {
            return this;
        }
        return var1_1;
    }

    public Uri formatOutUri(String filePath) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        uri = Uri.parse((String)uri);
        if (VersionUtils.isTargetQ(((EMFileHelper)this).mContext) && UriUtils.uriStartWithContent(uri)) {
            return uri;
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((EMFileHelper)this).getFilePath(uri)))) {
            uri = Uri.fromFile((File)new File((String)this));
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    public String uriToString(Uri fileUri) {
        void var1_1;
        if (fileUri == null) {
            return "";
        }
        return var1_1.toString();
    }

    public static class FilePresenterImpl
    implements IFilePresenter {
        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isFileExist(Context context, Uri fileUri) {
            void var2_2;
            return UriUtils.isFileExistByUri(context, (Uri)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getFilename(Context context, Uri fileUri) {
            void var2_2;
            return UriUtils.getFileNameByUri(context, (Uri)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getFilePath(Context context, Uri fileUri) {
            void var2_2;
            return UriUtils.getFilePath(context, (Uri)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getFileLength(Context context, Uri fileUri) {
            void var2_2;
            return UriUtils.getFileLength(context, (Uri)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getFileMimeType(Context context, Uri fileUri) {
            void var2_2;
            return UriUtils.getMimeType(context, (Uri)var2_2);
        }
    }

    public static interface IFilePresenter {
        public boolean isFileExist(Context var1, Uri var2);

        public String getFilename(Context var1, Uri var2);

        public String getFilePath(Context var1, Uri var2);

        public long getFileLength(Context var1, Uri var2);

        public String getFileMimeType(Context var1, Uri var2);
    }

    private static class EMFileHelperInstance {
        private static final EMFileHelper instance = new EMFileHelper();

        private EMFileHelperInstance() {
        }
    }
}

