/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.File;

abstract class DocumentFile {
    static final String TAG = "DocumentFile";
    private final DocumentFile mParent;

    /*
     * WARNING - void declaration
     */
    DocumentFile(DocumentFile parent) {
        void var1_1;
        this.mParent = var1_1;
    }

    public static DocumentFile fromFile(File file) {
        File file2;
        if (file == null) {
            return null;
        }
        return new RawDocumentFile(null, file2);
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentFile fromSingleUri(Context context, Uri singleUri) {
        if (Build.VERSION.SDK_INT >= 19) {
            void var1_1;
            Context context2;
            return new SingleDocumentFile(null, context2, (Uri)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDocumentUri(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19) {
            void var1_1;
            Context context2;
            return DocumentsContract.isDocumentUri((Context)context2, (Uri)var1_1);
        }
        return false;
    }

    public abstract Uri getUri();

    public abstract String getName();

    public abstract String getType();

    public DocumentFile getParentFile() {
        return this.mParent;
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isVirtual();

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean delete();

    public abstract boolean exists();

    static class RawDocumentFile
    extends DocumentFile {
        private File mFile;

        /*
         * WARNING - void declaration
         */
        RawDocumentFile(DocumentFile parent, File file) {
            super((DocumentFile)var1_1);
            void var2_2;
            void var1_1;
            this.mFile = var2_2;
        }

        private static String getTypeForName(String name) {
            String string;
            int n = name.lastIndexOf(46);
            if (n >= 0 && (string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string.substring(n + 1).toLowerCase())) != null) {
                return string;
            }
            return "application/octet-stream";
        }

        private static boolean deleteContents(File dir) {
            File[] fileArray = dir.listFiles();
            boolean bl = true;
            if (fileArray != null) {
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        bl &= RawDocumentFile.deleteContents(file);
                    }
                    if (file.delete()) continue;
                    Log.w((String)DocumentFile.TAG, (String)("Failed to delete " + file));
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public Uri getUri() {
            return Uri.fromFile((File)this.mFile);
        }

        @Override
        public String getName() {
            return this.mFile.getName();
        }

        @Override
        public String getType() {
            if (this.mFile.isDirectory()) {
                return null;
            }
            return RawDocumentFile.getTypeForName(this.mFile.getName());
        }

        @Override
        public boolean isDirectory() {
            return this.mFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.mFile.isFile();
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public long lastModified() {
            return this.mFile.lastModified();
        }

        @Override
        public long length() {
            return this.mFile.length();
        }

        @Override
        public boolean canRead() {
            return this.mFile.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.mFile.canWrite();
        }

        @Override
        public boolean delete() {
            RawDocumentFile rawDocumentFile = this;
            RawDocumentFile.deleteContents(rawDocumentFile.mFile);
            return rawDocumentFile.mFile.delete();
        }

        @Override
        public boolean exists() {
            return this.mFile.exists();
        }
    }

    static class SingleDocumentFile
    extends DocumentFile {
        private Context mContext;
        private Uri mUri;

        /*
         * WARNING - void declaration
         */
        SingleDocumentFile(DocumentFile parent, Context context, Uri uri) {
            super((DocumentFile)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.mContext = var2_2;
            this.mUri = var3_3;
        }

        @Override
        public Uri getUri() {
            return this.mUri;
        }

        @Override
        public String getName() {
            return DocumentsContractApi19.getName(this.mContext, this.mUri);
        }

        @Override
        public String getType() {
            return DocumentsContractApi19.getType(this.mContext, this.mUri);
        }

        @Override
        public boolean isDirectory() {
            return DocumentsContractApi19.isDirectory(this.mContext, this.mUri);
        }

        @Override
        public boolean isFile() {
            return DocumentsContractApi19.isFile(this.mContext, this.mUri);
        }

        @Override
        public boolean isVirtual() {
            return DocumentsContractApi19.isVirtual(this.mContext, this.mUri);
        }

        @Override
        public long lastModified() {
            return DocumentsContractApi19.lastModified(this.mContext, this.mUri);
        }

        @Override
        public long length() {
            return DocumentsContractApi19.length(this.mContext, this.mUri);
        }

        @Override
        public boolean canRead() {
            return DocumentsContractApi19.canRead(this.mContext, this.mUri);
        }

        @Override
        public boolean canWrite() {
            return DocumentsContractApi19.canWrite(this.mContext, this.mUri);
        }

        @Override
        public boolean delete() {
            try {
                return DocumentsContract.deleteDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri);
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public boolean exists() {
            return DocumentsContractApi19.exists(this.mContext, this.mUri);
        }
    }

    static class DocumentsContractApi19 {
        private static final String TAG = "DocumentFile";
        private static final int FLAG_VIRTUAL_DOCUMENT = 512;

        /*
         * WARNING - void declaration
         */
        public static boolean isVirtual(Context context, Uri self) {
            Context context2;
            void var1_1;
            if (!DocumentsContract.isDocumentUri((Context)context, (Uri)var1_1)) {
                return false;
            }
            return (DocumentsContractApi19.getFlags(context2, (Uri)var1_1) & 0x200L) != 0L;
        }

        /*
         * WARNING - void declaration
         */
        public static String getName(Context context, Uri self) {
            void var1_1;
            return DocumentsContractApi19.queryForString(context, (Uri)var1_1, "_display_name", null);
        }

        /*
         * WARNING - void declaration
         */
        private static String getRawType(Context context, Uri self) {
            void var1_1;
            return DocumentsContractApi19.queryForString(context, (Uri)var1_1, "mime_type", null);
        }

        /*
         * WARNING - void declaration
         */
        public static String getType(Context context, Uri self) {
            void var1_1;
            Object object = DocumentsContractApi19.getRawType(context, (Uri)var1_1);
            if ("vnd.android.document/directory".equals(object)) {
                return null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public static long getFlags(Context context, Uri self) {
            void var1_1;
            return DocumentsContractApi19.queryForLong(context, (Uri)var1_1, "flags", 0L);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean isDirectory(Context context, Uri self) {
            void var1_1;
            return "vnd.android.document/directory".equals(DocumentsContractApi19.getRawType(context, (Uri)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public static boolean isFile(Context context, Uri self) {
            void var1_1;
            Object object = DocumentsContractApi19.getRawType(context, (Uri)var1_1);
            return !"vnd.android.document/directory".equals(object) && !TextUtils.isEmpty((CharSequence)object);
            {
            }
        }

        /*
         * WARNING - void declaration
         */
        public static long lastModified(Context context, Uri self) {
            void var1_1;
            return DocumentsContractApi19.queryForLong(context, (Uri)var1_1, "last_modified", 0L);
        }

        /*
         * WARNING - void declaration
         */
        public static long length(Context context, Uri self) {
            void var1_1;
            return DocumentsContractApi19.queryForLong(context, (Uri)var1_1, "_size", 0L);
        }

        /*
         * WARNING - void declaration
         */
        public static boolean canRead(Context context, Uri self) {
            Context context2;
            void var1_1;
            if (context.checkCallingOrSelfUriPermission((Uri)var1_1, 1) != 0) {
                return false;
            }
            return !TextUtils.isEmpty((CharSequence)DocumentsContractApi19.getRawType(context2, (Uri)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public static boolean canWrite(Context context, Uri self) {
            Object object;
            void var1_1;
            if (context.checkCallingOrSelfUriPermission((Uri)var1_1, 2) != 0) {
                return false;
            }
            Context context2 = object;
            object = DocumentsContractApi19.getRawType(object, (Uri)var1_1);
            int n = DocumentsContractApi19.queryForInt(context2, (Uri)var1_1, "flags", 0);
            if (TextUtils.isEmpty((CharSequence)object)) {
                return false;
            }
            if ((n & 4) != 0) {
                return true;
            }
            if ("vnd.android.document/directory".equals(object) && (n & 8) != 0) {
                return true;
            }
            return !TextUtils.isEmpty((CharSequence)object) && (n & 2) != 0;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static boolean exists(Context context, Uri self) {
            Throwable throwable2222222;
            Context context2;
            block6: {
                boolean bl;
                String[] stringArray;
                void v0 = stringArray;
                context2 = null;
                String[] stringArray2 = new String[1];
                {
                    Context context3;
                    catch (Throwable throwable2222222) {
                        break block6;
                    }
                    catch (Exception exception) {}
                    {
                        context3 = context2;
                        Log.w((String)"DocumentFile", (String)("Failed query: " + exception));
                    }
                    DocumentsContractApi19.closeQuietly((AutoCloseable)context3);
                    return false;
                }
                stringArray = stringArray2;
                {
                    stringArray2[0] = "document_id";
                    context2 = context.getContentResolver().query((Uri)v0, stringArray, null, null, null);
                }
                {
                    bl = context2.getCount() > 0;
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
                return bl;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
            throw throwable2222222;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String queryForString(Context context, Uri self, String column, String defaultValue) {
            Throwable throwable2;
            Context context2;
            block7: {
                Context context3;
                void v3;
                void var3_5;
                Exception exception2;
                block6: {
                    String string;
                    void var2_4;
                    String[] stringArray;
                    void v0 = stringArray;
                    context2 = null;
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = var2_4;
                    context2 = context.getContentResolver().query((Uri)v0, stringArray, null, null, null);
                    try {
                        if (!context2.moveToFirst() || context2.isNull(0)) break block6;
                        string = context2.getString(0);
                    }
                    catch (Throwable throwable2) {
                        break block7;
                    }
                    catch (Exception exception2) {}
                    DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
                    return string;
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
                return var3_5;
                {
                    v3 = var3_5;
                    context3 = context2;
                    Log.w((String)"DocumentFile", (String)("Failed query: " + exception2));
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)context3);
                return v3;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
            throw throwable2;
        }

        /*
         * WARNING - void declaration
         */
        private static int queryForInt(Context context, Uri self, String column, int defaultValue) {
            void var2_3;
            void var1_2;
            void var3_4;
            long l = (long)var3_4;
            return (int)DocumentsContractApi19.queryForLong(context, (Uri)var1_2, (String)var2_3, l);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static long queryForLong(Context context, Uri self, String column, long defaultValue) {
            Throwable throwable2;
            Context context2;
            block7: {
                Context context3;
                void v3;
                void var3_5;
                Exception exception2;
                block6: {
                    long l;
                    void var2_4;
                    String[] stringArray;
                    void v0 = stringArray;
                    context2 = null;
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = var2_4;
                    context2 = context.getContentResolver().query((Uri)v0, stringArray, null, null, null);
                    try {
                        if (!context2.moveToFirst() || context2.isNull(0)) break block6;
                        l = context2.getLong(0);
                    }
                    catch (Throwable throwable2) {
                        break block7;
                    }
                    catch (Exception exception2) {}
                    DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
                    return l;
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
                return (long)var3_5;
                {
                    v3 = var3_5;
                    context3 = context2;
                    Log.w((String)"DocumentFile", (String)("Failed query: " + exception2));
                }
                DocumentsContractApi19.closeQuietly((AutoCloseable)context3);
                return (long)v3;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)context2);
            throw throwable2;
        }

        private static void closeQuietly(AutoCloseable closeable) {
            if (closeable != null) {
                try {
                    AutoCloseable autoCloseable;
                    autoCloseable.close();
                }
                catch (Exception exception) {
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
            }
        }

        private DocumentsContractApi19() {
        }
    }
}

