/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter.message;

import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.EMAMessageReaction;
import com.hyphenate.chat.adapter.EMAThreadInfo;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class EMAMessage extends EMABase {

	public enum EMAChatType {
		SINGLE,
		GROUP,
		CHATROOM,
	}
	
	public enum EMAMessageStatus {
		NEW,
		DELIVERING,
		SUCCESS,
		FAIL,
	}
	
	public enum EMADirection {
	    SEND, RECEIVE
	}
	
	public final static int EMAChatType_SINGLE = 0;
	public final static int EMAChatType_GROUP = 1;
	public final static int EMAChatType_CHATROOM = 2;
	
	public final static int EMAMessageStatus_NEW = 0;
	public final static int EMAMessageStatus_DELIVERING = 1;
	public final static int EMAMessageStatus_SUCCESS = 2;
	public final static int EMAMessageStatus_FAIL = 3;
	
	public EMAMessage(EMAMessage message) {
		nativeInit(message);
	}
	
	public EMAMessageStatus _status() {
		int status = nativeStatus();
		switch (status) {
		case EMAMessageStatus_NEW:
			return EMAMessageStatus.NEW;
		case EMAMessageStatus_DELIVERING:
			return EMAMessageStatus.DELIVERING;
		case EMAMessageStatus_SUCCESS:
			return EMAMessageStatus.SUCCESS;
		case EMAMessageStatus_FAIL:
			return EMAMessageStatus.FAIL;
		default:
			break;
		}
		return EMAMessageStatus.FAIL;
	}
	
	public String msgId() {
		return nativeMsgId();
	}
	
	public String from() {
		return nativeFrom();
	}

	public String getRecaller(){
		return nativeGetRecaller();
	}

	public String to() {
		return nativeTo();
	}
	
	public String conversationId() {
		return nativeConversationId();
	}

	public void setMsgId(String msgId) {
		nativeSetMsgId(msgId);
	}
	public void setFrom(String from) {
		nativeSetFrom(from);
	}
	public void setTo(String to) {
		nativeSetTo(to);
	}
	public void setConversationId(String conversationId) {
		nativeSetConversationId(conversationId);
	}
	public void setStatus(int status) {
		nativeSetStatus(status);
	}
	
	
	public boolean isRead() {
		return nativeIsRead();
	}
	public boolean isAcked() {
		return nativeIsAcked();
	}
	public boolean isDeliverAcked() {
		return nativeIsDeliverAcked();
	}
	public long timeStamp() {
		return nativeTimeStamp();
	}
	
	public void setIsRead(boolean isRead) {
		nativeSetIsRead(isRead);
	}
	
	public void setIsAcked(boolean isAcked) {
		nativeSetIsAcked(isAcked);
	}
	
	public boolean isListened() {
	    return nativeIsListened();
	}
	native boolean nativeIsListened();
	
	public void setListened(boolean listened) {
	    nativeSetListened(listened);
	}
	native void nativeSetListened(boolean listened);

	public void setIsDeliverAcked(boolean isDeliverAcked) {
		nativeSetIsDeliverAcked(isDeliverAcked);
	}
	
	public static  EMAMessage createReceiveMessage(String from, String to, EMAMessageBody body, int chatType) {
		return nativeCreateReceiveMessage(from, to, body, chatType);
	}
	
	public static  EMAMessage createSendMessage(String from, String to, EMAMessageBody body, int chatType) {
		return nativeCreateSendMessage(from, to, body, chatType);
	}
	
	public void setAttribute(String attr, int val) {
		nativeSetAttribute(attr, val);
	}
	
	public void setAttribute(String attr, long val) {
        nativeSetAttribute(attr, val);
    }
	public void setAttribute(String attr, float val) {
		nativeSetAttribute(attr, val);
	}
	public void setAttribute(String attr, double val) {
		nativeSetAttribute(attr, val);
	}
	
	public void setAttribute(String attr, String val) {
		nativeSetAttribute(attr, val);
	}
	
	public void setAttribute(String attr, boolean val) {
		nativeSetAttribute(attr, val);
	}
	
	public void setJsonAttribute(String attr, String val) {
	    nativeSetJsonAttribute(attr, val);
	}
	
	public boolean getJsonAttribute(String attr, String defaultValue, StringBuilder val) {
	    return nativeGetJsonAttribute(attr, defaultValue, val);
	}
	
	public boolean getIntAttribute(String attr, int defaultValue, AtomicInteger val) {
		return nativeGetIntAttribute(attr, defaultValue, val);
	}

	public boolean getLongAttribute(String attr, long defaultValue, AtomicLong val) {
        return nativeGetLongAttribute(attr, defaultValue, val);
    }

	public boolean getFloatAttribute(String attr, float defaultValue, AtomicReference val) {
        return nativeGetFloatAttribute(attr, defaultValue, val);
    }
	public boolean getDoubleAttribute(String attr, double defaultValue, AtomicReference val) {
        return nativeGetDoubleAttribute(attr, defaultValue, val);
    }

	public boolean getStringAttribute(String attr, String defaultValue, StringBuilder val) {
		return nativeGetStringAttribute(attr, defaultValue, val);
	}
	
	public boolean getBooleanAttribute(String attr, boolean defaultValue, AtomicBoolean val) {
		return nativeGetBooleanAttribute(attr, defaultValue, val);
	}
	
	public List<EMAMessageBody> bodies() {
		return nativeBodies();
	}

	public void addBody(EMAMessageBody body) {
		nativeAddBody(body);
	}
	
	public void clearBodies() {
		nativeClearBodies();
	}
	
	public EMAChatType chatType() {
		int t = nativeChatType();
		EMAChatType type = EMAChatType.SINGLE;
		if (t == EMAChatType.SINGLE.ordinal()) {
			type = EMAChatType.SINGLE;
		} else if (t == EMAChatType.GROUP.ordinal()) {
			type = EMAChatType.GROUP;
		} else {
			type = EMAChatType.CHATROOM;
		}
		return type;
	}
	
	public void setChatType(EMAChatType type) {
		nativeSetChatType(type.ordinal());
	}
	
	public void setTimeStamp(long time) {
		nativeSetTimeStamp(time);
	}
	
	public int progress() {
		return nativeProgress();
	}
	
	public void setProgress(int progress) {
		nativeSetProgress(progress);
	}
	
	public void setCallback(EMACallback callback) {
	    nativeSetCallback(callback);
	}
	
	public EMADirection direction() {
	    int dir = nativeDirection();
	    if (dir == EMADirection.SEND.ordinal()) {
	        return EMADirection.SEND;
	    } else {
	        return EMADirection.RECEIVE;
	    }
	}
	
	public void setDirection(int dir) {
	    nativeSetDirection(dir);
	}
	
	public long getLocalTime() {
	    return nativeGetLocalTime();
	}

	public void setLocalTime(long time) {
	    nativeSetLocalTime(time);
	}

	// return JSONObject type
	public Map ext() { return nativeExt(); }


	public boolean isNeedGroupAck() { return nativeIsNeedGroupAck(); }
	public void setIsNeedGroupAck(boolean need) {nativeSetIsNeedGroupAck(need); }

	public int groupAckCount() { return nativeGroupAckCount(); }
	public void setGroupAckCount(int count) { nativeSetGroupAckCount(count); }

	public List<EMAMessageReaction> reactionList() {
		return nativeReactionList();
	}

	public void setIsChatThreadMessage(boolean isThread) {
		nativeSetIsThread(isThread);
	}

	public boolean isChatThreadMessage() {
		return nativeIsThread();
	}

	public EMAThreadInfo getChatThread() {
		return nativeGetChatThread();
	}

	public boolean isOnlineState() {
		return nativeIsOnlineState();
	}

	public void setPriority(EMMessage.EMChatRoomMessagePriority priority){
		nativeSetPriority(priority.ordinal());
	}

	public Map<String, Object> getAttributes() {
		return nativeGetAttributes();
	}

	public boolean isContentReplaced() {
		return nativeIsContentReplaced();
	}

	// -------------------- native part --------------------
	
	public native String nativeMsgId();
	public native String nativeFrom(); 
	public native String nativeGetRecaller();
	public native String nativeTo();
	public native String nativeConversationId();
	public native int nativeStatus();

	public native void nativeSetMsgId(String msgId);
	public native void nativeSetFrom(String from); 
	public native void nativeSetTo(String to);
	public native void nativeSetConversationId(String conversationId);
	public native void nativeSetStatus(int status);
	
	public native boolean nativeIsRead();
	public native boolean nativeIsAcked();
	public native boolean nativeIsDeliverAcked();

	public native long nativeTimeStamp();
	
	public native void nativeSetIsRead(boolean isRead);
	public native void nativeSetIsAcked(boolean isAcked);
	public native void nativeSetIsDeliverAcked(boolean isDeliverAcked);
	
	public native static EMAMessage nativeCreateReceiveMessage(String from, String to, EMAMessageBody body, int chatType);
	public native static EMAMessage nativeCreateSendMessage(String from, String to, EMAMessageBody body, int chatType);
	
	public native void nativeSetAttribute(String attr, int val);
	public native void nativeSetAttribute(String attr, String val);
	public native void nativeSetAttribute(String attr, boolean val);
    public native void nativeSetAttribute(String attr, long val);
    public native void nativeSetAttribute(String attr, float val);
    public native void nativeSetAttribute(String attr, double val);
	native void nativeSetJsonAttribute(String attr, String val);
	
	public native boolean nativeGetIntAttribute(String attr, int defaultValue, AtomicInteger val);
    public native boolean nativeGetLongAttribute(String attr, long defaultValue, AtomicLong val);
    public native boolean nativeGetFloatAttribute(String attr, float defaultValue, AtomicReference val);
    public native boolean nativeGetDoubleAttribute(String attr, double defaultValue, AtomicReference val);
	public native boolean nativeGetStringAttribute(String attr, String defaultValue, StringBuilder val);
	public native boolean nativeGetBooleanAttribute(String attr, boolean defaultValue, AtomicBoolean val);
	native boolean nativeGetJsonAttribute(String attr, String defaultValue, StringBuilder val);

	public native List<EMAMessageBody> nativeBodies();
	public native void nativeAddBody(EMAMessageBody body);
	public native void nativeClearBodies();
	
	native int nativeDirection(); 
	native void nativeSetDirection(int dir);
	
	native int nativeChatType();
	native void nativeSetChatType(int chatType);
	native void nativeSetTimeStamp(long time);
	native int nativeProgress();
	native void nativeSetProgress(int progress);
	native void nativeSetCallback(EMACallback callback);
	
	native long nativeGetLocalTime();
	native void nativeSetLocalTime(long time);
	native Map<String, Object> nativeExt();

	public native boolean nativeIsNeedGroupAck();
	public native void nativeSetIsNeedGroupAck(boolean need);
	public native int nativeGroupAckCount();
	public native void nativeSetGroupAckCount(int count);

	native void nativeSetIsThread(boolean isThread);
	native boolean nativeIsThread();
	native EMAThreadInfo nativeGetChatThread();

	public boolean isDeliverOnlineOnly() {
		return nativeIsDeliverOnlineOnly();
	}
	public void deliverOnlineOnly(boolean onlineOnly) {
		nativeDeliverOnlineOnly(onlineOnly);
	}

	public EMAMessage() {
		nativeInit();
	}

	public void setReceiverList(List<String> receiverList) {
		nativeSetReceiverList(receiverList);
	}

	public List<String> receiverList() {
		return nativeReceiverList();
	}

	public boolean isBroadcast() {
		return nativeIsBroadcast();
	}

	public EMAMessagePinInfo pinedInfo() {
		return nativePinedInfo();
	}

	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();	
	native void nativeInit(EMAMessage message);	
	native void nativeFinalize();

	native List<EMAMessageReaction> nativeReactionList();

	native boolean nativeIsOnlineState();

	native void nativeSetPriority(int priority);
	native boolean nativeIsDeliverOnlineOnly();
	native void nativeDeliverOnlineOnly(boolean onlineOnly);

	native void nativeSetReceiverList(List<String> receiverList);
	native List<String> nativeReceiverList();
  
	native Map<String, Object> nativeGetAttributes();
	native boolean nativeIsBroadcast();
	native boolean nativeIsContentReplaced() ;
	native EMAMessagePinInfo nativePinedInfo() ;

}
