/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

/**
 * Error code should be same with native EMError's error code.
 * @author linan
 *
 */
public class EMAError extends EMABase {

	public final static int EM_NO_ERROR = 0;

	public final static int GENERAL_ERROR = 1;
	public final static int NETWORK_ERROR = 2;
	public final static int DATABASE_ERROR = 3;
	public final static int EXCEED_SERVICE_LIMIT = 4;
	public final static int SERVICE_ARREARAGES = 5;
	public final static int PUSH_REPORT_ACTION_FAILED = 6;
	public final static int PARTIAL_SUCCESS = 7;
	public final static int APP_ACTIVE_NUMBER_REACH_LIMITATION = 8;
	public final static int INVALID_APP_KEY = 100;
	public final static int INVALID_USER_NAME = 101;
	public final static int INVALID_PASSWORD = 102;
	public final static int INVALID_URL = 103;
	public final static int INVALID_TOKEN = 104;
	public final static int USER_NAME_TOO_LONG = 105;
	public final static int CHANNEL_SYNC_NOT_OPEN = 106;
	public final static int INVALID_CONVERSATION = 107;
	public final static int TOKEN_EXPIRED = 108;
	public final static int TOKEN_WILL_EXPIRE = 109;
	public final static int INVALID_PARAM = 110;
	public final static int OPERATION_UNSUPPORTED = 111;
	public final static int QUERY_PARAM_REACHES_LIMIT = 112;

	public final static int USER_ALREADY_LOGIN = 200;
	public final static int USER_NOT_LOGIN = 201;
	public final static int USER_AUTHENTICATION_FAILED = 202;
	public final static int USER_ALREADY_EXIST = 203;
	public final static int USER_NOT_FOUND = 204;
	public final static int USER_ILLEGAL_ARGUMENT = 205;
	public final static int USER_LOGIN_ANOTHER_DEVICE = 206;
	public final static int USER_REMOVED = 207;
	public final static int USER_REG_FAILED = 208;
	public final static int USER_UPDATEINFO_FAILED = 209;
	public final static int USER_PERMISSION_DENIED = 210;
	public final static int USER_BINDDEVICETOKEN_FAILED = 211;
	public final static int USER_UNBIND_DEVICETOKEN_FAILED = 212;
	public final static int USER_BIND_ANOTHER_DEVICE = 213;
	public final static int USER_LOGIN_TOO_MANY_DEVICES = 214;
	public final static int USER_MUTED = 215;
	public final static int USER_KICKED_BY_CHANGE_PASSWORD = 216;
	public final static int USER_KICKED_BY_OTHER_DEVICE = 217;
	public final static int USER_ALREADY_LOGIN_ANOTHER = 218;
	public final static int USER_MUTED_BY_ADMIN = 219;
	public final static int USER_DEVICE_CHANGED = 220;
	public final static int USER_NOT_ON_ROSTER = 221;

	public final static int SERVER_NOT_REACHABLE = 300;
	public final static int SERVER_TIMEOUT = 301;
	public final static int SERVER_BUSY = 302;
	public final static int SERVER_UNKNOWN_ERROR = 303;
	public final static int SERVER_GET_DNSLIST_FAILED = 304;
	public final static int SERVER_SERVICE_RESTRICTED = 305;
	public final static int SERVER_DECRYPTION_FAILED   = 306;
	public final static int SERVER_RESPONSE_ILLEGAL   = 309;

	public final static int FILE_NOT_FOUND = 400;
	public final static int FILE_INVALID = 401;
	public final static int FILE_UPLOAD_FAILED = 402;
	public final static int FILE_DOWNLOAD_FAILED = 403;
	public final static int FILE_DELETE_FAILED = 404;
	public final static int FILE_TOO_LARGE = 405;
	public final static int FILE_CONTENT_IMPROPER = 406;
	public final static int FILE_IS_EXPIRED = 407;

	public final static int MESSAGE_INVALID = 500;
	public final static int MESSAGE_INCLUDE_ILLEGAL_CONTENT = 501;
	public final static int MESSAGE_SEND_TRAFFIC_LIMIT = 502;
	public final static int MESSAGE_ENCRYPTION_ERROR = 503;
	public final static int MESSAGE_RECALL_TIME_LIMIT = 504;
	public final static int SERVICE_NOT_ENABLED = 505;
	public final static int MESSAGE_EXPIRED = 506;
	public final static int MESSAGE_ILLEGAL_WHITELIST = 507;
	public final static int MESSAGE_EXTERNAL_LOGIC_BLOCKED = 508;
	public final static int MESSAGE_CURRENT_LIMITING = 509;
	public final static int MESSAGE_SIZE_LIMIT = 510;
	public final static int MESSAGE_EDIT_FAILED = 511;

	public final static int GROUP_INVALID_ID = 600;
	public final static int GROUP_ALREADY_JOINED = 601;
	public final static int GROUP_NOT_JOINED = 602;
	public final static int GROUP_PERMISSION_DENIED = 603;
	public final static int GROUP_MEMBERS_FULL = 604;
	public final static int GROUP_SHARED_FILE_INVALIDID = 605;
	public final static int GROUP_NOT_EXIST = 606;
	public final static int GROUP_DISABLED = 607;
	public final static int GROUP_NAME_VIOLATION = 608;
	public final static int GROUP_MEMBER_ATTRIBUTES_REACH_LIMIT = 609;
	public final static int GROUP_MEMBER_ATTRIBUTES_UPDATE_FAILED = 610;
	public final static int GROUP_MEMBER_ATTRIBUTES_KEY_REACH_LIMIT = 611;
	public final static int GROUP_MEMBER_ATTRIBUTES_VALUE_REACH_LIMIT = 612;
	public final static int GROUP_USER_IN_BLOCKLIST = 613;

	public final static int CHATROOM_INVALID_ID = 700;
	public final static int CHATROOM_ALREADY_JOINED = 701;
	public final static int CHATROOM_NOT_JOINED = 702;
	public final static int CHATROOM_PERMISSION_DENIED = 703;
	public final static int CHATROOM_MEMBERS_FULL = 704;
	public final static int CHATROOM_NOT_EXIST = 705;
	public final static int CHATROOM_OWNER_NOT_ALLOW_LEAVE = 706;
	public final static int CHATROOM_USER_IN_BLOCKLIST = 707;

	public final static int USERINFO_USERCOUNT_EXCEED  = 900;
	public final static int USERINFO_DATALENGTH_EXCEED = 901;
	@Deprecated
	public final static int TRANSLATE_INVALID_PARAMS = 903;
	@Deprecated
	public final static int TRANSLATE_FAIL = 904;
	@Deprecated
	public final static int TRANSLATE_NOT_INIT = 905;

	public final static int CONTACT_ADD_FAILED = 1000;
	public final static int CONTACT_REACH_LIMIT = 1001;
	public final static int CONTACT_REACH_LIMIT_PEER = 1002;

	public final static int PRESENCE_PARAM_LENGTH_EXCEED = 1100;
	public final static int PRESENCE_CANNOT_SUBSCRIBE_YOURSELF = 1101;
	public final static int TRANSLATE_PARAM_INVALID = 1110;
	public final static int TRANSLATE_SERVICE_NOT_ENABLE = 1111;
	public final static int TRANSLATE_USAGE_LIMIT = 1112;
	public final static int TRANSLATE_MESSAGE_FAIL = 1113;

	public final static int MODERATION_FAILED = 1200;
	public final static int THIRD_SERVER_FAILED = 1299;

	public final static int REACTION_REACH_LIMIT = 1300;
	public final static int REACTION_HAS_BEEN_OPERATED = 1301;
	public final static int REACTION_OPERATION_IS_ILLEGAL = 1302;

	public final static int THREAD_NOT_EXIST = 1400;
	public final static int THREAD_ALREADY_EXIST = 1401;
	public final static int THREAD_CREATE_MESSAGE_ILLEGAL = 1402;

	public final static int PUSH_NOT_SUPPORT = 1500;
	public final static int PUSH_BIND_FAILED = 1501;
	public final static int PUSH_UNBIND_FAILED = 1502;

    public int errCode() {
    	return nativeErrCode();
    }
    
    public String errMsg() {
    	return nativeErrMsg();
    }
    
	public EMAError() {
		nativeInit();
	}
	
	native int nativeErrCode();
	
	native String nativeErrMsg();
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeFinalize();
}
