/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

public interface EMAChatRoomManagerListenerInterface {
  /**
    * \brief Callback user when user is kicked out from a chatroom or the chatroom is destroyed.
    *
    * @param chatroom The chatroom that user left.
    * @param leaveReason The leave reason.
    * @return NA
    */
  void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason);
  
  /**
    * \brief Callback user when a user join the chatroom.
    *
    * @param chatroom The chatroom that user joined.
    * @param member The member.
    * @return NA
    */
  void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member,String ext);
  
  /**
    * \brief Callback user when a user leave the chatroom.
    *
    * @param chatroom The chatroom that user left.
    * @param member The member.
    * @return NA
    */
  void onMemberLeftChatRoom(EMAChatRoom chatroom, String member);


  // ============================= group_reform new add api begin
  /**
   * \brief Callback user when user add to chat room mute list.
   *
   * @param  chatRoom The chat room that take action
   * @param mutes entry key is user who was added into chat room mute list,
   *              entry value is mute time
   * @return NA
   */
  void onAddMuteList(EMAChatRoom chatRoom, List<String> mutes, long duration);

  /**
   * \brief Callback user when user remove from chat room mute list.
   *
   * @param  chatRoom The chat room that take action
   * @param mutes  users who was removed from chat room mute list
   * @return NA
   */
  void onRemoveMutes(EMAChatRoom chatRoom, List<String> mutes);

  /**
   * \~chinese
   * 白名单成员增加
   *
   * @param chatroom    聊天室id
   * @param whitelist     白名单中增加的成员名单
   *
   * \~english
   * Callback when chat room member(s) is added to whitelist
   *
   * @param chatroom    chatroom id
   * @param whitelist     member(s) was added to whitelist
   */
  void onWhiteListAdded(EMAChatRoom chatroom, List<String> whitelist);

  /**
   * \~chinese
   * 白名单成员减少
   *
   * @param chatroom    聊天室id
   * @param whitelist     白名单中移除的成员名单
   *
   * \~english
   * Callback when chat room member(s) is removed from whitelist
   *
   * @param chatroom    chatroom id
   * @param whitelist     member(s) was removed from whitelist
   */
  void onWhiteListRemoved(EMAChatRoom chatroom, List<String> whitelist);

  /**
   * \~chinese
   * 全员禁言状态的改变
   *
   * @param chatroom    聊天室id
   * @param isMuted       是否开启了全员禁言
   *
   * \~english
   * Callback when chat room all memeber muted or not
   *
   * @param chatroom    chatroom id
   * @param isMuted       if the all room memmber is muted or not
   */
  void onAllMemberMuteStateChanged(EMAChatRoom chatroom, boolean isMuted);

  /**
   * \brief Callback user when user promote to admin.
   *
   * @param  chatRoom The chat room that take action
   * @param  admin member whom got administrator privilege.
   * @return NA
   */
  void onAddAdmin(EMAChatRoom chatRoom, String admin);

  /**
   * \brief Callback user when user cancel admin.
   *
   * @param  chatRoom The chat room that take action
   * @param  admin member who was deprived administrator privilege.
   * @return NA
   */
  void onRemoveAdmin(EMAChatRoom chatRoom, String admin);

  /**
   * \brief Callback user when promote to chat room owner.
   *
   * @param chatRoom The chat room that take action
   * @param newOwner transfer ownership to
   * @return NA
   */
  void onOwnerChanged(EMAChatRoom chatRoom, String newOwner, String oldOwner);

  // ============================= group_reform new add api end

  void onAnnouncementChanged(EMAChatRoom chatRoom, String announcement);

  /**
   * \brief Callback user when chatroom specification updated.
   *
   * @param  chatroom The chatroom that updated.
   * @result NA
   */
  void onUpdateSpecificationFromChatroom(EMAChatRoom chatroom);

  /**
   * \brief Callback user when chatroom's Attributes update.
   *
   *  @param chatRoomId    The Chatroom's id
   *  @param attributeMap  The attributeMap of chatroom
   *  @param fromId        operator's id
   */
  void onAttributesUpdate(String chatRoomId, String attributeMap , String fromId);

  /**
   * \brief Callback user when chatroom's Attributes removed.
   *
   *  @param chatRoomId    The Chatroom's id
   *  @param attributeMap  The attributeMap of chatroom
   *  @param fromId        operator's id
   */
  void onAttributesRemoved(String chatRoomId, String attributeMap , String fromId);

}
