/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

public abstract class EMAChatRoomManagerListener extends EMABase implements EMAChatRoomManagerListenerInterface {

	/**
	 * User is kicked out by chat room owner.
	 */
	public final static int BE_KICKED = 0;
	public final static int DESTROYED = 1;
	/**
	 * User is kicked out by server for user offline.
 	 */
	public final static int BE_KICKED_FOR_OFFLINE = 2;
	
	public EMAChatRoomManagerListener() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	/**
	 * create native listener class which implements EMContactListener interface.
	 */
	native void nativeInit();
	native void nativeFinalize();

	@Override
	public void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason) {
	}

	@Override
	public void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member,String ext) {
	}

	@Override
	public void onMemberLeftChatRoom(EMAChatRoom chatroom, String member) {
	}

	// ============================= group_reform new add api begin
	/**
	 * \brief Callback user when user add to chat room mute list.
	 *
	 * @param chatRoom The chat room that take action
	 * @param mutes entry key is user who was added into chat room mute list,
	 *              entry value is mute time
	 * @return NA
	 */
	@Override
	public void onAddMuteList(EMAChatRoom chatRoom, List<String> mutes, long expireTime) {}

	/**
	 * \brief Callback user when user remove from chat room mute list.
	 *
	 * @param  chatRoom The chat room that take action
	 * @param mutes  users who was removed from chat room mute list
	 * @return NA
	 */
	@Override
	public void onRemoveMutes(EMAChatRoom chatRoom, List<String> mutes) {}

	/**
	 * \~chinese
	 * 白名单成员增加
	 *
	 * @param chatRoom    聊天室id
	 * @param whitelist     白名单中增加的成员名单
	 *
	 * \~english
	 * Callback when chat room member(s) is added to whitelist
	 *
	 * @param chatRoom    chatroom id
	 * @param whitelist     member(s) was added to whitelist
	 */
	@Override
	public void onWhiteListAdded(EMAChatRoom chatRoom, List<String> whitelist) {}

	/**
	 * \~chinese
	 * 白名单成员减少
	 *
	 * @param chatRoom    聊天室id
	 * @param whitelist     白名单中移除的成员名单
	 *
	 * \~english
	 * Callback when chat room member(s) is removed from whitelist
	 *
	 * @param chatRoom    chatroom id
	 * @param whitelist     member(s) was removed from whitelist
	 */
	@Override
	public void onWhiteListRemoved(EMAChatRoom chatRoom, List<String> whitelist) {}

	/**
	 * \~chinese
	 * 全员禁言状态的改变
	 *
	 * @param chatRoom    聊天室id
	 * @param isMuted       是否开启了全员禁言
	 *
	 * \~english
	 * Callback when chat room all memeber muted or not
	 *
	 * @param chatRoom    chatroom id
	 * @param isMuted       if the all room memmber is muted or not
	 */
	@Override
	public void onAllMemberMuteStateChanged(EMAChatRoom chatRoom, boolean isMuted) {}
	/**
	 * \brief Callback user when user promote to admin.
	 *
	 * @param  chatRoom The chat room that take action
	 * @param  admin member whom got administrator privilege.
	 * @return NA
	 */
	@Override
	public void onAddAdmin(EMAChatRoom chatRoom, String admin) {}

	/**
	 * \brief Callback user when user cancel admin.
	 *
	 * @param  chatRoom The chat room that take action
	 * @param  admin member who was deprived administrator privilege.
	 * @return NA
	 */
	@Override
	public void onRemoveAdmin(EMAChatRoom chatRoom, String admin) {}

	/**
	 * \brief Callback user when promote to chat room owner.
	 *
	 * @param chatRoom The chat room that take action
	 * @param newOwner transfer ownership to
	 * @return NA
	 */
	@Override
	public void onOwnerChanged(EMAChatRoom chatRoom, String newOwner, String oldOwner) {}

	// ============================= group_reform new add api end

	@Override
	public void onAnnouncementChanged(EMAChatRoom chatRoom, String announcement) {
	}

	@Override
	public void onUpdateSpecificationFromChatroom(EMAChatRoom chatroom) {

	}

	/**
	 *
	 * \brief Callback user when chatroom's Attributes update.
	 *
	 * @param chatRoomId
	 * @param attributeMap
	 * @param from
	 */
	@Override
	public void onAttributesUpdate(String chatRoomId, String attributeMap, String from) {

	}

	/**
	 *
	 * \brief Callback user when chatroom's Attributes removed.
	 *
	 * @param chatRoomId
	 * @param attributeMap
	 * @param from
	 */
	@Override
	public void onAttributesRemoved(String chatRoomId, String attributeMap, String from) {

	}

}
