package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMATranslateResult;

/**
 * \~chinese
 * 翻译实体类，有如下属性：
 *
 *    msgId：消息 ID。
 *    conversationId：会话 ID。
 *    showTranslation：是否显示译文。
 *    translateTime：翻译次数。
 *    translations：译文。
 * @deprecated 使用 {@link com.hyphenate.chat.EMTextMessageBody.EMTranslationInfo} 替代。
 * 
 *
 * \~english
 * The translation entity class, which has the following attributes:
 * 
 *     msgId: The message ID.
 *     conversationId: The conversation ID.
 *     showTranslation: Whether the translation is displayed. 
 *     translateTime: The number of times the message is translated. 
 *     translations: The translation content.
 * @deprecated use {@link com.hyphenate.chat.EMTextMessageBody.EMTranslationInfo} instead.
 */
@Deprecated
public class EMTranslationResult extends EMBase<EMATranslateResult>{

    public EMTranslationResult(String msgId) {
        emaObject = new EMATranslateResult(msgId);
    }

    public EMTranslationResult(EMATranslateResult result){
        emaObject = result;
    }

    /**
     * \~chinese
     * 获取消息 ID。
     * @return 消息 ID。
     *
     * \~english
     * Gets the message ID.
     * @return  The message ID.
     */
    public String msgId() {
        return emaObject.msgId();
    }

    /**
     * \~chinese
     * 获取会话 ID。
     * @return 会话 ID。
     *
     * \~english
     * Gets the conversation ID.
     * @return The conversation ID.
     */
    public String conversationId() {
        return emaObject.conversationId();
    }

    /**
     * \~chinese
     * 设置会话 ID。
     * @param  conversationId 会话 ID。
     *
     * \~english
     * Sets the conversation ID.
     * @param conversationId The conversation ID.
     */
    public void setConversationId(String conversationId) {
        emaObject.setConversationId(conversationId);
    }

    /**
     * \~chinese
     * 检查是否显示译文。
     * @return  boolean 是否显示译文。
     *    - `true`：显示译文；
     *    - `false`：不显示译文。
     *
     * \~english
     * Checks whether to display the translation.
     * @return  boolean Whether to display the translation.
     *    - `true`: Yes. 
     *    - `false`: No.
     */
    public boolean showTranslation() {
        return emaObject.showTranslation();
    }

    /**
     * \~chinese
     * 设置是否显示译文。
     * @param showTranslation 是否显示译文。
     *    - `true`：是；
     *    - `false`：否。
     *
     * \~english
     * Sets whether to display the translation.
     * @param showTranslation Whether to display the translation. 
     *    - `true`: Yes. 
     *    - `false`: No.
     */
    public void setShowTranslation(boolean showTranslation) {
        emaObject.setShowTranslation(showTranslation);
    }

    /**
     * \~chinese
     * 获取该消息被翻译的次数。
     * @return  消息被翻译的次数。
     *
     * \~english
     * Gets the number of times the message is translated.
     * @return  The number of times the message is translated.
     */
    public int translateCount() {
        return emaObject.translateTime();
    }

    /**
     * \~chinese
     * 设置消息翻译次数。
     * @param translateTime 翻译次数。
     *
     * \~english
     * Sets the number of times the message is translated.
     * @param translateTime The number of times the message is translated.
     */
    public void setTranslateCount(int translateTime) {
        emaObject.setTranslateTime(translateTime);
    }

    /**
     * \~chinese
     * 获取译文。
     * @return  译文。
     *
     * \~english
     * Gets the translation.
     * @return  The translation.
     */
    public String translatedText() {
        return emaObject.translations();
    }

    /**
     * \~chinese
     * 设置译文。
     * @param translations 译文。
     *
     * \~english
     * Sets the translation.
     * @param translations The translation.
     */
    public void setTranslatedText(String translations) {
        emaObject.setTranslations(translations);
    }
}
