package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAGroupReadAck;

/**
 * \~chinese
 * 群消息已读回执情况。
 * 通过 {@link EMChatManager#fetchGroupReadAcks(String, int, String)} 请求返回的结果，如下：
 * ```java
 *     EMCursorResult<EMGroupReadAck> result = EMClient.getInstance().chatManager().fetchGroupReadAcks(msgId, pageSize, startAckId);
 * ```
 *
 * \~english
 * Returns read recipients for group messages.
 * Calls {@link EMChatManager#fetchGroupReadAcks(String, int, String)} to return the requested result, for example: 
 * ```java
 *     EMCursorResult<EMGroupReadAck> result = EMClient.getInstance().chatManager().fetchGroupReadAcks(msgId, pageSize, startAckId);
 * ```
 */
public class EMGroupReadAck extends EMBase<EMAGroupReadAck> {

    EMAGroupReadAck emaObject;;

    public EMGroupReadAck(){
        this.emaObject = new EMAGroupReadAck();
    }

    public EMGroupReadAck(EMAGroupReadAck groupReadAck){
        this.emaObject = new EMAGroupReadAck(groupReadAck);
    }

    /**
     * \~chinese
     * 获取群组消息已读回执 ID。
     * @return  已读回执 ID。
     * \~english
     * Gets the read receipt ID of group messages.
     * @return  The read receipt ID.
     */
    public String getAckId() {
        return this.emaObject.getAckId();
    }

    /**
     * \~chinese
     * 返回群组消息 ID。
     * @return  群组消息 ID。
     *
     * \~english
     * Returns the group message ID.
     * @return  The group message ID.
     */
    public String getMsgId() {
        return this.emaObject.getMsgId();
    }

    /**
     * \~chinese
     * 获取发送已读回执的发送者 ID。
     * @return 发送者 ID。
     *
     * \~english
     * Gets the ID of user who sends the read receipt.
     * @return The sender ID.
     */
    public String getFrom() {
        return this.emaObject.getFrom();
    }

    /**
     * \~chinese
     * 获取已读回执扩展内容。
     * 发送已读回执 {@link EMChatManager#ackGroupMessageRead(String, String, String)}，第三个参数传入的内容
     * @return 已读回执扩展内容。
     *
     * \~english
     * Gets the read receipt extension.
     * Sends the read receipt passed as the third parameter in {@link EMChatManager#ackGroupMessageRead(String, String, String)}.
     *
     * @return The read receipt extension.
     */
    public String getContent() {
        return this.emaObject.getContent();
    }

    /**
     * \~chinese
     * 获取已读回执的发送顺序。
     * @return 返回已读回执的发送顺序。
     *
     * \~english
     * Gets the order in which read receipts of group messages are sent.
     * @return The order in which read receipts of group messages are sent.
     */
    public int getCount() {
        return this.emaObject.getCount();
    }

    /**
     * \~chinese
     * 获取发送已读回执的时间戳。
     * @return 发送已读回执的时间戳。
     *
     * \~english
     * Gets the timestamp of sending read receipts of group messages.
     * @return The timestamp of sending read receipts of group messages.
     */
    public long getTimestamp() {
        return this.emaObject.getTimestamp();
    }

}
