package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAThreadInfo;

public class EMChatThreadEvent extends EMBase<EMAThreadInfo>{
    private EMChatThread chatThread;

    public EMChatThreadEvent(EMAThreadInfo event) {
        emaObject = event;
        chatThread = new EMChatThread(event);
    }

    /**
     * \~chinese
     * 获取子区的事件类型。
     *
     * @return 子区的事件类型。详见 {@link TYPE}。
     *
     * \~english
     * Gets the message thread event type.
     *
     * @return The message thread event type. See {@link TYPE}.
     */
    public TYPE getType() {
        return emaObject.getType();
    }

    /**
     * \~chinese
     * 获取子区事件操作者的用户 ID。
     *
     * @return 操作者的用户 ID 。
     *
     * \~english
     * Gets the user ID of the operator of the message thread event.
     *
     * @return The user ID of the event operator.
     */
    public String getFrom() {
        return emaObject.getFrom();
    }

    /**
     * \~chinese
     * 获取子区对象。
     * 
     * @return 子区对象。
     *
     * \~english
     * Gets the message thread object.
     * 
     * @return The message thread object.
     */
    public EMChatThread getChatThread() {
        return chatThread;
    }

    public enum TYPE {
        /**
         * \~chinese
         * 未知的子区事件类型。
         *
         * \~english
         * The unknown type of message thread event.
         */
        UNKNOWN,
        /**
         * \~chinese
         * 子区创建。
         *
         * \~english
         * The message thread is created.
         */
        CREATE,
        /**
         * \~chinese
         * 子区更新。
         *
         * \~english
         * The message thread is updated.
         */
        UPDATE,
        /**
         * \~chinese
         * 子区解散。
         *
         * \~english
         * The message thread is destroyed.
         */
        DELETE,
        /**
         * \~chinese
         * 子区消息更新。
         *
         * \~english
         * One or more messages in the message thread are updated.
         */
        UPDATE_MSG
    }
}
