/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe;

import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.FailsafeExecutor;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.Policy;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Failsafe {
    @SafeVarargs
    public static <R, P extends Policy<R>> FailsafeExecutor<R> with(P outerPolicy, P ... policies) {
        Assert.notNull(outerPolicy, "outerPolicy");
        ArrayList policyList = new ArrayList(policies.length + 1);
        policyList.add(outerPolicy);
        Collections.addAll(policyList, policies);
        return new FailsafeExecutor(policyList);
    }

    @Deprecated
    public static <R, P extends Policy<R>> FailsafeExecutor<R> with(P[] policies) {
        Assert.notNull(policies, "policies");
        Assert.isTrue(policies.length > 0, "At least one policy must be supplied", new Object[0]);
        return new FailsafeExecutor(Arrays.asList(policies));
    }

    public static <R> FailsafeExecutor<R> with(List<? extends Policy<R>> policies) {
        Assert.notNull(policies, "policies");
        Assert.isTrue(!policies.isEmpty(), "At least one policy must be supplied", new Object[0]);
        return new FailsafeExecutor(policies);
    }

    public static <R> FailsafeExecutor<R> none() {
        return new FailsafeExecutor(Collections.emptyList());
    }
}

