/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.internal;

import io.github.gradlenexus.publishplugin.RepositoryTransitionException;
import io.github.gradlenexus.publishplugin.internal.ActionRetrier;
import io.github.gradlenexus.publishplugin.internal.NexusClient;
import io.github.gradlenexus.publishplugin.internal.StagingRepository;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J=\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryTransitioner;", "", "nexusClient", "Lio/github/gradlenexus/publishplugin/internal/NexusClient;", "retrier", "Lio/github/gradlenexus/publishplugin/internal/ActionRetrier;", "Lio/github/gradlenexus/publishplugin/internal/StagingRepository;", "(Lio/github/gradlenexus/publishplugin/internal/NexusClient;Lio/github/gradlenexus/publishplugin/internal/ActionRetrier;)V", "getNexusClient", "()Lio/github/gradlenexus/publishplugin/internal/NexusClient;", "getRetrier", "()Lio/github/gradlenexus/publishplugin/internal/ActionRetrier;", "assertRepositoryInDesiredState", "", "repository", "desiredStates", "", "Lio/github/gradlenexus/publishplugin/internal/StagingRepository$State;", "(Lio/github/gradlenexus/publishplugin/internal/StagingRepository;[Lio/github/gradlenexus/publishplugin/internal/StagingRepository$State;)V", "assertRepositoryNotTransitioning", "effectivelyChangeState", "repoId", "", "transitionClientRequest", "Lkotlin/Function1;", "(Ljava/lang/String;[Lio/github/gradlenexus/publishplugin/internal/StagingRepository$State;Lkotlin/jvm/functions/Function1;)V", "effectivelyClose", "description", "effectivelyRelease", "getStagingRepositoryStateById", "waitUntilTransitionIsDoneOrTimeoutAndReturnLastRepositoryState", "Companion", "publish-plugin"})
public final class StagingRepositoryTransitioner {
    @NotNull
    private final NexusClient nexusClient;
    @NotNull
    private final ActionRetrier<StagingRepository> retrier;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    public final void effectivelyClose(@NotNull String repoId, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)repoId, (String)"repoId");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.effectivelyChangeState(repoId, new StagingRepository.State[]{StagingRepository.State.CLOSED}, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, description){
            final /* synthetic */ StagingRepositoryTransitioner this$0;
            final /* synthetic */ String $description;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.getNexusClient().closeStagingRepository(it, this.$description);
            }
            {
                this.this$0 = stagingRepositoryTransitioner;
                this.$description = string;
                super(1);
            }
        }));
    }

    public final void effectivelyRelease(@NotNull String repoId, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)repoId, (String)"repoId");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.effectivelyChangeState(repoId, new StagingRepository.State[]{StagingRepository.State.RELEASED, StagingRepository.State.NOT_FOUND}, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, description){
            final /* synthetic */ StagingRepositoryTransitioner this$0;
            final /* synthetic */ String $description;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.getNexusClient().releaseStagingRepository(it, this.$description);
            }
            {
                this.this$0 = stagingRepositoryTransitioner;
                this.$description = string;
                super(1);
            }
        }));
    }

    private final void effectivelyChangeState(String repoId, StagingRepository.State[] desiredStates, Function1<? super String, Unit> transitionClientRequest) {
        transitionClientRequest.invoke((Object)repoId);
        StagingRepository readStagingRepository = this.waitUntilTransitionIsDoneOrTimeoutAndReturnLastRepositoryState(repoId);
        this.assertRepositoryNotTransitioning(readStagingRepository);
        this.assertRepositoryInDesiredState(readStagingRepository, Arrays.copyOf(desiredStates, desiredStates.length));
    }

    private final StagingRepository waitUntilTransitionIsDoneOrTimeoutAndReturnLastRepositoryState(String repoId) {
        return this.retrier.execute((Function0<StagingRepository>)((Function0)new Function0<StagingRepository>(this, repoId){
            final /* synthetic */ StagingRepositoryTransitioner this$0;
            final /* synthetic */ String $repoId;

            @NotNull
            public final StagingRepository invoke() {
                return StagingRepositoryTransitioner.access$getStagingRepositoryStateById(this.this$0, this.$repoId);
            }
            {
                this.this$0 = stagingRepositoryTransitioner;
                this.$repoId = string;
                super(0);
            }
        }));
    }

    private final StagingRepository getStagingRepositoryStateById(String repoId) {
        StagingRepository readStagingRepository = this.nexusClient.getStagingRepositoryStateById(repoId);
        log.info("Current staging repository status: state: " + (Object)((Object)readStagingRepository.getState()) + ", transitioning: " + readStagingRepository.getTransitioning());
        return readStagingRepository;
    }

    private final void assertRepositoryNotTransitioning(StagingRepository repository) {
        if (repository.getTransitioning()) {
            throw (Throwable)new RepositoryTransitionException("Staging repository is still transitioning after defined time. Consider its increment. " + repository);
        }
    }

    private final void assertRepositoryInDesiredState(StagingRepository repository, StagingRepository.State ... desiredStates) {
        if (!ArraysKt.contains((Object[])desiredStates, (Object)((Object)repository.getState()))) {
            StringBuilder stringBuilder = new StringBuilder().append("Staging repository is not in desired state ");
            StagingRepository.State[] stateArray = desiredStates;
            String string = Arrays.toString((Object[])stateArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            throw (Throwable)new RepositoryTransitionException(stringBuilder.append(string).append(": ").append(repository).append(". It is unexpected. Please check ").append("the Nexus logs using its web interface - it can be caused by validation rules violation (e.g. publishing artifacts with the ").append("same version again). If not, please report it to https://github.com/gradle-nexus/publish-plugin/issues/ with the '--info' logs.").toString());
        }
    }

    @NotNull
    public final NexusClient getNexusClient() {
        return this.nexusClient;
    }

    @NotNull
    public final ActionRetrier<StagingRepository> getRetrier() {
        return this.retrier;
    }

    public StagingRepositoryTransitioner(@NotNull NexusClient nexusClient, @NotNull ActionRetrier<StagingRepository> retrier2) {
        Intrinsics.checkParameterIsNotNull((Object)nexusClient, (String)"nexusClient");
        Intrinsics.checkParameterIsNotNull(retrier2, (String)"retrier");
        this.nexusClient = nexusClient;
        this.retrier = retrier2;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger((String)StagingRepositoryTransitioner.class.getSimpleName());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026r::class.java.simpleName)");
        log = logger;
    }

    public static final /* synthetic */ StagingRepository access$getStagingRepositoryStateById(StagingRepositoryTransitioner $this, String repoId) {
        return $this.getStagingRepositoryStateById(repoId);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryTransitioner$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "publish-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

