/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin;

import io.github.gradlenexus.publishplugin.AbstractNexusStagingRepositoryTask;
import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusRepository;
import io.github.gradlenexus.publishplugin.internal.NexusClient;
import java.net.URI;
import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Incubating
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lio/github/gradlenexus/publishplugin/RetrieveStagingProfile;", "Lio/github/gradlenexus/publishplugin/AbstractNexusStagingRepositoryTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "extension", "Lio/github/gradlenexus/publishplugin/NexusPublishExtension;", "repository", "Lio/github/gradlenexus/publishplugin/NexusRepository;", "(Lorg/gradle/api/model/ObjectFactory;Lio/github/gradlenexus/publishplugin/NexusPublishExtension;Lio/github/gradlenexus/publishplugin/NexusRepository;)V", "packageGroup", "Lorg/gradle/api/provider/Property;", "", "getPackageGroup", "()Lorg/gradle/api/provider/Property;", "retrieveStagingProfile", "", "publish-plugin"})
@SourceDebugExtension(value={"SMAP\nRetrieveStagingProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrieveStagingProfile.kt\nio/github/gradlenexus/publishplugin/RetrieveStagingProfile\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,61:1\n59#2:62\n*E\n*S KotlinDebug\n*F\n+ 1 RetrieveStagingProfile.kt\nio/github/gradlenexus/publishplugin/RetrieveStagingProfile\n*L\n39#1:62\n*E\n"})
public class RetrieveStagingProfile
extends AbstractNexusStagingRepositoryTask {
    @Input
    @NotNull
    private final Property<String> packageGroup;

    @NotNull
    public final Property<String> getPackageGroup() {
        return this.packageGroup;
    }

    @TaskAction
    public final void retrieveStagingProfile() {
        Object object = this.getRepository().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"repository.get()");
        NexusRepository repository = (NexusRepository)object;
        Object object2 = repository.getNexusUrl().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"repository.nexusUrl.get()");
        NexusClient client = new NexusClient((URI)object2, (String)repository.getUsername().getOrNull(), (String)repository.getPassword().getOrNull(), (Duration)this.getClientTimeout().getOrNull(), (Duration)this.getConnectTimeout().getOrNull());
        Object object3 = this.packageGroup.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"packageGroup.get()");
        String packageGroup = (String)object3;
        String string = client.findStagingProfileId(packageGroup);
        if (string == null) {
            throw (Throwable)new GradleException("Failed to find staging profile for package group: " + packageGroup);
        }
        String stagingProfileId = string;
        this.getLogger().lifecycle("Received staging profile id: '{}' for package {}", new Object[]{stagingProfileId, packageGroup});
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public RetrieveStagingProfile(@NotNull ObjectFactory objects, @NotNull NexusPublishExtension extension, @NotNull NexusRepository repository) {
        void $this$apply;
        Property property;
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        super(objects, extension, repository);
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property22 = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Property $i$f$property22 = property = property2;
        RetrieveStagingProfile retrieveStagingProfile = this;
        boolean bl = false;
        $this$apply.set((Provider)extension.getPackageGroup());
        Unit unit = Unit.INSTANCE;
        retrieveStagingProfile.packageGroup = property;
    }
}

