/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter4.layoutmanager;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Pair;
import androidx.annotation.CallSuper;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter4.BaseQuickAdapter;
import com.chad.library.adapter4.fullspan.FullSpanAdapterType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\"B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\fB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0010J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0017J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J \u0010\u001c\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u001bH\u0016J\u0012\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/chad/library/adapter4/layoutmanager/QuickGridLayoutManager;", "Landroidx/recyclerview/widget/GridLayoutManager;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "spanCount", "(Landroid/content/Context;I)V", "orientation", "reverseLayout", "", "(Landroid/content/Context;IIZ)V", "fullSpanSizeLookup", "Lcom/chad/library/adapter4/layoutmanager/QuickGridLayoutManager$FullSpanSizeLookup;", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "onAdapterChanged", "", "oldAdapter", "newAdapter", "onAttachedToWindow", "view", "Landroidx/recyclerview/widget/RecyclerView;", "onDetachedFromWindow", "recycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "setSpanSizeLookup", "spanSizeLookup", "Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "FullSpanSizeLookup", "com.github.CymChad.brvah"})
public class QuickGridLayoutManager
extends GridLayoutManager {
    @NotNull
    private final FullSpanSizeLookup fullSpanSizeLookup;
    @Nullable
    private RecyclerView.Adapter<?> adapter;

    public QuickGridLayoutManager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.fullSpanSizeLookup = new FullSpanSizeLookup();
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(this.getSpanSizeLookup());
        super.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.fullSpanSizeLookup);
    }

    public QuickGridLayoutManager(@NotNull Context context, int spanCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, spanCount);
        this.fullSpanSizeLookup = new FullSpanSizeLookup();
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(this.getSpanSizeLookup());
        super.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.fullSpanSizeLookup);
    }

    public QuickGridLayoutManager(@NotNull Context context, int spanCount, int orientation, boolean reverseLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, spanCount, orientation, reverseLayout);
        this.fullSpanSizeLookup = new FullSpanSizeLookup();
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(this.getSpanSizeLookup());
        super.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.fullSpanSizeLookup);
    }

    @CallSuper
    public void onAdapterChanged(@Nullable RecyclerView.Adapter<?> oldAdapter, @Nullable RecyclerView.Adapter<?> newAdapter) {
        this.adapter = newAdapter;
    }

    public void onAttachedToWindow(@Nullable RecyclerView view) {
        super.onAttachedToWindow(view);
        RecyclerView recyclerView = view;
        this.adapter = recyclerView != null ? recyclerView.getAdapter() : null;
    }

    public void onDetachedFromWindow(@Nullable RecyclerView view, @Nullable RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.adapter = null;
    }

    public void setSpanSizeLookup(@Nullable GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(spanSizeLookup);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/chad/library/adapter4/layoutmanager/QuickGridLayoutManager$FullSpanSizeLookup;", "Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "<init>", "(Lcom/chad/library/adapter4/layoutmanager/QuickGridLayoutManager;)V", "originalSpanSizeLookup", "getOriginalSpanSizeLookup", "()Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "setOriginalSpanSizeLookup", "(Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;)V", "getSpanSize", "", "position", "com.github.CymChad.brvah"})
    private final class FullSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        @Nullable
        private GridLayoutManager.SpanSizeLookup originalSpanSizeLookup;

        @Nullable
        public final GridLayoutManager.SpanSizeLookup getOriginalSpanSizeLookup() {
            return this.originalSpanSizeLookup;
        }

        public final void setOriginalSpanSizeLookup(@Nullable GridLayoutManager.SpanSizeLookup spanSizeLookup) {
            this.originalSpanSizeLookup = spanSizeLookup;
        }

        public int getSpanSize(int position) {
            int n;
            RecyclerView.Adapter adapter = QuickGridLayoutManager.this.adapter;
            if (adapter == null) {
                return 1;
            }
            RecyclerView.Adapter adapter2 = adapter;
            if (adapter2 instanceof ConcatAdapter) {
                int n2;
                Pair pair = ((ConcatAdapter)adapter2).getWrappedAdapterAndPosition(position);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getWrappedAdapterAndPosition(...)");
                Pair pair2 = pair;
                RecyclerView.Adapter wrappedAdapter = (RecyclerView.Adapter)pair2.first;
                if (wrappedAdapter instanceof FullSpanAdapterType) {
                    n2 = QuickGridLayoutManager.this.getSpanCount();
                } else if (wrappedAdapter instanceof BaseQuickAdapter) {
                    BaseQuickAdapter baseQuickAdapter = (BaseQuickAdapter)wrappedAdapter;
                    Object object = pair2.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                    int type = baseQuickAdapter.getItemViewType(((Number)object).intValue());
                    if (((BaseQuickAdapter)wrappedAdapter).isFullSpanItem(type)) {
                        n2 = QuickGridLayoutManager.this.getSpanCount();
                    } else {
                        GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                        n2 = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
                    }
                } else {
                    GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                    n2 = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
                }
                return n2;
            }
            RecyclerView.Adapter adapter3 = adapter2;
            if (adapter3 instanceof FullSpanAdapterType) {
                n = QuickGridLayoutManager.this.getSpanCount();
            } else if (adapter3 instanceof BaseQuickAdapter) {
                int type = ((BaseQuickAdapter)adapter2).getItemViewType(position);
                if (((BaseQuickAdapter)adapter2).isFullSpanItem(type)) {
                    n = QuickGridLayoutManager.this.getSpanCount();
                } else {
                    GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                    n = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
                }
            } else {
                GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                n = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
            }
            return n;
        }
    }
}

