/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.rtc2.internal.HardwareEarMonitorListener;
import io.agora.rtc2.internal.HuaweiHardwareEarMonitor;
import io.agora.rtc2.internal.IHardwareEarMonitor;
import io.agora.rtc2.internal.Logging;
import io.agora.rtc2.internal.VolumeChangeReceiver;

public class HardwareEarMonitorController
implements HardwareEarMonitorListener {
    private static final String TAG = HardwareEarMonitorController.class.getSimpleName();
    private static final String MANUFACTURER_HUAWEI = "huawei";
    private static HardwareEarMonitorController mInstance = null;
    private IHardwareEarMonitor mHardwareEarMonitor = null;
    protected VolumeChangeReceiver mVolumeChangeReceiver = null;

    @CalledByNative
    public static synchronized HardwareEarMonitorController getInstance() {
        if (mInstance == null) {
            mInstance = new HardwareEarMonitorController();
        }
        return mInstance;
    }

    private HardwareEarMonitorController() {
        String build = Build.MANUFACTURER;
        if (build.trim().toLowerCase().contains(MANUFACTURER_HUAWEI)) {
            this.mHardwareEarMonitor = new HuaweiHardwareEarMonitor(this);
        }
    }

    @CalledByNative
    public synchronized void initialize() {
        if (this.mHardwareEarMonitor != null) {
            this.mHardwareEarMonitor.initialize();
        }
    }

    @VisibleForTesting
    void setHardwareEarMonitor(IHardwareEarMonitor mHardwareEarMonitor) {
        this.mHardwareEarMonitor = mHardwareEarMonitor;
    }

    @CalledByNative
    public synchronized boolean isHardwareEarMonitorSupported() {
        return this.mHardwareEarMonitor != null && this.mHardwareEarMonitor.isHardwareEarMonitorSupported();
    }

    @CalledByNative
    public synchronized int enableHardwareEarMonitor(boolean enable) {
        if (this.mHardwareEarMonitor != null) {
            return this.mHardwareEarMonitor.enableHardwareEarMonitor(enable);
        }
        return -7;
    }

    @CalledByNative
    public synchronized int setHardwareEarMonitorVolume(int vol) {
        if (this.mHardwareEarMonitor != null) {
            return this.mHardwareEarMonitor.setHardwareEarMonitorVolume(vol);
        }
        return -7;
    }

    private synchronized void destroyImpl() {
        Context context = ContextUtils.getApplicationContext();
        try {
            if (this.mVolumeChangeReceiver != null && context != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mVolumeChangeReceiver);
                this.mVolumeChangeReceiver = null;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "unregister VolumeChangeReceiver failed ", e);
        }
        if (this.mHardwareEarMonitor != null) {
            this.mHardwareEarMonitor.destroy();
            this.mHardwareEarMonitor = null;
        }
    }

    @CalledByNative
    public static synchronized void destroy() {
        if (mInstance != null) {
            mInstance.destroyImpl();
        }
        mInstance = null;
    }

    @Override
    public synchronized void onInitSuccess() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return;
        }
        try {
            this.mVolumeChangeReceiver = new VolumeChangeReceiver();
            IntentFilter iFilter = new IntentFilter();
            iFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
            context.registerReceiver((BroadcastReceiver)this.mVolumeChangeReceiver, iFilter);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create VolumeChangeReceiver, ", e);
        }
    }
}

