/*
 * Decompiled with CFR 0.152.
 */
package io.agora.musiccontentcenter;

import io.agora.musiccontentcenter.IAgoraMusicPlayer;
import io.agora.musiccontentcenter.IMusicContentCenterEventHandler;
import io.agora.musiccontentcenter.MusicCacheInfo;
import io.agora.musiccontentcenter.MusicContentCenterConfiguration;
import io.agora.musiccontentcenter.internal.MusicContentCenterImpl;
import io.agora.rtc2.RtcEngine;

public abstract class IAgoraMusicContentCenter {
    private static IAgoraMusicContentCenter mInstance = null;

    public static synchronized IAgoraMusicContentCenter create(RtcEngine rtcEngine) {
        if (mInstance == null) {
            mInstance = new MusicContentCenterImpl(rtcEngine);
        }
        return mInstance;
    }

    public static synchronized void destroy() {
        if (mInstance == null) {
            return;
        }
        mInstance.doDestroy();
        mInstance = null;
    }

    public abstract int initialize(MusicContentCenterConfiguration var1);

    public abstract int renewToken(String var1);

    public abstract IAgoraMusicPlayer createMusicPlayer();

    public abstract int registerEventHandler(IMusicContentCenterEventHandler var1);

    public abstract int unregisterEventHandler();

    public abstract String preload(long var1);

    @Deprecated
    public abstract int preload(long var1, String var3);

    public abstract int isPreloaded(long var1);

    public abstract String getMusicCharts();

    public String getMusicCollectionByMusicChartId(int musicChartId, int page, int pageSize) {
        return this.getMusicCollectionByMusicChartId(musicChartId, page, pageSize, null);
    }

    public abstract String getMusicCollectionByMusicChartId(int var1, int var2, int var3, String var4);

    public String searchMusic(String keyword, int page, int pageSize) {
        return this.searchMusic(keyword, page, pageSize, null);
    }

    public abstract String searchMusic(String var1, int var2, int var3, String var4);

    public abstract String getLyric(long var1, int var3);

    public abstract int removeCache(long var1);

    public abstract MusicCacheInfo[] getCaches();

    public abstract String getSongSimpleInfo(long var1);

    public abstract long getInternalSongCode(long var1, String var3);

    protected abstract void doDestroy();

    class MusicCacheStatusType {
        public static final int MUSIC_CACHE_STATUS_TYPE_CACHED = 0;
        public static final int MUSIC_CACHE_STATUS_TYPE_CACHING = 1;

        private MusicCacheStatusType() {
        }
    }

    class MusicContentCenterStatusCode {
        public static final int MUSIC_CONTENT_CENTER_STATUS_OK = 0;
        public static final int MUSIC_CONTENT_CENTER_STATUS_ERR = 1;
        public static final int MUSIC_CONTENT_CENTER_STATUS_ERR_GATEWAY = 2;
        public static final int MUSIC_CONTENT_CENTER_STATUS_ERR_PERMISSION_AND_RESOURCE = 3;
        public static final int MUSIC_CONTENT_CENTER_STATUS_ERR_INTERNAL_DATA_PARSE = 4;
        public static final int MUSIC_CONTENT_CENTER_STATUS_ERR_MUSIC_LOADING = 5;
        public static final int MUSIC_CONTENT_CENTER_STATUS_ERR_MUSIC_DECRYPTION = 6;

        private MusicContentCenterStatusCode() {
        }
    }

    class PreloadStatusCode {
        public static final int PRELOAD_STATUS_COMPLETED = 0;
        public static final int PRELOAD_STATUS_FAILED = 1;
        public static final int PRELOAD_STATUS_PRELOADING = 2;
        public static final int PRELOAD_STATUS_REMOVED = 3;

        private PreloadStatusCode() {
        }
    }
}

