/*
 * Decompiled with CFR 0.152.
 */
package io.agora.mediaplayer.gl;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.YuvConverter;
import io.agora.mediaplayer.IPlayerTextureHelper;
import io.agora.rtc2.internal.Logging;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;

@TargetApi(value=18)
public class PlayerTextureHelper
implements IPlayerTextureHelper,
SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "PlayerTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final EglBase.Context sharedContext;
    private final SurfaceTexture surfaceTexture;
    private Surface renderSurface = null;
    private final int oesTextureId;
    private final YuvConverter yuvConverter = new YuvConverter();
    private boolean hasPendingTexture = false;
    private boolean isQuitting = false;
    private int textureWidth;
    private int textureHeight;
    protected static final int MAX_BUFFER_CNT = 12;
    private final Object newFrameLock = new Object();
    private final Queue<VideoFrame> decodedTextureBuffers = new LinkedList<VideoFrame>();
    public static final float[] IDENTITY_MATRIX = new float[16];
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            if (PlayerTextureHelper.this.hasPendingTexture) {
                PlayerTextureHelper.this.updateTexImage();
                PlayerTextureHelper.this.hasPendingTexture = false;
            }
        }
    };
    private final TextureBufferPool textureBufferPool;

    @Nullable
    public static PlayerTextureHelper create() {
        if (!PlayerTextureHelper.isEgl14Supported()) {
            Logging.i(TAG, "device not support Egl14");
            return null;
        }
        final String threadName = "player-texture-thread" + System.currentTimeMillis();
        final EglBase.Context sharedContext = null;
        Logging.i(TAG, "PlayerTextureHelper create " + threadName);
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<PlayerTextureHelper>(){

                @Override
                @Nullable
                public PlayerTextureHelper call() {
                    try {
                        return new PlayerTextureHelper(sharedContext, handler);
                    }
                    catch (RuntimeException e) {
                        Logging.e(PlayerTextureHelper.TAG, threadName + " create failure", e);
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, threadName + " create failure", e);
            return null;
        }
    }

    private static boolean isEgl14Supported() {
        return EglBase14.isEGL14SupportedImpl();
    }

    private PlayerTextureHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelperTest must be created on the handler thread");
        }
        Logging.i(TAG, "PlayerTextureHelper new " + this);
        this.handler = handler;
        this.eglBase = new EglBase14((EglBase14.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
        this.textureBufferPool = TextureBufferPool.createWithinGlThread("PlayerTextureBufferPool", 12, 6407, handler, this.eglBase, this.yuvConverter);
        this.sharedContext = sharedContext != null ? sharedContext : this.eglBase.getEglBaseContext();
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        PlayerTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, this, handler);
        this.setDefaultTextureSize(640, 360);
        this.startListening();
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.hasPendingTexture = true;
        this.tryDeliverTextureFrame();
    }

    @Override
    public long getEglContextHandler() {
        return this.sharedContext.getNativeEglContext();
    }

    @Override
    public Surface getRenderGlSurface() {
        if (this.renderSurface == null) {
            this.renderSurface = new Surface(this.getSurfaceTexture());
        }
        Logging.i(TAG, "getRenderGlSurface " + this + " renderSurface:" + this.renderSurface);
        return this.renderSurface;
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(listener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(listener);
        }
    }

    private void startListening() {
        this.handler.post(this.setListenerRunnable);
    }

    private void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
    }

    @Override
    public void setTextureSize(final int width, final int height) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    PlayerTextureHelper.this.textureWidth = width;
                    PlayerTextureHelper.this.textureHeight = height;
                }
            });
        }
    }

    private void setDefaultTextureSize(final int width, final int height) {
        if (width <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + height);
        }
        this.surfaceTexture.setDefaultBufferSize(width, height);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                PlayerTextureHelper.this.textureWidth = width;
                PlayerTextureHelper.this.textureHeight = height;
            }
        });
    }

    private SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    @Override
    public void dispose() {
        this.stopListening();
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    PlayerTextureHelper.this.isQuitting = true;
                    PlayerTextureHelper.this.release();
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "dispose faile: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        try {
            Object object = EglBase.lock;
            synchronized (object) {
                this.surfaceTexture.updateTexImage();
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to updateTexImage. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.hasPendingTexture) {
            return;
        }
        this.hasPendingTexture = false;
        this.updateTexImage();
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            Logging.e("Texture size has not been set.");
            return;
        }
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        VideoFrame.TextureBuffer textureCopy = null;
        TextureBuffer buffer = new TextureBuffer(this.sharedContext, this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.handler, this.yuvConverter, null);
        textureCopy = this.textureCopy(buffer);
        buffer.release();
        if (textureCopy == null) {
            Logging.e("java oesTextureId:" + this.oesTextureId + " context:" + this.sharedContext.getNativeEglContext() + " java pts:" + this.surfaceTexture.getTimestamp());
            return;
        }
        VideoFrame frame = new VideoFrame(textureCopy, 0, this.surfaceTexture.getTimestamp());
        Object object = this.newFrameLock;
        synchronized (object) {
            this.decodedTextureBuffers.offer(frame);
            this.newFrameLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoFrame getAvailableTextureInfo(int waitTime) {
        Object object = this.newFrameLock;
        synchronized (object) {
            while (this.decodedTextureBuffers.isEmpty()) {
                try {
                    this.newFrameLock.wait(waitTime);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            VideoFrame videoFrame = this.decodedTextureBuffers.poll();
            return videoFrame;
        }
    }

    @Override
    public VideoFrame getFakeTextureInfo() {
        Logging.i("getFakeTextureInfo");
        TextureBuffer buffer = new TextureBuffer(this.sharedContext, 640, 360, VideoFrame.TextureBuffer.Type.RGB, 0, RendererCommon.convertMatrixToAndroidGraphicsMatrix(IDENTITY_MATRIX), this.handler, this.yuvConverter, null);
        VideoFrame frame = new VideoFrame(buffer, 0, 0L);
        return frame;
    }

    @Override
    public void releaseRenderedTextureInfo(VideoFrame info) {
        if (info != null) {
            info.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTextureBufferQueue() {
        Object object = this.newFrameLock;
        synchronized (object) {
            Logging.i(TAG, "resetTextureBufferQueue " + this.decodedTextureBuffers.size());
            for (VideoFrame frame : this.decodedTextureBuffers) {
                frame.release();
            }
            this.decodedTextureBuffers.clear();
        }
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (!this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.textureBufferPool.dispose();
        this.surfaceTexture.release();
        this.eglBase.release();
        this.resetTextureBufferQueue();
        this.handler.getLooper().quit();
        Logging.i(TAG, "release player texture helper " + this);
    }

    @Nullable
    public VideoFrame.TextureBuffer textureCopy(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer.getTextureId() != this.oesTextureId) {
            throw new IllegalStateException("textureCopy called with unexpected textureId");
        }
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() {
                    return PlayerTextureHelper.this.textureBufferPool.textureCopy(textureBuffer, new Runnable(){

                        @Override
                        public void run() {
                            Logging.i(PlayerTextureHelper.TAG, "textureBufferPool release");
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Logging.i(TAG, "textureBufferPool release faile: " + e.getMessage());
            return null;
        }
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

