/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.content.Context;
import android.graphics.ColorSpace;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;

class VideoRenderUtils {
    private static final String TAG = "VideoRenderUtils";

    VideoRenderUtils() {
    }

    @CalledByNative
    static boolean isSupportedHDRByType(int hdrType) {
        Display.HdrCapabilities cap;
        Display display;
        WindowManager wm;
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 26 && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null && !display.isHdr()) {
            Logging.d(TAG, "hdrcap:ishdr:false");
            return false;
        }
        if (Build.VERSION.SDK_INT >= 24 && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null && (cap = display.getHdrCapabilities()) != null) {
            for (int i = 0; i < cap.getSupportedHdrTypes().length; ++i) {
                Logging.d(TAG, "hdrcap:" + cap.getSupportedHdrTypes()[i]);
                if (cap.getSupportedHdrTypes()[i] != hdrType) continue;
                Logging.d(TAG, "hdrcap: got:" + cap.getSupportedHdrTypes()[i]);
                return true;
            }
        }
        return false;
    }

    public static float getDesiredMaxAverageLuminance() {
        Display.HdrCapabilities cap;
        Display display;
        WindowManager wm;
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 24 && context != null && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null && (cap = display.getHdrCapabilities()) != null) {
            float average = cap.getDesiredMaxAverageLuminance();
            Logging.d(TAG, "hdrcap:average luma:" + average);
            return average;
        }
        return -1.0f;
    }

    public static float getDesiredMaxLuminance() {
        Display.HdrCapabilities cap;
        Display display;
        WindowManager wm;
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 24 && context != null && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null && (cap = display.getHdrCapabilities()) != null) {
            float max = cap.getDesiredMaxLuminance();
            Logging.d(TAG, "hdrcap:max luma:" + max);
            return max;
        }
        return -1.0f;
    }

    public static float getDesiredMinLuminance() {
        Display.HdrCapabilities cap;
        Display display;
        WindowManager wm;
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 24 && context != null && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null && (cap = display.getHdrCapabilities()) != null) {
            float min = cap.getDesiredMinLuminance();
            Logging.d(TAG, "hdrcap:min luma:" + min);
            return min;
        }
        return -1.0f;
    }

    @CalledByNative
    static boolean isWideColorGamut() {
        Display display;
        WindowManager wm;
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 26 && context != null && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null) {
            boolean isWide = display.isWideColorGamut();
            Logging.d(TAG, "hdrcap:is wide:" + isWide);
            return isWide;
        }
        return false;
    }

    @CalledByNative
    static int getPreferredWideGamutColorSpaceId() {
        ColorSpace colorSpace;
        Display display;
        WindowManager wm;
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 29 && context != null && (wm = (WindowManager)context.getSystemService("window")) != null && (display = wm.getDefaultDisplay()) != null && (colorSpace = display.getPreferredWideGamutColorSpace()) != null) {
            int id = colorSpace.getId();
            Logging.d(TAG, "hdrcap:color space id:" + id);
            return id;
        }
        return -1;
    }

    public static class ColorSpaceNamed {
        public static final int SRGB = 0;
        public static final int BT709 = 4;
        public static final int BT2020 = 5;
        public static final int DCI_P3 = 6;
        public static final int DISPLAY_P3 = 7;
    }

    public static class HDRType {
        public static final int HDR_TYPE_DOLBY_VISION = 1;
        public static final int HDR_TYPE_HDR10 = 2;
        public static final int HDR_TYPE_HLG = 3;
        public static final int HDR_TYPE_HDR10_PLUS = 4;
    }
}

