/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.IHandlerReplaceable;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.base.internal.video.YuvConverter;
import javax.microedition.khronos.egl.EGLContext;

public class VideoFrameSenderExImpl {
    private static final String TAG = "VideoFrameSenderEx";
    @Nullable
    private EglBase.Context eglContext = null;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper = null;
    @Nullable
    private Handler toI420Handler = null;
    @Nullable
    private YuvConverter yuvConverter = null;
    private final Object surfaceTextureHelperLock = new Object();

    static EglBase.Context createEglBaseContext(Object sharedEglContext) {
        EglBase.Context eglContext;
        if (sharedEglContext instanceof EglBase.Context) {
            eglContext = (EglBase.Context)sharedEglContext;
        } else if (sharedEglContext instanceof EGLContext) {
            eglContext = new EglBase10.Context((EGLContext)sharedEglContext);
        } else if (Build.VERSION.SDK_INT >= 17 && sharedEglContext instanceof android.opengl.EGLContext) {
            eglContext = new EglBase14.Context((android.opengl.EGLContext)sharedEglContext);
        } else {
            throw new IllegalArgumentException("illegal egl context");
        }
        return eglContext;
    }

    @CalledByNative
    VideoFrameSenderExImpl() {
        Logging.d(TAG, "constructor()");
    }

    @Nullable
    @CalledByNative
    VideoFrame.Buffer completeI420Converter(VideoFrame.Buffer buffer) {
        boolean result;
        boolean contextChanged;
        if (!(buffer instanceof IHandlerReplaceable) && !(buffer instanceof VideoFrame.TextureBuffer)) {
            return buffer;
        }
        IHandlerReplaceable replaceable = (IHandlerReplaceable)((Object)buffer);
        if (replaceable.getToI420Handler() != null && replaceable.getYuvConverter() != null) {
            return buffer;
        }
        VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
        EglBase.Context context = textureBuffer.getEglBaseContext();
        boolean bl = contextChanged = this.eglContext == null || !this.eglContext.equals(context);
        if (contextChanged && !(result = this.createI420Converter(context))) {
            return null;
        }
        if (this.toI420Handler != null && this.yuvConverter != null) {
            return replaceable.applyNewI420Handler(this.toI420Handler, this.yuvConverter);
        }
        Logging.e(TAG, "converter null");
        return null;
    }

    @Nullable
    @CalledByNative
    VideoFrame.Buffer newTextureBuffer(Object sharedEglContext, int width, int height, int pixelFormat, int id, float[] transformMatrix) {
        VideoFrame.TextureBuffer.Type type;
        EglBase.Context eglContext = VideoFrameSenderExImpl.createEglBaseContext(sharedEglContext);
        if (pixelFormat == 10) {
            type = VideoFrame.TextureBuffer.Type.RGB;
        } else if (pixelFormat == 11) {
            type = VideoFrame.TextureBuffer.Type.OES;
        } else {
            throw new IllegalArgumentException("illegal pixel format");
        }
        if (transformMatrix.length != 16) {
            throw new IllegalArgumentException("unsupported matrix");
        }
        Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix);
        TextureBuffer textureBuffer = new TextureBuffer(eglContext, width, height, type, id, matrix, null, null, null);
        VideoFrame.Buffer result = this.completeI420Converter(textureBuffer);
        textureBuffer.release();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createI420Converter(@NonNull EglBase.Context context) {
        Logging.d(TAG, "createI420Converter()");
        if (this.surfaceTextureHelper != null) {
            this.dispose();
        }
        Object object = this.surfaceTextureHelperLock;
        synchronized (object) {
            this.surfaceTextureHelper = SurfaceTextureHelper.create("VideoFrameSender", context);
            if (this.surfaceTextureHelper == null) {
                Logging.e(TAG, "Failed to create surfaceTextureHelper");
                return false;
            }
            this.eglContext = context;
            this.toI420Handler = this.surfaceTextureHelper.getHandler();
            this.yuvConverter = new YuvConverter();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void dispose() {
        Logging.d(TAG, "dispose()");
        Object object = this.surfaceTextureHelperLock;
        synchronized (object) {
            if (this.toI420Handler != null) {
                try {
                    ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Runnable(){

                        @Override
                        public void run() {
                            VideoFrameSenderExImpl.this.yuvConverter.release();
                        }
                    });
                }
                catch (Exception e) {
                    Logging.e(TAG, "yuvConverter release failed:" + e.toString());
                }
            }
            if (this.surfaceTextureHelper != null) {
                this.surfaceTextureHelper.dispose();
                this.surfaceTextureHelper = null;
            }
        }
    }

    static @interface VIDEO_PIXEL_FORMAT {
        public static final int VIDEO_TEXTURE_2D = 10;
        public static final int VIDEO_TEXTURE_OES = 11;
    }
}

