/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.VideoCodecType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class VideoEncoderUtils {
    private static final String TAG = "HardwareVideoEncoderUtils";
    private static final HashMap<VideoCodecType, MediaCodecInfo> codecByTypeCache = new HashMap();
    public static final int FINDCODEC_TIMEOUT = 3000;
    public static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("Lenovo S90-u", "CHM-CL00", "CHM-TL00H", "CHM-UL00", "E6533", "HUAWEI CRR-UL00", "HUAWEI MT7-TL00", "HONOR H30-L01", "CHE-TL00H", "CHE-TL00", "Che2-TL00", "Che2-TL00M", "HTC D820mt", "HUAWEI P7-L10", "HUAWEI P7-L07", "M5s", "SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060");
    private static final List<String> H265_HW_EXCEPTION_HARDWARES = Arrays.asList("mt6771", "mt6762");

    @CalledByNative
    static boolean isSupportHwEncoderByType(String codecType) {
        return VideoCodecType.contains(codecType) && (VideoEncoderUtils.findCodecForType(VideoCodecType.valueOf(codecType), false) != null || VideoEncoderUtils.findCodecForType(VideoCodecType.valueOf(codecType), true) != null);
    }

    @Nullable
    static MediaCodecInfo findCodecForType(final VideoCodecType type, final boolean useTexture) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (codecByTypeCache.containsKey((Object)type)) {
            return codecByTypeCache.get((Object)type);
        }
        final MediaCodecInfo[] result = new MediaCodecInfo[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                    MediaCodecInfo info = null;
                    try {
                        info = MediaCodecList.getCodecInfoAt((int)i);
                    }
                    catch (IllegalArgumentException e) {
                        Logging.e(VideoEncoderUtils.TAG, "Cannot retrieve encoder codec info", e);
                    }
                    if (info == null || !info.isEncoder() || !VideoEncoderUtils.isSupportedCodec(info, type, useTexture)) continue;
                    Logging.d(VideoEncoderUtils.TAG, "found available encodec: " + info.getName());
                    result[0] = info;
                    break;
                }
                codecByTypeCache.put(type, result[0]);
                countDownLatch.countDown();
            }
        }).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 3000L)) {
            Logging.e(TAG, "findCodecForType timeout");
        }
        return result[0];
    }

    static boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type, boolean useTexture) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            Logging.w(TAG, "not support codec type:" + (Object)((Object)type));
            return false;
        }
        try {
            if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.encoderColorFormats(info.getName()), info.getCapabilitiesForType(type.mimeType())) == null) {
                Logging.e(TAG, "no match color format");
                return false;
            }
        }
        catch (Exception e) {
            Logging.w(TAG, "fail to selectColorFormat, not support mimeType:" + type.mimeType());
            return false;
        }
        if (MediaCodecUtils.checkInvalidEncoder(info.getName())) {
            return false;
        }
        if (useTexture) {
            return VideoEncoderUtils.isHardwareTextureSupportedInCurrentSdk(info, type);
        }
        return VideoEncoderUtils.isHardwareSupportedInCurrentSdk(info, type);
    }

    static boolean isHardwareTextureSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
                    return false;
                }
                if (info.getName().startsWith("OMX.k3.")) {
                    return Build.VERSION.SDK_INT > 19;
                }
                return Build.VERSION.SDK_INT >= 19;
            }
            case H265: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkH265();
            }
            case UNKNOWN: {
                Logging.e(TAG, "UNKNOWN is not excepted!!!");
                return false;
            }
        }
        return false;
    }

    static boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkH264(info);
            }
            case H265: {
                return VideoEncoderUtils.isHardwareSupportedInCurrentSdkH265();
            }
            case UNKNOWN: {
                Logging.e(TAG, "UNKNOWN is not excepted!!!");
                return false;
            }
        }
        return false;
    }

    static boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21;
    }

    static boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String name = info.getName();
        return (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    static boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String name = info.getName();
        if (name.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    static boolean isHardwareSupportedInCurrentSdkH265() {
        if (H265_HW_EXCEPTION_HARDWARES.contains(Build.HARDWARE)) {
            Logging.w(TAG, "Hardware: " + Build.HARDWARE + " has black listed H.265 encoder.");
            return false;
        }
        return Build.VERSION.SDK_INT >= 21;
    }
}

