/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;

public class TextureBufferHelper {
    private static final String TAG = "TextureBufferHelper";
    private GlRectDrawer textureDrawer;
    private GlTextureFrameBuffer textureFrameBuffer;
    private final Handler handler;
    private final EglBase eglBase;
    private final YuvConverter yuvConverter = new YuvConverter();
    private int numOfTextureInUse = 0;
    private boolean isQuitting = false;

    @Nullable
    public static TextureBufferHelper create(final String threadName, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TextureBufferHelper>(){

                @Override
                public TextureBufferHelper call() {
                    try {
                        return new TextureBufferHelper(sharedContext, handler);
                    }
                    catch (RuntimeException e) {
                        Logging.e(TextureBufferHelper.TAG, threadName + " create failure", e);
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, threadName + " create failure", e);
            return null;
        }
    }

    private TextureBufferHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("TextureBufferHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase14.isEGL14Supported() && (sharedContext == null || sharedContext instanceof EglBase14.Context) ? new EglBase14((EglBase14.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER) : new EglBase10((EglBase10.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public EglBase getEglBase() {
        return this.eglBase;
    }

    public <V> V invoke(Callable<V> callable) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, callable);
    }

    public VideoFrame.TextureBuffer wrapTextureBuffer(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix) {
        ++this.numOfTextureInUse;
        return new TextureBuffer(this.eglBase.getEglBaseContext(), width, height, type, id, transformMatrix, this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.returnTextureFrame();
            }
        });
    }

    public int convertToRGBA(TextureBuffer buffer, int rotation) {
        if (buffer == null) {
            return 0;
        }
        if (buffer.getType() == VideoFrame.TextureBuffer.Type.RGB) {
            return buffer.getTextureId();
        }
        if (this.textureDrawer == null) {
            this.textureDrawer = new GlRectDrawer();
        }
        if (this.textureFrameBuffer == null) {
            this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
        }
        int frameWidth = rotation % 180 == 0 ? buffer.getWidth() : buffer.getHeight();
        int frameHeight = rotation % 180 == 0 ? buffer.getHeight() : buffer.getWidth();
        this.textureFrameBuffer.setSize(frameWidth, frameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        GLES20.glClear((int)16384);
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preRotate((float)rotation);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        renderMatrix.postConcat(buffer.getTransformMatrix());
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(renderMatrix);
        this.textureDrawer.drawOes(buffer.getTextureId(), finalGlMatrix, frameWidth, frameHeight, 0, 0, frameWidth, frameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return this.textureFrameBuffer.getTextureId();
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.numOfTextureInUse--;
                if (TextureBufferHelper.this.isQuitting) {
                    TextureBufferHelper.this.release();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.numOfTextureInUse > 0;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    TextureBufferHelper.this.isQuitting = true;
                    if (!TextureBufferHelper.this.isTextureInUse()) {
                        TextureBufferHelper.this.release();
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.d(TAG, "dispose fail: " + e.getMessage());
        }
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse() || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        Logging.d(TAG, "release()");
        if (this.textureDrawer != null) {
            this.textureDrawer.release();
            this.textureDrawer = null;
        }
        if (this.textureFrameBuffer != null) {
            this.textureFrameBuffer.release();
            this.textureFrameBuffer = null;
        }
        this.yuvConverter.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }
}

