/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import io.agora.rtc.internal.AudioRoutingListener;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private WeakReference<Context> mContext;
    private EventHandler mEventHandler;
    private WeakReference<AudioRoutingListener> mListener;
    AudioManager am = null;
    private HeadsetBroadcastReceiver mHeadsetReceiver;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private static final int HEADSET = 0;
    private static final int EARPIECE = 1;
    private static final int SPEAKER = 3;
    private static final int STOP = 4;
    private static final int BLUETOOTH = 5;
    private AudioRouteState mState;
    private StopState mStopState = null;
    private SpeakerState mSpeakerState = null;
    private EarpieceState mEarpieceState = null;
    private BTState mBTState = null;
    private HeadsetState mHeadsetState = null;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET_A2DP = 2;
    private static final int EVT_BT_SCO = 3;
    private static final int EVT_BT_HEADSET_HFP = 4;
    public static final int CMD_DEFAULT_DEVICE = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_MUTE_VIDEO_LOCAL = 12;
    public static final int CMD_MUTE_VIDEO_REMOTES = 13;
    public static final int CMD_MUTE_VIDEO_ALL = 14;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    public static final int EVT_USING_COMM_PARAMETERS = 112;
    public static final int EVT_USING_NORM_PARAMETERS = 113;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    private AudioDeviceList mAvailDevices;
    private int mTargetRoute = -1;
    private boolean mIsBTHeadsetPlugged = false;
    private boolean mVideoDisabled = true;
    private boolean mMuteLocal = false;
    private boolean mMuteRemotes = false;
    private boolean mPhoneInCall = false;
    private boolean mHfpEnable = false;
    private boolean mA2dpEnable = false;
    private int mStreamType = 0;
    private int mChannelProfile = 1;
    private static final int BT_SCO_STATE_CONNECTING = 0;
    private static final int BT_SCO_STATE_CONNECTED = 1;
    private static final int BT_SCO_STATE_DISCONNECTING = 2;
    private static final int BT_SCO_STATE_DISCONNECTED = 3;
    private int mBtScoState = 3;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 3000;
    private static final int BLUETOOTH_RESET_BT_DELAY = 3000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 5;
    private int dynamic_timeout = 0;
    private int mScoConnectionAttemps;
    private int mLastNotifiedRouting = -1;
    private final Runnable TryConnectBtScoRunnable = new Runnable(){

        @Override
        public void run() {
            AudioRoutingController.this.tryToConnectBtSco();
        }
    };
    private final Runnable TrytoResetBTRunnable = new Runnable(){

        @Override
        public void run() {
            if (!AudioRoutingController.this.am.isBluetoothA2dpOn() && !AudioRoutingController.this.am.isBluetoothScoOn()) {
                AudioRoutingController.this.resetBtAdapter();
            } else {
                Logging.d(AudioRoutingController.TAG, "reset bluetooth failed a2dp: " + AudioRoutingController.this.am.isBluetoothA2dpOn() + " sco:" + AudioRoutingController.this.am.isBluetoothScoOn());
            }
        }
    };

    private void checkNeedResetBT() {
        this.mEventHandler.postDelayed(this.TrytoResetBTRunnable, 3000L);
    }

    private void startTimer() {
        this.dynamic_timeout += 3000;
        Logging.d(TAG, "audio route start bluetooth timer " + this.dynamic_timeout + ", times:" + this.mScoConnectionAttemps);
        this.mEventHandler.postDelayed(this.TryConnectBtScoRunnable, 3000L);
    }

    private void cancelTimer() {
        Logging.d(TAG, "cancel bluetooth timer");
        this.dynamic_timeout = 0;
        this.mScoConnectionAttemps = 0;
        this.mEventHandler.removeCallbacks(this.TryConnectBtScoRunnable);
    }

    public AudioRoutingController(Context context, AudioRoutingListener audioRoutingListener) {
        this.mContext = new WeakReference<Context>(context);
        this.mListener = new WeakReference<AudioRoutingListener>(audioRoutingListener);
        this.am = this.getAudioManager();
    }

    private void changeState(int n2) {
        switch (n2) {
            case 4: {
                if (this.mStopState == null) {
                    this.mStopState = new StopState();
                }
                this.mState = this.mStopState;
                Logging.d(TAG, "--------------------Comming to STOP-------------------- ");
                break;
            }
            case 5: {
                if (this.mBTState == null) {
                    this.mBTState = new BTState();
                }
                this.mState = this.mBTState;
                Logging.d(TAG, "--------------------Comming to BLUETOOTH--------------- ");
                break;
            }
            case 0: {
                if (this.mHeadsetState == null) {
                    this.mHeadsetState = new HeadsetState();
                }
                this.mState = this.mHeadsetState;
                Logging.d(TAG, "--------------------Comming to HEADSET----------------- ");
                break;
            }
            case 3: {
                if (this.mSpeakerState == null) {
                    this.mSpeakerState = new SpeakerState();
                }
                this.mState = this.mSpeakerState;
                Logging.d(TAG, "--------------------Comming to SPEAKER----------------- ");
                break;
            }
            case 1: {
                if (this.mEarpieceState == null) {
                    this.mEarpieceState = new EarpieceState();
                }
                this.mState = this.mEarpieceState;
                Logging.d(TAG, "--------------------Comming to EARPIECE---------------- ");
                break;
            }
            default: {
                Logging.d(TAG, "--------------------Comming to UNKNOWN STATE----------- ");
                if (this.mSpeakerState == null) {
                    this.mSpeakerState = new SpeakerState();
                }
                this.mState = this.mSpeakerState;
            }
        }
        this.mState.switchtoTargetRoute();
    }

    public void sendEvent(int n2, int n3) {
        Logging.d(TAG, "sendEvent: [" + this.getEventDesc(n2) + "], Parameters: " + n3 + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message message = this.mEventHandler.obtainMessage(n2, n3, 0);
            this.mEventHandler.sendMessage(message);
        }
    }

    public int initialize() {
        Logging.i(TAG, "initialize +");
        this.mAvailDevices = new AudioDeviceList();
        this.mAvailDevices.mDefaultRoute = -1;
        this.mAvailDevices.mForcedRoute = -1;
        this.mAvailDevices.mHeadSetRoute = -1;
        this.mAvailDevices.mBTRoute = -1;
        Context context = (Context)this.mContext.get();
        if (context == null || this.am == null) {
            Logging.e(TAG, "Initilize Failed cause of invalid context or invalid audiomanager");
            return -1;
        }
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null);
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        this.changeState(4);
        if (!this.mHeadsetReceiver.getRegistered()) {
            context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            this.mHeadsetReceiver.setRegistered(true);
        }
        if (Build.VERSION.SDK_INT < 11 && 0 != context.checkPermission("android.permission.BLUETOOTH", Process.myPid(), Process.myUid())) {
            Logging.w(TAG, "do not support BT monitoring on this device");
            return 0;
        }
        if (this.mBTHeadsetListener != null) {
            Logging.w(TAG, "Bluetooth service Listener already been initialized");
        } else {
            try {
                this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                    public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
                        Logging.i(AudioRoutingController.TAG, "onServiceConnected " + n2 + " =? headset(" + 1 + ")");
                        if (n2 == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service connected: " + n2 + " " + bluetoothProfile);
                            AudioRoutingController.this.mBTHeadset = (BluetoothHeadset)bluetoothProfile;
                        }
                    }

                    public void onServiceDisconnected(int n2) {
                        Logging.i(AudioRoutingController.TAG, "onServiceDisconnected " + n2 + " =? headset(" + 1 + ")");
                        if (n2 == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service disconnected: " + n2);
                            AudioRoutingController.this.am.setBluetoothScoOn(false);
                            AudioRoutingController.this.am.stopBluetoothSco();
                            AudioRoutingController.this.cancelTimer();
                            AudioRoutingController.this.mBTHeadset = null;
                        }
                    }
                };
            }
            catch (Exception exception) {
                Logging.e(TAG, "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + exception.getMessage());
            }
        }
        if (!this.hasPermission(context, "android.permission.BLUETOOTH")) {
            Logging.w(TAG, "lacks BLUETOOTH permission");
            return 0;
        }
        try {
            if (this.mBTHeadsetReceiver == null) {
                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
            }
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBTAdapter == null || this.mBTHeadsetListener == null) {
                Logging.e(TAG, "initialize: failed to get bluetooth adapter!!");
                return 0;
            }
            this.mBTAdapter.getProfileProxy(context.getApplicationContext(), this.mBTHeadsetListener, 1);
            if (2 == this.mBTAdapter.getProfileConnectionState(1)) {
                this.mHfpEnable = true;
            }
            if (2 == this.mBTAdapter.getProfileConnectionState(2)) {
                this.mA2dpEnable = true;
            }
            Logging.i(TAG, "BT headset setup: mA2dpEnable = " + this.mA2dpEnable + " mHfpEnable " + this.mHfpEnable + " " + this.mBTHeadset);
            IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            intentFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            if (!this.mBTHeadsetReceiver.getRegistered()) {
                Intent intent = context.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, intentFilter);
                this.mBTHeadsetReceiver.setRegistered(true);
                if (intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    int n2 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                    switch (n2) {
                        case 1: {
                            Logging.i(TAG, "initial Bluetooth SCO device connected");
                            this.mBtScoState = 1;
                            this.mAvailDevices.mBTRoute = 5;
                            break;
                        }
                        default: {
                            Logging.i(TAG, "initial Bluetooth SCO device unconnected");
                            this.mBtScoState = 3;
                        }
                    }
                }
            }
            this.getBtDeviceList();
        }
        catch (Exception exception) {
            Logging.e(TAG, "unable to create BluetoothHeadsetBroadcastReceiver, err:" + exception.getMessage());
        }
        Logging.i(TAG, "initialize -");
        return 0;
    }

    private void clearBTResource() {
        if (this.mBTAdapter != null) {
            int n2 = this.mBTAdapter.getProfileConnectionState(1);
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            if (n2 != 2) {
                this.cancelTimer();
                this.mBTHeadset = null;
            }
            this.mBTAdapter = null;
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    public void uninitialize() {
        Logging.d(TAG, "uninitialize");
        try {
            this.clearBTResource();
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            this.mHeadsetReceiver = null;
            this.mBTHeadsetReceiver = null;
        }
        catch (Exception exception) {
            Logging.e(TAG, "AudioRoutingController uninitialize fail: ", exception);
        }
    }

    public void startMonitoring(int n2, int n3) {
        Context context = (Context)this.mContext.get();
        int n4 = 0;
        Logging.i(TAG, "--------------Comming to startMonitoring--------------------");
        this.notifyAudioBtProfileChanged();
        this.changeAvailDevices(10, n2);
        this.mChannelProfile = n3;
        if (this.mAvailDevices.mDefaultRoute == -1) {
            if (this.mChannelProfile == 0 && this.isAudioOnly()) {
                this.changeAvailDevices(10, 1);
                this.am.setSpeakerphoneOn(false);
            } else {
                this.changeAvailDevices(10, 3);
                this.am.setSpeakerphoneOn(false);
                this.am.setSpeakerphoneOn(true);
            }
        }
        if (this.getBtDeviceList() > 0) {
            this.mAvailDevices.mBTRoute = 5;
            this.checkNeedResetBT();
        }
        n4 = this.setTargetRouteByPriority();
        Logging.i(TAG, "mDefaultRoute: ," + this.mAvailDevices.mDefaultRoute + "  mAvailDevices.mForcedRoute :" + this.mAvailDevices.mForcedRoute);
        Logging.i(TAG, "mBtRoute: " + this.getAudioRouteDesc(this.mAvailDevices.mBTRoute) + ",mAvailDevices.mHeadSetRoute :" + this.getAudioRouteDesc(this.mAvailDevices.mHeadSetRoute));
        this.changeState(n4);
    }

    public void stopMonitoring() {
        Logging.i(TAG, "Stop Mornitor State process");
        this.changeState(4);
    }

    public void clearListenerNativeHandle() {
        Logging.d(TAG, "clearListenerNativeHandle");
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingDestroyed();
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private boolean isAudioOnly() {
        return this.mVideoDisabled || this.mMuteLocal && this.mMuteRemotes;
    }

    private AudioManager getAudioManager() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int n2) {
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingChanged(n2);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private void notifyAudioBtProfileChanged() {
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            int n2 = 0;
            n2 |= this.mHfpEnable ? 1 : 0;
            audioRoutingListener.onAudioBtProfileChanged(n2 |= this.mA2dpEnable ? 2 : 0);
            Logging.i(TAG, "BT headset  btProfile " + n2);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private void changeStateByPriority() {
        if (this.getBtDeviceList() > 0) {
            this.checkNeedResetBT();
            if (this.mStreamType == 0) {
                this.enableBtSco();
            }
            this.changeState(5);
        } else if (this.mAvailDevices.mHeadSetRoute != -1) {
            this.changeState(0);
        } else if (this.mAvailDevices.mForcedRoute != -1) {
            this.changeState(this.mAvailDevices.mForcedRoute);
        } else {
            this.changeState(this.mAvailDevices.mDefaultRoute);
        }
    }

    public void changeAvailDevices(int n2, int n3) {
        switch (n2) {
            case 11: {
                if (n3 == 0) {
                    this.mAvailDevices.mForcedRoute = 1;
                    break;
                }
                this.mAvailDevices.mForcedRoute = 3;
                break;
            }
            case 1: {
                if (n3 >= 0) {
                    this.mAvailDevices.mHeadSetRoute = n3 > 0 ? 2 : 0;
                    break;
                }
                this.mAvailDevices.mHeadSetRoute = -1;
                break;
            }
            case 2: 
            case 4: {
                if (this.mA2dpEnable | this.mHfpEnable) {
                    this.mAvailDevices.mBTRoute = 5;
                    break;
                }
                this.mAvailDevices.mBTRoute = -1;
                break;
            }
            case 10: {
                this.mAvailDevices.mDefaultRoute = n3;
                break;
            }
            default: {
                Logging.i(TAG, "No device changed!");
            }
        }
        Logging.i(TAG, "event device changed!" + n2 + "  mAvailDevices.mDefaultRoute" + this.mAvailDevices.mDefaultRoute);
    }

    private void enableBtSco() {
        if (!this.am.isBluetoothScoAvailableOffCall()) {
            return;
        }
        if (!this.am.isBluetoothScoOn()) {
            this.am.startBluetoothSco();
            this.am.setBluetoothScoOn(true);
        }
    }

    private void disableBtSco() {
        if (!this.am.isBluetoothScoAvailableOffCall()) {
            return;
        }
        if (this.am.isBluetoothScoOn()) {
            this.am.setBluetoothScoOn(false);
            this.am.stopBluetoothSco();
        }
    }

    private void resetBtAdapter() {
        Context context = (Context)this.mContext.get();
        if (this.mBTAdapter == null) {
            return;
        }
        if (!this.hasPermission(context, "android.permission.BLUETOOTH_ADMIN")) {
            return;
        }
        this.mBTAdapter.disable();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            Logging.e(TAG, "resetBtAdapter failed:", exception);
        }
        this.mBTAdapter.enable();
        Logging.i(TAG, "resetBtAdapter Happened!");
    }

    private String modeAsString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "MODE_NORMAL";
                break;
            }
            case 1: {
                string = "MODE_RINGTONE";
                break;
            }
            case 2: {
                string = "MODE_IN_CALL";
                break;
            }
            case 3: {
                string = "MODE_IN_COMMUNICATION";
                break;
            }
            default: {
                string = "Unknown " + n2;
            }
        }
        return string;
    }

    private String btStateAsString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "SCO_CONNECTING";
                break;
            }
            case 1: {
                string = "SCO_CONNECTED";
                break;
            }
            case 2: {
                string = "SCO_DISCONNECTING";
                break;
            }
            case 3: {
                string = "SCO_DISCONNECTED";
                break;
            }
            default: {
                string = "Unknown " + n2;
            }
        }
        return string;
    }

    private void tryToConnectBtSco() {
        boolean bl = false;
        if (this.mBTHeadset == null) {
            Logging.w(TAG, "no bluetooth profile connected");
            return;
        }
        ++this.mScoConnectionAttemps;
        bl = this.isBtScoConnected();
        if (this.mScoConnectionAttemps < 5) {
            this.startTimer();
            Logging.d(TAG, "Attemp trying sco connected: " + bl + "  times:" + this.mScoConnectionAttemps + "[" + this.btStateAsString(this.mBtScoState) + "]");
            if (!bl) {
                this.disableBtSco();
                this.enableBtSco();
                if (this.mScoConnectionAttemps == 4) {
                    this.resetBtAdapter();
                }
                Logging.e(TAG, "start bluetooth sco on ? " + this.am.isBluetoothScoOn() + ",audiomode:" + this.am.getMode());
            } else {
                this.cancelTimer();
            }
        } else {
            Logging.e(TAG, "start bluetooth sco timeout, actual routing: ");
            this.cancelTimer();
            if (this.mListener.get() != null) {
                ((AudioRoutingListener)this.mListener.get()).onAudioRoutingError(1030);
            }
            if (bl) {
                Logging.e(TAG, "BT sco has already connect ");
            } else if (this.mAvailDevices.mHeadSetRoute != -1) {
                this.changeState(this.mAvailDevices.mHeadSetRoute);
            } else if (this.mAvailDevices.mForcedRoute != -1) {
                this.changeState(this.mAvailDevices.mForcedRoute);
            } else {
                this.changeState(this.mAvailDevices.mDefaultRoute);
            }
        }
    }

    private void connectBTSco() {
        Method method = null;
        Object object = null;
        try {
            method = this.mBTHeadset.getClass().getMethod("connectAudio", new Class[0]);
            object = method.invoke((Object)this.mBTHeadset, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (((Boolean)object).booleanValue()) {
            Logging.d(TAG, "SCO connected successfully ");
        } else {
            Logging.d(TAG, "SCO connected failed ");
        }
    }

    private void disConnectBTSco() {
        Method method = null;
        Object object = null;
        try {
            method = this.mBTHeadset.getClass().getMethod("disconnectAudio", new Class[0]);
            object = method.invoke((Object)this.mBTHeadset, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private boolean isBtScoConnected() {
        List list = this.mBTHeadset.getConnectedDevices();
        if (list.size() > 0) {
            BluetoothDevice bluetoothDevice = (BluetoothDevice)list.get(0);
            Method method = null;
            Object object = null;
            if (Build.VERSION.SDK_INT <= 26) {
                try {
                    method = this.mBTHeadset.getClass().getMethod("isAudioOn", new Class[0]);
                    object = method.invoke((Object)this.mBTHeadset, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
            if (this.mBTHeadset.isAudioConnected(bluetoothDevice) || object != null && ((Boolean)object).booleanValue()) {
                Logging.d(TAG, "SCO connected with " + bluetoothDevice.getName());
                return true;
            }
            Logging.d(TAG, "SCO is not connected with " + bluetoothDevice.getName());
            return false;
        }
        Logging.w(TAG, "no bluetooth device connected.");
        return false;
    }

    private int getBtDeviceList() {
        int n2 = 0;
        if (this.mBTHeadset == null) {
            return 0;
        }
        List list = this.mBTHeadset.getConnectedDevices();
        if (list != null && list.size() > 0) {
            for (BluetoothDevice bluetoothDevice : list) {
                if (bluetoothDevice == null) continue;
                Logging.i(TAG, "device name: " + bluetoothDevice.getName());
            }
            n2 = list.size();
        }
        if (n2 == 0) {
            n2 = this.mA2dpEnable ? 1 : 0;
            Logging.i(TAG, "No Connected BT hfp device, mA2dpEnable " + this.mA2dpEnable + "count " + n2);
        }
        return n2;
    }

    private String getAudioRouteDesc(int n2) {
        switch (n2) {
            case 1: {
                return "Earpiece";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 0: {
                return "Headset";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case -1: {
                return "UNSET";
            }
        }
        return "Unknown";
    }

    private String getEventDesc(int n2) {
        switch (n2) {
            case 1: {
                return "headset connect/disconnect event";
            }
            case 4: {
                return "bt hfp connect/disconnect event";
            }
            case 2: {
                return "bt a2dp connect/disconnect event";
            }
            case 3: {
                return "sco connect/disconnect event";
            }
            case 11: {
                return "set forcespeakerphone event";
            }
            case 112: {
                return "communication stream event";
            }
            case 113: {
                return "music stream event";
            }
        }
        return "unkown event";
    }

    private int setTargetRouteByPriority() {
        try {
            if (this.mAvailDevices.mBTRoute != -1 && this.isBTConnected()) {
                return 5;
            }
            if (this.mAvailDevices.mHeadSetRoute != -1 && this.isHeadSetConnected()) {
                return 0;
            }
            if (this.mAvailDevices.mForcedRoute != -1) {
                return this.mAvailDevices.mForcedRoute;
            }
            return this.mAvailDevices.mDefaultRoute;
        }
        catch (Exception exception) {
            Logging.e(TAG, "fatal error setTargetRouteByPriority", exception);
            return -1;
        }
    }

    private boolean isHeadSetConnected() {
        if (this.am == null) {
            return false;
        }
        return this.am.isWiredHeadsetOn();
    }

    private boolean isBTConnected() {
        if (this.mBTAdapter == null) {
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
        return 2 == this.mBTAdapter.getProfileConnectionState(1) || 2 == this.mBTAdapter.getProfileConnectionState(2);
    }

    private boolean isSpeakerEnable() {
        if (this.am == null) {
            return true;
        }
        return this.am.isSpeakerphoneOn();
    }

    protected boolean hasPermission(Context context, String string) {
        return context.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    public void muteAudioStream(boolean bl) {
        try {
            boolean bl2 = false;
            if (Build.VERSION.SDK_INT >= 23) {
                if (bl) {
                    this.am.adjustStreamVolume(3, -100, 0);
                } else {
                    this.am.adjustStreamVolume(3, 100, 0);
                }
            } else if (bl) {
                this.am.setStreamMute(3, true);
            } else {
                this.am.setStreamMute(3, false);
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "muteAudioStream: " + exception);
        }
    }

    private class HeadsetState
    extends AudioRouteBaseState {
        private HeadsetState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At HeadSet Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            super.headSetPlugOutProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At BT HeadSet headSetPlugOutProcess sco:" + AudioRoutingController.this.am.isBluetoothScoOn() + " a2dp:" + AudioRoutingController.this.am.isBluetoothA2dpOn());
            if (AudioRoutingController.this.getBtDeviceList() > 0) {
                AudioRoutingController.this.changeState(5);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute);
            } else {
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
            }
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            super.btPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At BT HeadSet headSetPlugOutProcess sco:" + AudioRoutingController.this.am.isBluetoothScoOn() + " a2dp:" + AudioRoutingController.this.am.isBluetoothA2dpOn());
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3) {
            super.btPlugOutProcess(n2, n3);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            super.btScoConnectProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSet btScoConnectProcess Nothing to-do");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            super.btScoDisConnectProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSet btScoDisConnectProcess Nothing to-do");
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At HeadState Process Cannot Support ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At HeadState Process Cannot Support ForceEarpiece event ");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSetState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At HeadSetState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (AudioRoutingController.this.mTargetRoute != ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute) {
                AudioRoutingController.this.mTargetRoute = ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute;
                AudioRoutingController.this.am.setSpeakerphoneOn(false);
                AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At HeadSet State switchtoTargetRoute:  " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class BTState
    extends AudioRouteBaseState {
        private BTState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process HeadSet connect event param = " + n3);
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            if (AudioRoutingController.this.mStreamType == 0) {
                AudioRoutingController.this.disableBtSco();
            }
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            super.headSetPlugOutProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At BTState Process HeadSet disconnect,Nothting need todo ");
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            super.btPlugInProcess(n2, n3);
            AudioRoutingController.this.notifyAudioRoutingChanged(5);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3) {
            super.btPlugOutProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            if (AudioRoutingController.this.getBtDeviceList() > 0) {
                AudioRoutingController.this.changeState(5);
                AudioRoutingController.this.notifyAudioRoutingChanged(5);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute != -1) {
                AudioRoutingController.this.changeState(0);
            } else if (((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute != -1) {
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute);
            } else {
                Logging.i(AudioRoutingController.TAG, "At BTState Process btPlugOutProcess default device:" + ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            super.btScoConnectProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.am.setBluetoothScoOn(true);
            Logging.i(AudioRoutingController.TAG, "At BTState Process SCO Connect,Nothing todo since already in BT State");
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process BT SCO DisConnect");
            super.btScoDisConnectProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process Cannot Support ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At BTState Process Cannot Support ForceEarpiece event ");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            AudioRoutingController.this.enableBtSco();
            AudioRoutingController.this.startTimer();
            AudioRoutingController.this.am.setMode(3);
            Logging.i(AudioRoutingController.TAG, "At BTState Process CommStream mode =" + AudioRoutingController.this.am.getMode());
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            AudioRoutingController.this.cancelTimer();
            AudioRoutingController.this.disableBtSco();
            Logging.i(AudioRoutingController.TAG, "At BTState Process MusicStream mode =" + AudioRoutingController.this.am.getMode());
        }

        @Override
        public void switchtoTargetRoute() {
            AudioRoutingController.this.am.setMode(0);
            if (5 != AudioRoutingController.this.mTargetRoute) {
                AudioRoutingController.this.mTargetRoute = 5;
                AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At BT State switchtoTargetRoute:  " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class EarpieceState
    extends AudioRouteBaseState {
        private EarpieceState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.muteAudioStream(true);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            super.btPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            AudioRoutingController.this.changeState(5);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process BT connect event");
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.forceSpkProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process ForceSpeaker event param =  " + n3);
            if (!AudioRoutingController.this.isSpeakerEnable()) {
                int n4 = AudioRoutingController.this.am.getMode();
                Logging.i(AudioRoutingController.TAG, "At EarpieceState Process audio mode =  " + n4);
                AudioRoutingController.this.am.setMode(0);
                n4 = AudioRoutingController.this.am.getMode();
                Logging.i(AudioRoutingController.TAG, "At EarpieceState Process audio mode =  " + n4);
                AudioRoutingController.this.am.setSpeakerphoneOn(true);
                AudioRoutingController.this.changeState(3);
            }
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At Earpiece Process SCO connect event,Nothing to-do");
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At EarpieceState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (1 != AudioRoutingController.this.mTargetRoute) {
                AudioRoutingController.this.mTargetRoute = 1;
                AudioRoutingController.this.am.setSpeakerphoneOn(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At Earpiece State switchtoTargetRoute: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class SpeakerState
    extends AudioRouteBaseState {
        private SpeakerState() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            super.headSetPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process HeadSet connect event param = " + n3);
            AudioRoutingController.this.changeState(0);
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.btPlugInProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process BT connect event");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            super.forceEarpieceProcess(n2, n3);
            if (AudioRoutingController.this.mPhoneInCall) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process ForceEarpiece event param =  " + n3);
            AudioRoutingController.this.changeState(1);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            if (AudioRoutingController.this.am == null) {
                return;
            }
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process SCO connect event,Nothing to-do");
            AudioRoutingController.this.changeState(5);
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            super.commStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process CommStream");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            super.musicStreamEvtProcess(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At SpeakerState Process MusicStream");
        }

        @Override
        public void switchtoTargetRoute() {
            if (AudioRoutingController.this.mTargetRoute != 3) {
                AudioRoutingController.this.mTargetRoute = 3;
                AudioRoutingController.this.am.setSpeakerphoneOn(false);
                AudioRoutingController.this.am.setSpeakerphoneOn(true);
                AudioRoutingController.this.muteAudioStream(false);
                AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.mTargetRoute);
                Logging.i(AudioRoutingController.TAG, "At Speaker State switchtoTargetRoute: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mTargetRoute) + ", Audiomode:  " + AudioRoutingController.this.am.getMode());
            }
        }
    }

    private class StopState
    extends AudioRouteBaseState {
        private StopState() {
        }

        @Override
        public void switchtoTargetRoute() {
            Logging.i(AudioRoutingController.TAG, "Coming to Stop state, switchtoTargetRoute");
            AudioRoutingController.this.cancelTimer();
            AudioRoutingController.this.disableBtSco();
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute = AudioRoutingController.this.getBtDeviceList() > 0 ? 5 : -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute = AudioRoutingController.this.isHeadSetConnected() ? 0 : -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute = -1;
            ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mForcedRoute = -1;
            AudioRoutingController.this.mTargetRoute = -1;
        }
    }

    private abstract class AudioRouteBaseState
    implements AudioRouteState {
        private AudioRouteBaseState() {
        }

        @Override
        public void switchtoTargetRoute() {
        }

        @Override
        public void headSetPlugInProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "Process HeadSet plugin event at AudioRouteBaseState mAvailDevices.mHeadSetRoute = " + AudioRoutingController.this.getAudioRouteDesc(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute));
        }

        @Override
        public void headSetPlugOutProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "Process HeadSet plugout event at AudioRouteBaseState mAvailDevices.mHeadSetRoute = " + AudioRoutingController.this.getAudioRouteDesc(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mHeadSetRoute));
        }

        @Override
        public void btPlugInProcess(int n2, int n3) {
            if (n2 == 4) {
                AudioRoutingController.this.mHfpEnable = n3 == 1;
            } else if (n2 == 2) {
                AudioRoutingController.this.mA2dpEnable = n3 == 1;
            }
            AudioRoutingController.this.notifyAudioBtProfileChanged();
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT plugin event mA2dpEnable= " + AudioRoutingController.this.mA2dpEnable);
        }

        @Override
        public void btPlugOutProcess(int n2, int n3) {
            if (AudioRoutingController.this.mBTHeadset == null) {
                return;
            }
            if (n2 == 4) {
                AudioRoutingController.this.mHfpEnable = n3 == 1;
            } else if (n2 == 2) {
                AudioRoutingController.this.mA2dpEnable = n3 == 1;
            }
            AudioRoutingController.this.notifyAudioBtProfileChanged();
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT plugout event mA2dpEnable= " + AudioRoutingController.this.mA2dpEnable);
        }

        @Override
        public void btScoConnectProcess(int n2, int n3) {
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT SCO Connect event ");
        }

        @Override
        public void btScoDisConnectProcess(int n2, int n3) {
            if (2 == AudioRoutingController.this.mBTAdapter.getProfileConnectionState(1)) {
                AudioRoutingController.this.mHfpEnable = true;
            } else {
                AudioRoutingController.this.mHfpEnable = false;
            }
            AudioRoutingController.this.notifyAudioBtProfileChanged();
            if (AudioRoutingController.this.getBtDeviceList() > 0) {
                ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute = 5;
                AudioRoutingController.this.notifyAudioRoutingChanged(5);
            } else {
                ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute = -1;
                AudioRoutingController.this.changeState(((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mDefaultRoute);
            }
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process BT SCO Disconnect, bt route: " + ((AudioRoutingController)AudioRoutingController.this).mAvailDevices.mBTRoute);
        }

        @Override
        public void forceSpkProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process ForceSpeaker event ");
        }

        @Override
        public void forceEarpieceProcess(int n2, int n3) {
            AudioRoutingController.this.changeAvailDevices(n2, n3);
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process ForceEarpiece event ");
        }

        @Override
        public void phoneChangeEvtProcess(int n2, int n3) {
            AudioRoutingController.this.mPhoneInCall = n3 > 0;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Phone state change event " + n3);
        }

        @Override
        public void commStreamEvtProcess(int n2, int n3) {
            AudioRoutingController.this.mStreamType = 0;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Communication stream event ");
        }

        @Override
        public void musicStreamEvtProcess(int n2, int n3) {
            AudioRoutingController.this.mStreamType = 3;
            Logging.i(AudioRoutingController.TAG, "At AudioRouteBaseState Process Music stream event");
        }
    }

    private static interface AudioRouteState {
        public void switchtoTargetRoute();

        public void headSetPlugInProcess(int var1, int var2);

        public void headSetPlugOutProcess(int var1, int var2);

        public void btPlugInProcess(int var1, int var2);

        public void btPlugOutProcess(int var1, int var2);

        public void btScoConnectProcess(int var1, int var2);

        public void btScoDisConnectProcess(int var1, int var2);

        public void forceSpkProcess(int var1, int var2);

        public void forceEarpieceProcess(int var1, int var2);

        public void phoneChangeEvtProcess(int var1, int var2);

        public void commStreamEvtProcess(int var1, int var2);

        public void musicStreamEvtProcess(int var1, int var2);
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            int n2 = message.what;
            int n3 = message.arg1;
            switch (n2) {
                case 11: {
                    if (n3 == 0) {
                        AudioRoutingController.this.mState.forceEarpieceProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.forceSpkProcess(n2, n3);
                    break;
                }
                case 1: {
                    if (n3 >= 0) {
                        AudioRoutingController.this.mState.headSetPlugInProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.headSetPlugOutProcess(n2, n3);
                    break;
                }
                case 3: {
                    if (n3 == 1) {
                        AudioRoutingController.this.mState.btScoConnectProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.btScoDisConnectProcess(n2, n3);
                    break;
                }
                case 2: 
                case 4: {
                    if (n3 == 1) {
                        AudioRoutingController.this.mState.btPlugInProcess(n2, n3);
                        break;
                    }
                    AudioRoutingController.this.mState.btPlugOutProcess(n2, n3);
                    break;
                }
                case 22: {
                    AudioRoutingController.this.mState.phoneChangeEvtProcess(n2, n3);
                    break;
                }
                case 112: {
                    AudioRoutingController.this.mState.commStreamEvtProcess(n2, n3);
                    break;
                }
                case 113: {
                    AudioRoutingController.this.mState.musicStreamEvtProcess(n2, n3);
                    break;
                }
                case 14: {
                    AudioRoutingController.this.mVideoDisabled = n3 > 0;
                    break;
                }
                case 12: {
                    AudioRoutingController.this.mMuteLocal = n3 > 0;
                    break;
                }
                case 13: {
                    AudioRoutingController.this.mMuteRemotes = n3 > 0;
                    break;
                }
            }
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            try {
                if (string.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                    int n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                    int n3 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                    Logging.d(AudioRoutingController.TAG, "Receive Event ACTION_CONNECTION_STATE_CHANGED prev " + n3 + ", " + n2);
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    switch (n2) {
                        case 2: {
                            List list = AudioRoutingController.this.mBTHeadset.getConnectedDevices();
                            BluetoothDevice bluetoothDevice2 = (BluetoothDevice)list.get(0);
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth device " + bluetoothDevice2.getName() + " connected");
                            AudioRoutingController.this.sendEvent(4, 1);
                            break;
                        }
                        case 0: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth device " + bluetoothDevice + " disconnected");
                            AudioRoutingController.this.sendEvent(4, 0);
                            break;
                        }
                        default: {
                            Logging.i(AudioRoutingController.TAG, "Receive hfp Event Bluetooth device " + bluetoothDevice + " unknown event, state=" + n2);
                            break;
                        }
                    }
                } else if (string.equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) {
                    int n4 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                    int n5 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                    Logging.d(AudioRoutingController.TAG, "Receive Event a2dp ACTION_CONNECTION_STATE_CHANGED prev " + n5 + ", " + n4);
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    switch (n4) {
                        case 2: {
                            AudioRoutingController.this.sendEvent(2, 1);
                            break;
                        }
                        case 0: {
                            AudioRoutingController.this.sendEvent(2, 0);
                            break;
                        }
                        default: {
                            Logging.i(AudioRoutingController.TAG, "Receive a2dp Event Bluetooth device " + bluetoothDevice + " unknown event, state=" + n4);
                            break;
                        }
                    }
                } else if (string.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                    int n6 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                    int n7 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                    Logging.d(AudioRoutingController.TAG, "Receive Event ACTION_AUDIO_STATE_CHANGED prev " + n7 + ", " + n6);
                    List list = AudioRoutingController.this.mBTHeadset.getConnectedDevices();
                    BluetoothDevice bluetoothDevice = (BluetoothDevice)list.get(0);
                    switch (n6) {
                        case 12: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth audio device " + bluetoothDevice.getName() + " connected");
                            break;
                        }
                        case 11: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth audio device " + bluetoothDevice.getName() + " connecting");
                            break;
                        }
                        case 10: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth audio device " + bluetoothDevice.getName() + " disconnected");
                            break;
                        }
                        default: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth audio device " + bluetoothDevice.getName() + " event, state=" + n6);
                            break;
                        }
                    }
                } else if (string.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    int n8 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                    int n9 = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                    Logging.d(AudioRoutingController.TAG, "Receive Event ACTION_SCO_AUDIO_STATE_UPDATED prev " + n9 + ", " + n8);
                    switch (n8) {
                        case 1: {
                            if (AudioRoutingController.this.mBTHeadset != null) {
                                Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth SCO device connected");
                                AudioRoutingController.this.mBtScoState = 1;
                                AudioRoutingController.this.sendEvent(3, 1);
                                break;
                            }
                            Logging.i(AudioRoutingController.TAG, "Receive Event SCO device connected,but BT profile not connectted Miss this event");
                            break;
                        }
                        case 2: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event SCO device connecting");
                            break;
                        }
                        case -1: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth SCO device error");
                            break;
                        }
                        case 0: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth SCO device disconnected");
                            AudioRoutingController.this.mBtScoState = 3;
                            AudioRoutingController.this.sendEvent(3, 0);
                            break;
                        }
                        default: {
                            Logging.i(AudioRoutingController.TAG, "Receive Event Bluetooth SCO device unknown event, state=" + n8);
                            break;
                        }
                    }
                } else if (string.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    int n10 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                    int n11 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                    Logging.d(AudioRoutingController.TAG, "Receive Event BluetoothAdapter.ACTION_STATE_CHANGED prev " + n11 + ", " + n10);
                    switch (n10) {
                        case 10: {
                            AudioRoutingController.this.sendEvent(4, 0);
                            AudioRoutingController.this.sendEvent(2, 0);
                            break;
                        }
                        case 12: {
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                Logging.e(AudioRoutingController.TAG, "BT broadcast receiver onReceive fail ", exception);
            }
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") && intent.hasExtra("state")) {
                int n2 = intent.getIntExtra("state", -1);
                if (n2 == 1) {
                    int n3 = intent.getIntExtra("microphone", -1);
                    if (n3 == 1) {
                        Logging.i(AudioRoutingController.TAG, "Receive Event Headset w/ mic connected");
                        AudioRoutingController.this.sendEvent(1, 0);
                    } else {
                        Logging.i(AudioRoutingController.TAG, "Receive Event Headset w/o mic connected");
                        AudioRoutingController.this.sendEvent(1, 2);
                    }
                } else if (n2 == 0) {
                    Logging.i(AudioRoutingController.TAG, "Receive Event Headset disconnected");
                    AudioRoutingController.this.sendEvent(1, -1);
                } else {
                    Logging.i(AudioRoutingController.TAG, "Receive Event Headset unknown event detected, state=" + n2);
                }
            }
        }
    }

    public static class AudioDeviceList {
        public int mForcedRoute;
        public int mDefaultRoute;
        public int mHeadSetRoute;
        public int mBTRoute;
    }
}

