/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.os.Handler;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.YuvConverter;
import java.nio.ByteBuffer;

public class VideoFrame {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;

    public VideoFrame(Buffer buffer, int n2, long l2) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (n2 % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = n2;
        this.timestampNs = l2;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRotation() {
        return this.rotation;
    }

    public long getTimestampNs() {
        return this.timestampNs;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    public void retain() {
        this.buffer.retain();
    }

    public void release() {
        this.buffer.release();
    }

    public static Buffer cropAndScaleI420(final I420Buffer i420Buffer, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n4 == n6 && n5 == n7) {
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            ByteBuffer byteBuffer2 = i420Buffer.getDataU();
            ByteBuffer byteBuffer3 = i420Buffer.getDataV();
            byteBuffer.position(n2 + n3 * i420Buffer.getStrideY());
            byteBuffer2.position(n2 / 2 + n3 / 2 * i420Buffer.getStrideU());
            byteBuffer3.position(n2 / 2 + n3 / 2 * i420Buffer.getStrideV());
            i420Buffer.retain();
            return JavaI420Buffer.wrap(i420Buffer.getWidth(), i420Buffer.getHeight(), byteBuffer.slice(), i420Buffer.getStrideY(), byteBuffer2.slice(), i420Buffer.getStrideU(), byteBuffer3.slice(), i420Buffer.getStrideV(), new Runnable(){

                @Override
                public void run() {
                    i420Buffer.release();
                }
            });
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n6, n7);
        VideoFrame.nativeCropAndScaleI420(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), n2, n3, n4, n5, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), n6, n7);
        return javaI420Buffer;
    }

    private static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);

    public static final int getAgoraFormat(TextureBuffer textureBuffer) {
        return textureBuffer.getType() == TextureBuffer.Type.OES ? 11 : 10;
    }

    public static interface TextureBuffer
    extends Buffer {
        public static final String TAG = "TEXBUF";

        public Type getType();

        public int getTextureId();

        public int getTextureType();

        public Matrix getTransformMatrix();

        public Handler getToI420Handler();

        public YuvConverter getYuvConverter();

        public EglBase.Context getEglBaseContext();

        public Object getRealEglContext();

        public int getEglType();

        public long getNativeEglContext();

        public float[] getGlTransformMatrix();

        public TextureBuffer rotate(int var1);

        public TextureBuffer flip(boolean var1);

        public boolean isNativeBufferSupported();

        public boolean isValidNativeBuffer();

        public long getNativeBuffer();

        public TextureBuffer toAGraphicBufferEx();

        public TextureBuffer toTextureBuffer();

        public int getSequence();

        public String infoString();

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int n3) {
                this.glTarget = n3;
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface I420Buffer
    extends Buffer {
        public ByteBuffer getDataY();

        public ByteBuffer getDataU();

        public ByteBuffer getDataV();

        public int getStrideY();

        public int getStrideU();

        public int getStrideV();
    }

    public static interface Buffer {
        public int getWidth();

        public int getHeight();

        public I420Buffer toI420();

        public void retain();

        public void release();

        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

