/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlTextureFrameBuffer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class TextureBufferPool {
    private static final boolean VERBOSE = false;
    private static final String TAG = TextureBufferPool.class.getSimpleName();
    private final Handler handler;
    private final boolean ownGlThread;
    private final EglBase.Context eglContext;
    private final EglBase eglBase;
    private final YuvConverter yuvConverter;
    private boolean isQuitting = false;
    private final String name;
    private GlRectDrawer drawer;
    private int bufferSlotCount;
    private int bufferSlotIndex;
    private static final AtomicInteger nextSeq = new AtomicInteger(0);
    private final PoolMode poolMode = PoolMode.POOL_MODE_DYNAMIC;
    private GlTextureFrameBuffer[] textureFrameBuffers;
    private final Map<Integer, Integer> textureIdToSlotMap = new HashMap<Integer, Integer>();
    private final ConcurrentLinkedQueue<Integer> freeSlots = new ConcurrentLinkedQueue();
    private final boolean flushPool;

    public static TextureBufferPool create(final String string, final EglBase.Context context, final int n2) {
        HandlerThread handlerThread = new HandlerThread(string);
        handlerThread.start();
        final Handler handler = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TextureBufferPool>(){

            @Override
            public TextureBufferPool call() {
                try {
                    return new TextureBufferPool(string, handler, n2, context);
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(TAG, string + " create failure", runtimeException);
                    return null;
                }
            }
        });
    }

    public static TextureBufferPool createWithinGlThread(String string, Handler handler, int n2, EglBase eglBase, YuvConverter yuvConverter, boolean bl) {
        return new TextureBufferPool(string, handler, n2, eglBase, yuvConverter, bl);
    }

    private TextureBufferPool(String string, Handler handler, int n2, EglBase.Context context) {
        this.name = string;
        this.handler = handler;
        this.ownGlThread = true;
        this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
        this.flushPool = false;
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, string + " failed to create pbufferSurface!!");
            this.eglBase.release();
            handler.getLooper().quit();
            throw runtimeException;
        }
        this.eglContext = this.eglBase.getEglBaseContext();
        this.yuvConverter = new YuvConverter();
        this.initBufferPool(n2);
    }

    private TextureBufferPool(String string, Handler handler, int n2, EglBase eglBase, YuvConverter yuvConverter, boolean bl) {
        this.name = string;
        this.handler = handler;
        this.ownGlThread = false;
        this.eglContext = eglBase.getEglBaseContext();
        this.eglBase = eglBase;
        this.yuvConverter = yuvConverter != null ? yuvConverter : new YuvConverter();
        this.flushPool = bl;
        this.initBufferPool(n2);
    }

    public VideoFrame.TextureBuffer textureCopy(VideoFrame.TextureBuffer textureBuffer, Runnable runnable) {
        if (textureBuffer == null) {
            return null;
        }
        VideoFrame.TextureBuffer textureBuffer2 = this.textureCopy(textureBuffer.getTextureId(), textureBuffer.getType(), textureBuffer.getWidth(), textureBuffer.getHeight(), textureBuffer.getTransformMatrix(), runnable);
        if (this.flushPool && textureBuffer2 == null && this.bufferSlotIndex >= this.bufferSlotCount) {
            TextureBufferImpl textureBufferImpl = new TextureBufferImpl(textureBuffer.getEglBaseContext(), textureBuffer.getWidth(), textureBuffer.getHeight(), textureBuffer.getType(), textureBuffer.getTextureId(), textureBuffer.getTransformMatrix(), textureBuffer.getToI420Handler(), textureBuffer.getYuvConverter(), runnable, nextSeq.getAndIncrement());
            return textureBufferImpl;
        }
        return textureBuffer2;
    }

    public VideoFrame.TextureBuffer textureCopy(final int n2, final VideoFrame.TextureBuffer.Type type, final int n3, final int n4, final Matrix matrix, final Runnable runnable) {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

            @Override
            public VideoFrame.TextureBuffer call() throws Exception {
                return TextureBufferPool.this.doTextureCopy(n2, type, n3, n4, matrix, runnable);
            }
        });
    }

    public void dispose() {
        Logging.i(TAG, this.name + " dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                TextureBufferPool.this.isQuitting = true;
                if (TextureBufferPool.this.poolMode == PoolMode.POOL_MODE_DYNAMIC) {
                    if (TextureBufferPool.this.bufferSlotIndex == 0) {
                        TextureBufferPool.this.release();
                    }
                } else if (TextureBufferPool.this.poolMode == PoolMode.POOL_MODE_STATIC && TextureBufferPool.this.freeSlots.size() == TextureBufferPool.this.bufferSlotCount) {
                    TextureBufferPool.this.release();
                }
            }
        });
    }

    private void initBufferPool(int n2) {
        Logging.i(TAG, this.name + " init buffer pool, ownGlThread: " + this.ownGlThread + " slots: " + n2 + " flushPool: " + this.flushPool);
        this.bufferSlotCount = Math.max(n2, 1);
        if (this.poolMode == PoolMode.POOL_MODE_DYNAMIC) {
            this.bufferSlotIndex = 0;
        } else if (this.poolMode == PoolMode.POOL_MODE_STATIC) {
            this.textureFrameBuffers = new GlTextureFrameBuffer[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.textureFrameBuffers[i2] = new GlTextureFrameBuffer(6408);
                this.textureIdToSlotMap.put(this.textureFrameBuffers[i2].getTextureId(), i2);
                this.freeSlots.offer(i2);
            }
        }
        this.drawer = new GlRectDrawer();
    }

    private VideoFrame.TextureBuffer doTextureCopy(int n2, VideoFrame.TextureBuffer.Type type, int n3, int n4, Matrix matrix, final Runnable runnable) {
        VideoFrame.TextureBuffer[] textureBufferArray;
        Integer n5;
        GlTextureFrameBuffer glTextureFrameBuffer = null;
        if (this.poolMode == PoolMode.POOL_MODE_DYNAMIC) {
            if (this.bufferSlotIndex < this.bufferSlotCount) {
                ++this.bufferSlotIndex;
                glTextureFrameBuffer = new GlTextureFrameBuffer(6408);
            }
        } else if (this.poolMode == PoolMode.POOL_MODE_STATIC && (n5 = this.freeSlots.poll()) != null) {
            glTextureFrameBuffer = this.textureFrameBuffers[n5];
        }
        if (glTextureFrameBuffer == null) {
            return null;
        }
        glTextureFrameBuffer.setSize(n3, n4);
        GLES20.glBindFramebuffer((int)36160, (int)glTextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("TextureBufferPool.glBindFramebuffer");
        GLES20.glClear((int)16384);
        switch (type) {
            case OES: {
                this.drawer.drawOes(n2, GlUtil.IDENTITY_MATRIX, n3, n4, 0, 0, n3, n4);
                break;
            }
            case RGB: {
                this.drawer.drawRgb(n2, GlUtil.IDENTITY_MATRIX, n3, n4, 0, 0, n3, n4);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
        GlUtil.checkNoGLES2Error("TextureBufferPool.copy");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFlush();
        if (this.poolMode == PoolMode.POOL_MODE_DYNAMIC) {
            glTextureFrameBuffer.releaseAllButTextures();
        }
        final int n6 = glTextureFrameBuffer.getTextureId();
        textureBufferArray = new VideoFrame.TextureBuffer[]{new TextureBufferImpl(this.eglContext, n3, n4, VideoFrame.TextureBuffer.Type.RGB, n6, matrix, this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferPool.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (TextureBufferPool.this.poolMode == PoolMode.POOL_MODE_DYNAMIC) {
                            TextureBufferPool.this.bufferSlotIndex--;
                            if (TextureBufferPool.this.bufferSlotIndex < 0) {
                                TextureBufferPool.this.bufferSlotIndex = 0;
                            } else {
                                GLES20.glDeleteTextures((int)1, (int[])new int[]{n6}, (int)0);
                            }
                            if (TextureBufferPool.this.isQuitting && TextureBufferPool.this.bufferSlotIndex == 0) {
                                TextureBufferPool.this.release();
                            }
                        } else {
                            TextureBufferPool.this.freeSlots.offer(TextureBufferPool.this.textureIdToSlotMap.get(n6));
                            if (TextureBufferPool.this.isQuitting && TextureBufferPool.this.freeSlots.size() == TextureBufferPool.this.bufferSlotCount) {
                                TextureBufferPool.this.release();
                            }
                        }
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            }
        }, nextSeq.getAndIncrement())};
        return textureBufferArray[0];
    }

    private void release() {
        Logging.i(TAG, this.name + " release()");
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.poolMode == PoolMode.POOL_MODE_DYNAMIC) {
            if (this.bufferSlotIndex != 0 || !this.isQuitting) {
                throw new IllegalStateException("Unexpected release.");
            }
        } else if (this.poolMode == PoolMode.POOL_MODE_STATIC) {
            if (this.freeSlots.size() != this.bufferSlotCount || !this.isQuitting) {
                throw new IllegalStateException("Unexpected release.");
            }
            for (int i2 = 0; i2 < this.bufferSlotCount; ++i2) {
                this.textureFrameBuffers[i2].release();
            }
        }
        this.drawer.release();
        if (this.ownGlThread) {
            if (this.eglBase != null) {
                this.eglBase.release();
            }
            this.handler.getLooper().quit();
        }
    }

    public static VideoFrame.TextureBuffer makeTextureBuffer(EglBase.Context context, int n2, int n3, int n4, int n5, float[] fArray, Handler handler, YuvConverter yuvConverter, Runnable runnable) {
        Matrix matrix = fArray == null ? new Matrix() : RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
        return new TextureBufferImpl(context, n4, n5, TextureBufferPool.agoraFrameTypeToTextureBufferType(n2), n3, matrix, handler, yuvConverter, runnable, nextSeq.getAndIncrement());
    }

    public static VideoFrame.TextureBuffer.Type agoraFrameTypeToTextureBufferType(int n2) {
        return n2 == 11 ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB;
    }

    public static void textureDump(VideoFrame.TextureBuffer textureBuffer, FileOutputStream fileOutputStream) {
        if (textureBuffer == null || fileOutputStream == null) {
            return;
        }
        VideoFrame.I420Buffer i420Buffer = textureBuffer.toI420();
        if (i420Buffer == null) {
            return;
        }
        try {
            int n2;
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            for (n2 = 0; n2 < i420Buffer.getHeight(); ++n2) {
                fileOutputStream.write(byArray, n2 * i420Buffer.getStrideY(), i420Buffer.getWidth());
            }
            byteBuffer = i420Buffer.getDataU();
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            for (n2 = 0; n2 < (i420Buffer.getHeight() + 1) / 2; ++n2) {
                fileOutputStream.write(byArray, n2 * i420Buffer.getStrideU(), i420Buffer.getWidth() / 2);
            }
            byteBuffer = i420Buffer.getDataV();
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            for (n2 = 0; n2 < (i420Buffer.getHeight() + 1) / 2; ++n2) {
                fileOutputStream.write(byArray, n2 * i420Buffer.getStrideV(), i420Buffer.getWidth() / 2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static enum PoolMode {
        POOL_MODE_DYNAMIC,
        POOL_MODE_STATIC;

    }
}

