/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Matrix;
import android.os.Build;
import android.os.Handler;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.TextureConverter;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.AGraphicBufferEx;
import java.util.concurrent.Callable;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private static final boolean VERBOSE = false;
    private final EglBase.Context eglContext;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private final int sequence;
    private int refCount;
    private AGraphicBufferEx aGraphicBufferEx;
    private TextureConverter textureConverter;
    private int oesTextureId;

    public TextureBufferImpl(EglBase.Context context, int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, Handler handler, YuvConverter yuvConverter, Runnable runnable, int n5) {
        this.eglContext = context;
        this.width = n2;
        this.height = n3;
        this.type = type;
        this.id = n4;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        this.yuvConverter = yuvConverter;
        this.releaseCallback = runnable;
        this.refCount = 1;
        this.oesTextureId = -1;
        this.sequence = n5;
    }

    public TextureBufferImpl(EglBase.Context context, int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, Handler handler, YuvConverter yuvConverter, Runnable runnable) {
        this(context, n2, n3, type, n4, matrix, handler, yuvConverter, runnable, -1);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public int getTextureType() {
        return this.type == VideoFrame.TextureBuffer.Type.OES ? 11 : 10;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    @Override
    public long getNativeEglContext() {
        return this.eglContext != null ? this.eglContext.getNativeEglContext() : 0L;
    }

    @Override
    public float[] getGlTransformMatrix() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @Override
    public Object getRealEglContext() {
        return this.eglContext.getRealEglContext();
    }

    @Override
    public int getEglType() {
        return this.eglContext.getEglType();
    }

    @Override
    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    @Override
    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isValidNativeBuffer() {
        return false;
    }

    @Override
    public long getNativeBuffer() {
        return 0L;
    }

    @Override
    public boolean isNativeBufferSupported() {
        return Build.VERSION.SDK_INT >= 26;
    }

    @Override
    public VideoFrame.TextureBuffer toTextureBuffer() {
        return this;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    public String infoString() {
        return this.toString();
    }

    @Override
    public VideoFrame.TextureBuffer toAGraphicBufferEx() {
        if (!this.isNativeBufferSupported()) {
            throw new IllegalStateException("mini api level 26 is needed, curr: " + Build.VERSION.SDK_INT);
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<VideoFrame.TextureBuffer>(){

            @Override
            public VideoFrame.TextureBuffer call() throws Exception {
                return TextureBufferImpl.this.copyToAGraphicBufferEx();
            }
        });
    }

    private AGraphicBufferEx copyToAGraphicBufferEx() {
        int n2 = 3553;
        int n3 = 1;
        if (this.getType() == VideoFrame.TextureBuffer.Type.OES) {
            n2 = 36197;
            n3 = 0;
        }
        if (this.textureConverter == null) {
            this.textureConverter = new TextureConverter(this.getTextureId(), n2, n3);
        }
        if (this.oesTextureId < 0) {
            this.oesTextureId = this.textureConverter.getOneTexture(36197);
        }
        if (this.aGraphicBufferEx == null) {
            this.aGraphicBufferEx = new AGraphicBufferEx(this.getEglBaseContext(), this.getWidth(), this.getHeight(), this.toI420Handler, this.oesTextureId, this.getTransformMatrix(), this.releaseCallback);
        }
        this.textureConverter.convert(36197, this.oesTextureId);
        return this.aGraphicBufferEx;
    }

    private void releaseAGraphicBufferEx() {
        if (this.textureConverter != null) {
            this.textureConverter.release();
            this.textureConverter = null;
        }
        if (this.aGraphicBufferEx != null) {
            this.aGraphicBufferEx.releaseNativeBuffer();
            this.aGraphicBufferEx = null;
        }
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<VideoFrame.I420Buffer>(){

            @Override
            public VideoFrame.I420Buffer call() throws Exception {
                return TextureBufferImpl.this.yuvConverter.convert(TextureBufferImpl.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseAGraphicBufferEx();
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        Matrix matrix = new Matrix();
        int n8 = this.height - (n3 + n5);
        matrix.preTranslate((float)n2 / (float)this.width, (float)n8 / (float)this.height);
        matrix.preScale((float)n4 / (float)this.width, (float)n5 / (float)this.height);
        return this.applyTransformMatrix(matrix, n6, n7);
    }

    @Override
    public VideoFrame.TextureBuffer rotate(int n2) {
        boolean bl = n2 == 90 || n2 == 270;
        int n3 = bl ? this.height : this.width;
        int n4 = bl ? this.width : this.height;
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        matrix.preRotate((float)n2);
        matrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(matrix, n3, n4);
    }

    @Override
    public VideoFrame.TextureBuffer flip(boolean bl) {
        float[] fArray = bl ? RendererCommon.verticalFlipMatrix() : RendererCommon.horizontalFlipMatrix();
        return this.applyTransformMatrix(RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray), this.width, this.height);
    }

    public VideoFrame.TextureBuffer applyTransformMatrix(Matrix matrix, int n2, int n3) {
        Matrix matrix2 = new Matrix(this.transformMatrix);
        matrix2.preConcat(matrix);
        this.retain();
        return new TextureBufferImpl(this.eglContext, n2, n3, this.type, this.id, matrix2, this.toI420Handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        }, this.sequence);
    }

    public String toString() {
        return "TextureBufferImpl{eglContext=" + this.eglContext + ", " + this.width + "x" + this.height + ", type=" + (Object)((Object)this.type) + ", seq=" + this.sequence + ", id=" + this.id + ", refCount=" + this.refCount + '}';
    }
}

