/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.audio.ReflectUtils;
import io.agora.rtc.internal.Logging;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class HuaweiHardwareEarback
implements IHardwareEarback {
    private static final String TAG = "HuaweiHardwareEarback";
    private Context mContext = null;
    private Object mHwAudioKit = null;
    private Object mHwAudioKaraokeFeatureKit = null;
    private boolean mInited = false;
    private boolean mEarbackEnabled = false;
    private int latency = 0;
    private int volume = 0;
    Class clsHwAudioKit = null;
    Class clsAudioKitCallback = null;
    Class clsHwAudioKaraokeFeatureKit = null;
    private boolean mClsInited = false;

    public HuaweiHardwareEarback(Context context) {
        Logging.d(TAG, ">>ctor");
        this.mContext = context;
        this.initialize();
    }

    public static boolean hasHwAudioKitClass() {
        Class clazz = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
        Class clazz2 = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback");
        Class clazz3 = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit");
        return clazz2 != null && clazz != null && clazz3 != null;
    }

    @Override
    public void initialize() {
        GenericDeclaration genericDeclaration;
        if (this.mContext == null) {
            Logging.e(TAG, "mContext is null!");
            return;
        }
        Logging.d(TAG, ">>initialize");
        this.clsHwAudioKit = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
        this.clsAudioKitCallback = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback");
        this.clsHwAudioKaraokeFeatureKit = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit");
        if (this.clsAudioKitCallback == null || this.clsHwAudioKit == null || this.clsHwAudioKaraokeFeatureKit == null) {
            return;
        }
        Object object = Proxy.newProxyInstance(this.clsAudioKitCallback.getClassLoader(), new Class[]{this.clsAudioKitCallback}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (method.getName().equals("onResult")) {
                    int n2 = (Integer)objectArray[0];
                    switch (n2) {
                        case 0: {
                            Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: HwAudioKit init success");
                            break;
                        }
                        case 1000: {
                            HuaweiHardwareEarback.this.mInited = true;
                            Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: HwAudioKaraokeFeatureKit init success ");
                            break;
                        }
                        case 2: {
                            Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: audio kit not installed");
                            break;
                        }
                        default: {
                            Logging.e(HuaweiHardwareEarback.TAG, "IAudioKitCallback: onResult error number " + n2);
                        }
                    }
                }
                return null;
            }
        });
        Constructor constructor = null;
        try {
            constructor = this.clsHwAudioKit.getConstructor(Context.class, this.clsAudioKitCallback);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        if (constructor == null) {
            Logging.e(TAG, "find HwAudioKit constructor failed");
            return;
        }
        try {
            this.mHwAudioKit = constructor.newInstance(this.mContext, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.mHwAudioKit == null) {
            Logging.e(TAG, "create HwAudioKit failed");
            return;
        }
        try {
            genericDeclaration = this.clsHwAudioKit.getMethod("initialize", new Class[0]);
            if (genericDeclaration != null) {
                ((Method)genericDeclaration).invoke(this.mHwAudioKit, new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            Logging.e(TAG, "create HwAudioKit initialize failed");
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            Logging.e(TAG, "create HwAudioKit initialize failed");
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Logging.e(TAG, "create HwAudioKit initialize failed");
            return;
        }
        genericDeclaration = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKit$FeatureType");
        if (genericDeclaration == null) {
            Logging.e(TAG, "cannot find class  HwAudioKit$FeatureType initialize failed");
            return;
        }
        Object var4_9 = null;
        if (((Class)genericDeclaration).isEnum()) {
            var4_9 = ((Class)genericDeclaration).getEnumConstants()[0];
        }
        if (var4_9 == null) {
            Logging.e(TAG, "cannot find class  HwAudioKit$FeatureType initialize failed");
            return;
        }
        Method method = null;
        try {
            method = this.clsHwAudioKit.getMethod("createFeature", new Class[]{genericDeclaration});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        if (method == null) {
            Logging.e(TAG, "cannot find method createFeature ");
            return;
        }
        try {
            this.mHwAudioKaraokeFeatureKit = method.invoke(this.mHwAudioKit, var4_9);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (this.mHwAudioKaraokeFeatureKit == null) {
            Logging.e(TAG, " createFeature failed");
            return;
        }
        this.mClsInited = true;
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        if (!this.mInited || !this.mClsInited) {
            return false;
        }
        Logging.d(TAG, ">>isHardwareEarbackSupported");
        boolean bl = false;
        try {
            bl = (Boolean)ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "isKaraokeFeatureSupport", new Class[0], new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Logging.d(TAG, "isSupported " + bl);
        return bl;
    }

    @Override
    public synchronized int setHardwareEarbackVolume(int n2) {
        if (!this.mInited || !this.mClsInited) {
            return -7;
        }
        Logging.d(TAG, ">>setHardwareEarbackVolume " + n2);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 100) {
            n2 = 100;
        }
        int n3 = -1;
        Class clazz = ReflectUtils.safeFindClass("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit$ParameName");
        if (clazz == null) {
            Logging.e(TAG, "cannot find method  ParameName.getParameName");
            return -1;
        }
        Method method = ReflectUtils.safeGetMethod(clazz, "getParameName", new Class[0]);
        if (method == null) {
            Logging.e(TAG, "cannot find method  ParameName.getParameName");
            return -1;
        }
        Object var5_5 = null;
        try {
            for (Object t : clazz.getEnumConstants()) {
                Object object = null;
                object = method.invoke(t, new Object[0]);
                if (object == null || !((String)object).equals("Karaoke_volume=")) continue;
                var5_5 = t;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (var5_5 == null) {
            Logging.e(TAG, "cannot find object  ParameName.CMD_SET_VOCAL_VOLUME_BASE");
            return -1;
        }
        try {
            n3 = (Integer)ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "setParameter", new Class[]{clazz, Integer.TYPE}, new Object[]{var5_5, n2});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n3 != 0) {
            Logging.e(TAG, "setParameter error number " + n3);
            return -1;
        }
        this.volume = n2;
        return 0;
    }

    @Override
    public synchronized int enableEarbackFeature(boolean bl) {
        if (!this.mInited || !this.mClsInited) {
            return -7;
        }
        Logging.d(TAG, ">>enableEarbackFeature " + bl);
        Object object = ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "isKaraokeFeatureSupport", new Class[0], new Object[0]);
        if (object == null || !object.getClass().equals(Boolean.class)) {
            return -1;
        }
        if (!((Boolean)object).booleanValue()) {
            Logging.e(TAG, "karaoke not supported");
            return -1;
        }
        Object object2 = ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "enableKaraokeFeature", new Class[]{Boolean.TYPE}, new Object[]{bl});
        if (object2 == null || !object2.getClass().equals(Integer.class)) {
            return -1;
        }
        int n2 = (Integer)object2;
        if (n2 != 0) {
            Logging.e(TAG, "enableKaraokeFeature failed ret " + n2);
            return -1;
        }
        this.mEarbackEnabled = bl;
        if (this.mEarbackEnabled) {
            Object object3 = ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "getKaraokeLatency", new Class[0], new Object[0]);
            if (object3 == null || !object3.getClass().equals(Integer.class)) {
                this.latency = (Integer)object3;
            }
            Logging.i(TAG, "latency " + this.latency);
        }
        return 0;
    }

    @Override
    public void destroy() {
        Logging.d(TAG, ">>destroy");
        if (this.mHwAudioKaraokeFeatureKit != null) {
            ReflectUtils.safeCallMethod(this.clsHwAudioKaraokeFeatureKit, this.mHwAudioKaraokeFeatureKit, "destroy", new Class[0], new Object[0]);
        }
        if (this.mHwAudioKit != null) {
            ReflectUtils.safeCallMethod(this.clsHwAudioKit, this.mHwAudioKit, "destroy", new Class[0], new Object[0]);
        }
    }

    protected void finalize() throws Throwable {
        Logging.d(TAG, ">>finalize");
        this.destroy();
        super.finalize();
    }
}

