/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import io.agora.rtc.internal.AudioRoutingListener;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private static final int UNINIT = 0;
    private static final int START = 1;
    private static final int STOP = 2;
    private static final int ERROR = 4;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    private WeakReference<Context> mContext;
    private EventHandler mEventHandler;
    private WeakReference<AudioRoutingListener> mListener;
    private ControllerState mState;
    private boolean mIsWiredHeadsetPlugged = false;
    private int mHeadsetType = -1;
    private boolean mIsBTHeadsetPlugged = false;
    private int mForceSpeakerphone = -1;
    private int mCurrentRouting = -1;
    private int mDefaultRouting = -1;
    private int mOriginRouting = -1;
    private int mChannelProfile = 1;
    private boolean mVideoDisabled = true;
    private boolean mMuteLocal = false;
    private boolean mMuteRemotes = false;
    private int mEngineRole = -1;
    private boolean mPhoneInCall = false;
    private int mSpeakerCommVolume = -1;
    private boolean mBTHeadSetProperlySeted = false;
    private static final int BT_SCO_STATE_CONNECTING = 0;
    private static final int BT_SCO_STATE_CONNECTED = 1;
    private static final int BT_SCO_STATE_DISCONNECTING = 2;
    private static final int BT_SCO_STATE_DISCONNECTED = 3;
    private int mBtScoState = 3;
    private boolean mIsBTScoStarted = false;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 5;
    private int dynamic_timeout = 4000;
    private int mScoConnectionAttemps;
    private int mLastNotifiedRouting = -1;
    private ControllerStopState mStopState = null;
    private ControllerStartState mStartState = null;
    private ControllerErrorState mErrorState = null;
    private int mNotifiedRouting = -1;
    private boolean mUsingCommParameters = false;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            AudioRoutingController.this.bluetoothTimeout();
        }
    };
    private HeadsetBroadcastReceiver mHeadsetReceiver;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET = 2;
    private static final int EVT_BT_SCO = 3;
    public static final int CMD_SET_DEFAULT_ROUTING = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_MUTE_VIDEO_LOCAL = 12;
    public static final int CMD_MUTE_VIDEO_REMOTES = 13;
    public static final int CMD_MUTE_VIDEO_ALL = 14;
    public static final int CMD_START_BT_SCO = 15;
    public static final int CMD_FORCE_BT_SCO_OFF = 16;
    public static final int EVT_CHANNEL_PROFILE = 20;
    public static final int EVT_ENGINE_ROLE_CHANGED = 21;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    public static final int EVT_USING_COMM_PARAMETERS = 112;
    public static final int EVT_USING_NORM_PARAMETERS = 113;

    private void startTimer() {
        this.dynamic_timeout += 4000 * this.mScoConnectionAttemps;
        Logging.d(TAG, "start bluetooth timer " + this.dynamic_timeout);
        this.mEventHandler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private void cancelTimer() {
        Logging.d(TAG, "cancel bluetooth timer");
        this.mEventHandler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private ControllerState changeState(int n2) {
        if (n2 == 2) {
            if (this.mStopState == null) {
                this.mStopState = new ControllerStopState();
            }
            if (this.mStopState != null) {
                this.mStopState.reset();
            }
            return this.mStopState;
        }
        if (n2 == 1) {
            if (this.mStartState == null) {
                this.mStartState = new ControllerStartState();
            }
            if (this.mStartState != null) {
                this.mStartState.reset();
            }
            return this.mStartState;
        }
        if (this.mErrorState == null) {
            this.mErrorState = new ControllerErrorState();
        }
        if (this.mErrorState != null) {
            this.mErrorState.reset();
        }
        return this.mErrorState;
    }

    public AudioRoutingController(Context context, AudioRoutingListener audioRoutingListener) {
        this.mContext = new WeakReference<Context>(context);
        this.mListener = new WeakReference<AudioRoutingListener>(audioRoutingListener);
    }

    public int initialize() {
        Logging.i(TAG, "initialize +");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            Logging.e(TAG, "context has been GCed");
            return -1;
        }
        AudioManager audioManager = this.getAudioManager();
        if (audioManager == null) {
            Logging.e(TAG, "invalid context: can't get AudioManager");
            return -1;
        }
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null);
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        this.mIsWiredHeadsetPlugged = audioManager.isWiredHeadsetOn();
        this.mState = this.changeState(2);
        Logging.i(TAG, "Headset setup: Plugged = " + this.mIsWiredHeadsetPlugged);
        if (!this.mHeadsetReceiver.getRegistered()) {
            context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            this.mHeadsetReceiver.setRegistered(true);
        }
        if (Build.VERSION.SDK_INT < 11 && 0 != context.checkPermission("android.permission.BLUETOOTH", Process.myPid(), Process.myUid())) {
            Logging.w(TAG, "do not support BT monitoring on this device");
            return 0;
        }
        if (this.mBTHeadsetListener != null) {
            Logging.w(TAG, "Bluetooth service Listener already been initialized");
        } else {
            try {
                this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                    public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
                        Logging.i(AudioRoutingController.TAG, "onServiceConnected " + n2 + " =? headset(" + 1 + ")");
                        if (n2 == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service connected: " + n2 + " " + bluetoothProfile);
                            AudioRoutingController.this.mBTHeadset = (BluetoothHeadset)bluetoothProfile;
                        }
                    }

                    public void onServiceDisconnected(int n2) {
                        Logging.i(AudioRoutingController.TAG, "onServiceDisconnected " + n2 + " =? headset(" + 1 + ")");
                        if (n2 == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service disconnected: " + n2);
                            AudioRoutingController.this.cancelTimer();
                            AudioRoutingController.this.mBTHeadset = null;
                        }
                    }
                };
            }
            catch (Exception exception) {
                Logging.e(TAG, "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + exception.getMessage());
            }
        }
        if (!this.hasPermission(context, "android.permission.BLUETOOTH")) {
            Logging.w(TAG, "lacks BLUETOOTH permission");
            return 0;
        }
        try {
            if (this.mBTHeadsetReceiver == null) {
                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
            }
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBTAdapter == null || this.mBTHeadsetListener == null) {
                Logging.e(TAG, "initialize: failed to get bluetooth adapter!!");
                return 0;
            }
            this.mBTAdapter.getProfileProxy(context.getApplicationContext(), this.mBTHeadsetListener, 1);
            if (2 == this.mBTAdapter.getProfileConnectionState(1)) {
                this.mIsBTHeadsetPlugged = true;
            }
            Logging.i(TAG, "BT headset setup: BTHeadsetPlugged = " + this.mIsBTHeadsetPlugged + " " + this.mBTHeadset);
            IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            intentFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            if (!this.mBTHeadsetReceiver.getRegistered()) {
                Intent intent = context.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, intentFilter);
                this.mBTHeadsetReceiver.setRegistered(true);
                if (intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    int n2 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                    switch (n2) {
                        case 1: {
                            Logging.i(TAG, "initial Bluetooth SCO device connected");
                            this.mBtScoState = 1;
                            break;
                        }
                        default: {
                            Logging.i(TAG, "initial Bluetooth SCO device unconnected");
                            this.mBtScoState = 3;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "unable to create BluetoothHeadsetBroadcastReceiver, err:" + exception.getMessage());
        }
        Logging.i(TAG, "initialize -");
        return 0;
    }

    private void clearBTResource() {
        if (this.mBTAdapter != null) {
            int n2 = this.mBTAdapter.getProfileConnectionState(1);
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            if (n2 != 2) {
                this.cancelTimer();
                this.mBTHeadset = null;
            }
            this.mBTAdapter = null;
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    public void uninitialize() {
        Logging.d(TAG, "uninitialize");
        try {
            this.clearBTResource();
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            this.mHeadsetReceiver = null;
            this.mBTHeadsetReceiver = null;
        }
        catch (Exception exception) {
            Logging.e(TAG, "AudioRoutingController uninitialize fail: ", exception);
        }
    }

    public void startMonitoring(int n2, int n3) {
        if (1 == this.mState.getState()) {
            Logging.i(TAG, "state not changed!");
            return;
        }
        this.mDefaultRouting = n2;
        this.mChannelProfile = n3;
        this.mOriginRouting = n2;
        this.mState.setState(1);
    }

    public void stopMonitoring() {
        this.mState.setState(2);
    }

    public void sendEvent(int n2, int n3) {
        Logging.d(TAG, "sendEvent: [" + n2 + "], extra arg: " + n3 + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message message = this.mEventHandler.obtainMessage(n2, n3, 0);
            this.mEventHandler.sendMessage(message);
        }
    }

    public void clearListenerNativeHandle() {
        Logging.d(TAG, "clearListenerNativeHandle");
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            audioRoutingListener.onAudioRoutingDestroyed();
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private boolean isAudioOnly() {
        return this.mVideoDisabled || this.mMuteLocal && this.mMuteRemotes;
    }

    private AudioManager getAudioManager() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int n2) {
        AudioRoutingListener audioRoutingListener = (AudioRoutingListener)this.mListener.get();
        if (audioRoutingListener != null) {
            if (this.mLastNotifiedRouting != n2) {
                audioRoutingListener.onAudioRoutingChanged(n2);
                this.mLastNotifiedRouting = n2;
            }
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private int doSetAudioOutputRouting(int n2) {
        Logging.i(TAG, "set audio output routing from " + this.getAudioRouteDesc(this.mCurrentRouting) + " to " + this.getAudioRouteDesc(n2));
        try {
            AudioManager audioManager = this.getAudioManager();
            if (n2 != 5) {
                audioManager.setSpeakerphoneOn(false);
                audioManager.setSpeakerphoneOn(n2 == 3);
            }
            if (this.queryCurrentAudioRouting() != n2) {
                int n3 = this.queryCurrentAudioRouting();
                Logging.i(TAG, "different audio routing from target " + n2 + ", actual routing: " + n3 + "[" + this.getAudioRouteDesc(n3) + "]");
            }
            this.updateBluetoothSco(n2);
            this.mCurrentRouting = n2;
            this.mNotifiedRouting = n2;
            this.notifyAudioRoutingChanged(n2);
            Logging.i(TAG, "audio routing changed to " + this.getAudioRouteDesc(this.mCurrentRouting));
        }
        catch (Exception exception) {
            Logging.e(TAG, "set audio output routing failed:", exception);
        }
        return 0;
    }

    private int updateBluetoothSco(int n2) {
        Logging.d(TAG, "updateBluetoothSco sco started: " + this.mIsBTScoStarted + ", audio route target: " + n2 + "[" + this.getAudioRouteDesc(n2) + "] current: " + this.mCurrentRouting + "[" + this.getAudioRouteDesc(this.mCurrentRouting) + "], engine role: " + this.mEngineRole + "mUsing  " + this.mUsingCommParameters + " mBTHeadSetProperlySeted " + this.mBTHeadSetProperlySeted);
        this.mBTHeadSetProperlySeted = n2 != 5;
        this.mNotifiedRouting = n2;
        this.notifyAudioRoutingChanged(n2);
        return 0;
    }

    private void startBtSco() {
        AudioManager audioManager = this.getAudioManager();
        int n2 = audioManager.getMode();
        Logging.i(TAG, "try to opening bt sco " + this.mScoConnectionAttemps + " " + n2 + "[" + this.modeAsString(n2) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + audioManager.isBluetoothScoOn());
        Logging.d(TAG, "Off call sco support = " + audioManager.isBluetoothScoAvailableOffCall());
        this.mBtScoState = 0;
        ++this.mScoConnectionAttemps;
        this.doStartBTSco(audioManager);
    }

    private String modeAsString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "MODE_NORMAL";
                break;
            }
            case 1: {
                string = "MODE_RINGTONE";
                break;
            }
            case 2: {
                string = "MODE_IN_CALL";
                break;
            }
            case 3: {
                string = "MODE_IN_COMMUNICATION";
                break;
            }
            default: {
                string = "Unknown " + n2;
            }
        }
        return string;
    }

    private String btStateAsString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "SCO_CONNECTING";
                break;
            }
            case 1: {
                string = "SCO_CONNECTED";
                break;
            }
            case 2: {
                string = "SCO_DISCONNECTING";
                break;
            }
            case 3: {
                string = "SCO_DISCONNECTED";
                break;
            }
            default: {
                string = "Unknown " + n2;
            }
        }
        return string;
    }

    private void doStartBTSco(AudioManager audioManager) {
        try {
            int n2 = audioManager.getMode();
            Logging.i(TAG, "doStartBTSco " + Build.VERSION.SDK_INT + " sco on: " + audioManager.isBluetoothScoOn() + " " + n2 + "[" + this.modeAsString(n2) + "]");
            if (Build.VERSION.SDK_INT < 22) {
                audioManager.setStreamMute(0, true);
            }
            audioManager.setBluetoothScoOn(false);
            audioManager.stopBluetoothSco();
            audioManager.startBluetoothSco();
            audioManager.setBluetoothScoOn(true);
            if (this.mBTHeadset != null) {
                Method method = null;
                Object object = null;
                try {
                    method = this.mBTHeadset.getClass().getMethod("connectAudio", new Class[0]);
                    object = method.invoke((Object)this.mBTHeadset, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            Logging.e(TAG, "doStartBTSco fail ", exception);
        }
        Logging.d(TAG, "doStartBTSco done sco on: " + audioManager.isBluetoothScoOn() + " " + audioManager.getMode() + "[" + this.modeAsString(audioManager.getMode()) + "]");
    }

    private void doStopBTSco(AudioManager audioManager) {
        Logging.i(TAG, "doStopBTSco " + Build.VERSION.SDK_INT + " sco on: " + audioManager.isBluetoothScoOn());
        audioManager.setBluetoothScoOn(false);
        audioManager.stopBluetoothSco();
        if (this.mBTHeadset != null) {
            Method method = null;
            Object object = null;
            try {
                method = this.mBTHeadset.getClass().getMethod("disconnectAudio", new Class[0]);
                object = method.invoke((Object)this.mBTHeadset, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if (Build.VERSION.SDK_INT < 22) {
            // empty if block
        }
    }

    private void stopBtSco() {
        AudioManager audioManager = this.getAudioManager();
        int n2 = audioManager.getMode();
        Logging.i(TAG, "try to stopping bt sco " + n2 + "[" + this.modeAsString(n2) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + audioManager.isBluetoothScoOn());
        this.mBtScoState = !audioManager.isBluetoothScoOn() ? 3 : 2;
        this.doStopBTSco(audioManager);
    }

    private void checkBtScoState(boolean bl) {
        this.mScoConnectionAttemps = 0;
    }

    private void bluetoothTimeout() {
        AudioManager audioManager = this.getAudioManager();
        boolean bl = false;
        if (this.mBTHeadset == null) {
            Logging.w(TAG, "no bluetooth profile connected");
            return;
        }
        List list = this.mBTHeadset.getConnectedDevices();
        if (list.size() > 0) {
            BluetoothDevice bluetoothDevice = (BluetoothDevice)list.get(0);
            Method method = null;
            Object object = null;
            if (Build.VERSION.SDK_INT <= 26) {
                try {
                    method = this.mBTHeadset.getClass().getMethod("isAudioOn", new Class[0]);
                    object = method.invoke((Object)this.mBTHeadset, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
            if (this.mBTHeadset.isAudioConnected(bluetoothDevice) || object != null && ((Boolean)object).booleanValue()) {
                Logging.d(TAG, "SCO connected with " + bluetoothDevice.getName());
                bl = true;
            } else {
                Logging.d(TAG, "SCO is not connected with " + bluetoothDevice.getName());
            }
        } else {
            Logging.w(TAG, "no bluetooth device connected.");
        }
        if (this.mScoConnectionAttemps < 5) {
            Logging.d(TAG, "attemps trying, bt sco started: " + this.mIsBTScoStarted + " sco connected: " + bl + " " + this.mScoConnectionAttemps + " times " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "]");
            if (this.mIsBTScoStarted && !bl) {
                this.startTimer();
                ++this.mScoConnectionAttemps;
                this.stopBtSco();
                audioManager.stopBluetoothSco();
                this.doStartBTSco(audioManager);
            }
        } else {
            Logging.e(TAG, "start bluetooth sco timeout, actual routing: " + this.queryCurrentAudioRouting());
            this.mScoConnectionAttemps = 0;
            if (this.mListener.get() != null) {
                ((AudioRoutingListener)this.mListener.get()).onAudioRoutingError(1030);
            }
            this.resetAudioRouting();
        }
    }

    private void resetAudioRouting() {
        Logging.i(TAG, "default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + " bluetooth " + this.mIsBTHeadsetPlugged + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", actual system routing: " + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
        if (this.mForceSpeakerphone == 1) {
            int n2 = 3;
            Logging.i(TAG, "reset(force) audio routing, default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", target routing: " + this.getAudioRouteDesc(n2) + ", actual system routing:" + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
            if (this.mCurrentRouting != 3 || this.queryCurrentAudioRouting() != 3) {
                this.doSetAudioOutputRouting(n2);
            }
        } else {
            int n3;
            int n4 = this.queryCurrentAudioRouting();
            if (n4 == 0 || n4 == 2) {
                this.mIsWiredHeadsetPlugged = true;
            }
            if (this.mIsBTHeadsetPlugged) {
                n3 = 5;
            } else if (this.mIsWiredHeadsetPlugged) {
                n3 = this.mHeadsetType;
            } else {
                n3 = this.mOriginRouting;
                Logging.i(TAG, "reset audio routing, OriginRouting routing: " + this.getAudioRouteDesc(this.mOriginRouting));
            }
            Logging.i(TAG, "reset audio routing, default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", target routing: " + this.getAudioRouteDesc(n3) + ", actual system routing: " + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
            if (this.mCurrentRouting != n3 || this.queryCurrentAudioRouting() != this.mCurrentRouting) {
                this.doSetAudioOutputRouting(n3);
            }
        }
    }

    private String getAudioRouteDesc(int n2) {
        switch (n2) {
            case 1: {
                return "Earpiece";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 0: {
                return "Headset";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case -1: {
                return "Default";
            }
        }
        return "Unknown";
    }

    private int queryCurrentAudioRouting() {
        AudioManager audioManager = this.getAudioManager();
        if (this.mBTAdapter == null) {
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        try {
            if (audioManager.isSpeakerphoneOn()) {
                return 3;
            }
            if ((audioManager.isBluetoothScoOn() || audioManager.isBluetoothA2dpOn()) && this.mBTAdapter.isEnabled()) {
                return 5;
            }
            if (audioManager.isWiredHeadsetOn()) {
                return 0;
            }
            return 1;
        }
        catch (Exception exception) {
            Logging.e(TAG, "fatal error @queryCurrentAudioRouting", exception);
            return -1;
        }
    }

    protected boolean hasPermission(Context context, String string) {
        return context.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    private class ControllerErrorState
    extends ControllerBaseState {
        private ControllerErrorState() {
        }

        @Override
        public int getState() {
            return 4;
        }
    }

    private class ControllerStartState
    extends ControllerBaseState {
        public ControllerStartState() {
            if (AudioRoutingController.this.mDefaultRouting == -1) {
                if (AudioRoutingController.this.mChannelProfile == 0 && AudioRoutingController.this.isAudioOnly()) {
                    AudioRoutingController.this.mDefaultRouting = 1;
                } else {
                    AudioRoutingController.this.mDefaultRouting = 3;
                }
            }
            AudioRoutingController.this.resetAudioRouting();
            Logging.i(AudioRoutingController.TAG, "Monitor start: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        @Override
        public void reset() {
            if (AudioRoutingController.this.mDefaultRouting == -1) {
                if (AudioRoutingController.this.mChannelProfile == 0 && AudioRoutingController.this.isAudioOnly()) {
                    AudioRoutingController.this.mDefaultRouting = 1;
                } else {
                    AudioRoutingController.this.mDefaultRouting = 3;
                }
            }
            AudioRoutingController.this.mOriginRouting = AudioRoutingController.this.mDefaultRouting;
            AudioRoutingController.this.resetAudioRouting();
            Logging.i(AudioRoutingController.TAG, "Monitor reset: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        @Override
        public int getState() {
            return 1;
        }

        @Override
        public void onEvent(int n2, int n3) {
            Logging.d(AudioRoutingController.TAG, "StartState: onEvent: " + n2 + ", info: " + n3);
            AudioManager audioManager = AudioRoutingController.this.getAudioManager();
            switch (n2) {
                case 1: {
                    AudioRoutingController.this.mHeadsetType = n3;
                    AudioRoutingController.this.mIsWiredHeadsetPlugged = n3 >= 0;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (AudioRoutingController.this.mIsWiredHeadsetPlugged && AudioRoutingController.this.mCurrentRouting != n3) {
                        if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                            AudioRoutingController.this.cancelTimer();
                            AudioRoutingController.this.stopBtSco();
                        }
                        AudioRoutingController.this.doSetAudioOutputRouting(n3);
                        break;
                    }
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.notifyAudioRoutingChanged(5);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 11: {
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged || AudioRoutingController.this.mIsWiredHeadsetPlugged) break;
                    if (!AudioRoutingController.this.mPhoneInCall) {
                        if (n3 == 1) {
                            AudioRoutingController.this.doSetAudioOutputRouting(3);
                        } else if (n3 == 0) {
                            AudioRoutingController.this.doSetAudioOutputRouting(1);
                        } else {
                            AudioRoutingController.this.resetAudioRouting();
                        }
                    }
                    AudioRoutingController.this.mOriginRouting = AudioRoutingController.this.mCurrentRouting;
                    break;
                }
                case 16: {
                    AudioManager audioManager2 = AudioRoutingController.this.getAudioManager();
                    if (n3 == 0) {
                        if (!audioManager2.isBluetoothScoOn()) break;
                        AudioRoutingController.this.doStopBTSco(audioManager2);
                        break;
                    }
                    if (!audioManager2.isBluetoothA2dpOn()) break;
                    AudioRoutingController.this.doStartBTSco(audioManager2);
                    break;
                }
                case 21: {
                    AudioRoutingController.this.mEngineRole = n3;
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    AudioRoutingController.this.updateBluetoothSco(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                case 2: {
                    if (n3 != 0 || !AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        // empty if block
                    }
                    AudioRoutingController.this.mBTHeadSetProperlySeted = false;
                    AudioRoutingController.this.mIsBTHeadsetPlugged = n3 == 1;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    Logging.d(AudioRoutingController.TAG, "BT HEADSET EVENT  " + n3 + " mIsBTHeadsetPlugged " + AudioRoutingController.this.mIsBTHeadsetPlugged);
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.doSetAudioOutputRouting(5);
                        break;
                    }
                    if (AudioRoutingController.this.mForceSpeakerphone == 1) {
                        AudioRoutingController.this.doSetAudioOutputRouting(3);
                        break;
                    }
                    if (AudioRoutingController.this.mForceSpeakerphone == 0) {
                        if (AudioRoutingController.this.mIsWiredHeadsetPlugged) {
                            AudioRoutingController.this.doSetAudioOutputRouting(0);
                            break;
                        }
                        AudioRoutingController.this.doSetAudioOutputRouting(1);
                        break;
                    }
                    if (AudioRoutingController.this.mIsWiredHeadsetPlugged) {
                        AudioRoutingController.this.doSetAudioOutputRouting(0);
                        break;
                    }
                    AudioRoutingController.this.doSetAudioOutputRouting(AudioRoutingController.this.mOriginRouting);
                    break;
                }
                case 3: {
                    AudioRoutingController.this.mBtScoState = n3 == 1 ? 1 : 2;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    AudioRoutingController.this.checkBtScoState(n3 == 1);
                    if (n3 != 0) break;
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 22: {
                    Logging.i(AudioRoutingController.TAG, "phone state changed: " + n3);
                    AudioRoutingController.this.mPhoneInCall = n3 > 0;
                    if (n3 == 0) {
                        AudioRoutingController.this.resetAudioRouting();
                        break;
                    }
                    AudioRoutingController.this.mCurrentRouting = -1;
                    break;
                }
                case 112: {
                    if (AudioRoutingController.this.mUsingCommParameters && AudioRoutingController.this.mBTHeadSetProperlySeted) break;
                    AudioRoutingController.this.mUsingCommParameters = true;
                    Logging.d(AudioRoutingController.TAG, "BT HEADSET EVENT  " + n3 + " mIsBTHeadsetPlugged " + AudioRoutingController.this.mIsBTHeadsetPlugged);
                    AudioRoutingController.this.mBTHeadSetProperlySeted = true;
                    if (AudioRoutingController.this.mNotifiedRouting != 5) break;
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.startTimer();
                        AudioRoutingController.this.mIsBTScoStarted = true;
                        AudioRoutingController.this.doStartBTSco(audioManager);
                        break;
                    }
                    AudioRoutingController.this.mIsBTScoStarted = false;
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 113: {
                    if (AudioRoutingController.this.mUsingCommParameters || AudioRoutingController.this.mBTHeadSetProperlySeted) {
                        // empty if block
                    }
                    AudioRoutingController.this.mBTHeadSetProperlySeted = true;
                    AudioRoutingController.this.mUsingCommParameters = false;
                    if (!audioManager.isBluetoothScoOn()) break;
                    AudioRoutingController.this.cancelTimer();
                    AudioRoutingController.this.doStopBTSco(audioManager);
                    break;
                }
                default: {
                    super.onEvent(n2, n3);
                }
            }
        }
    }

    private class ControllerStopState
    extends ControllerBaseState {
        public ControllerStopState() {
            AudioRoutingController.this.cancelTimer();
            if (AudioRoutingController.this.mIsBTScoStarted) {
                AudioRoutingController.this.mIsBTScoStarted = false;
                AudioRoutingController.this.stopBtSco();
            }
            AudioRoutingController.this.mForceSpeakerphone = -1;
            AudioRoutingController.this.mCurrentRouting = -1;
            AudioRoutingController.this.mDefaultRouting = -1;
            AudioRoutingController.this.mScoConnectionAttemps = 0;
            Logging.i(AudioRoutingController.TAG, "Monitor stopped");
        }

        @Override
        public int getState() {
            return 2;
        }

        @Override
        public void reset() {
            Logging.i(AudioRoutingController.TAG, "Monitor stop state, reset");
            AudioRoutingController.this.mBTHeadSetProperlySeted = false;
            AudioRoutingController.this.cancelTimer();
            if (AudioRoutingController.this.mIsBTScoStarted || AudioRoutingController.this.getAudioManager().isBluetoothScoOn()) {
                AudioRoutingController.this.mIsBTScoStarted = false;
                AudioRoutingController.this.stopBtSco();
            }
            AudioRoutingController.this.mForceSpeakerphone = -1;
            AudioRoutingController.this.mCurrentRouting = -1;
            AudioRoutingController.this.mDefaultRouting = -1;
            AudioRoutingController.this.mScoConnectionAttemps = 0;
            Logging.i(AudioRoutingController.TAG, "Monitor stopped");
        }

        @Override
        public void onEvent(int n2, int n3) {
            Logging.d(AudioRoutingController.TAG, "StopState: onEvent: " + n2 + ", info: " + n3);
            try {
                AudioManager audioManager = AudioRoutingController.this.getAudioManager();
                switch (n2) {
                    case 11: {
                        audioManager.setSpeakerphoneOn(n3 == 1);
                        AudioRoutingController.this.mCurrentRouting = n3 == 1 ? 3 : -1;
                        AudioRoutingController.this.mForceSpeakerphone = n3;
                        AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.queryCurrentAudioRouting());
                        break;
                    }
                    default: {
                        super.onEvent(n2, n3);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                Logging.e(AudioRoutingController.TAG, "onEvent: Exception ", exception);
            }
        }
    }

    private abstract class ControllerBaseState
    implements ControllerState {
        private ControllerBaseState() {
        }

        @Override
        public void setState(int n2) {
            if (n2 == this.getState()) {
                Logging.i(AudioRoutingController.TAG, "setState: state not changed!");
                return;
            }
            AudioRoutingController.this.mState = AudioRoutingController.this.changeState(n2);
        }

        @Override
        public void reset() {
            AudioRoutingController.this.resetAudioRouting();
        }

        @Override
        public int getState() {
            return 0;
        }

        @Override
        public void onEvent(int n2, int n3) {
            switch (n2) {
                case 1: {
                    AudioRoutingController.this.mHeadsetType = n3;
                    AudioRoutingController.this.mIsWiredHeadsetPlugged = n3 >= 0;
                    break;
                }
                case 2: {
                    AudioRoutingController.this.mIsBTHeadsetPlugged = n3 == 1;
                    break;
                }
                case 14: {
                    AudioRoutingController.this.mVideoDisabled = n3 > 0;
                    break;
                }
                case 12: {
                    AudioRoutingController.this.mMuteLocal = n3 > 0;
                    break;
                }
                case 13: {
                    AudioRoutingController.this.mMuteRemotes = n3 > 0;
                    break;
                }
                case 21: {
                    AudioRoutingController.this.mEngineRole = n3;
                    break;
                }
                case 22: {
                    AudioRoutingController.this.mPhoneInCall = n3 > 0;
                    break;
                }
                case 112: {
                    AudioRoutingController.this.mUsingCommParameters = true;
                }
                case 113: {
                    AudioRoutingController.this.mUsingCommParameters = false;
                }
            }
        }
    }

    private static interface ControllerState {
        public void setState(int var1);

        public int getState();

        public void onEvent(int var1, int var2);

        public void reset();
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            AudioRoutingController.this.mState.onEvent(message.what, message.arg1);
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            block29: {
                String string = intent.getAction();
                try {
                    if (string.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                        int n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                        int n3 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BT ACTION_CONNECTION_STATE_CHANGED prev " + n3 + ", " + n2);
                        BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        switch (n2) {
                            case 2: {
                                if (bluetoothDevice != null && (bluetoothDevice.getBluetoothClass().hasService(0x200000) || bluetoothDevice.getBluetoothClass().hasService(0x400000))) {
                                    Logging.i(AudioRoutingController.TAG, "Bluetooth device " + bluetoothDevice + " connected");
                                    AudioRoutingController.this.mScoConnectionAttemps = 0;
                                    AudioRoutingController.this.sendEvent(2, 1);
                                    break;
                                }
                                break block29;
                            }
                            case 1: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + bluetoothDevice + " connecting");
                                break;
                            }
                            case 3: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + bluetoothDevice + " disconnecting");
                                AudioRoutingController.this.mIsBTHeadsetPlugged = false;
                                break;
                            }
                            case 0: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + bluetoothDevice + " disconnected");
                                AudioRoutingController.this.sendEvent(2, 0);
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + bluetoothDevice + " unknown event, state=" + n2);
                                break;
                            }
                        }
                        break block29;
                    }
                    if (string.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                        int n4 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                        int n5 = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BT ACTION_AUDIO_STATE_CHANGED prev " + n5 + ", " + n4);
                        BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        switch (n4) {
                            case 12: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + bluetoothDevice + " connected");
                                break;
                            }
                            case 11: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + bluetoothDevice + " connecting");
                                break;
                            }
                            case 10: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + bluetoothDevice + " disconnected");
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + bluetoothDevice + " event, state=" + n4);
                                break;
                            }
                        }
                        break block29;
                    }
                    if (string.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                        int n6 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                        int n7 = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BT ACTION_SCO_AUDIO_STATE_UPDATED prev " + n7 + ", " + n6);
                        switch (n6) {
                            case 1: {
                                if (AudioRoutingController.this.mBTAdapter.getProfileConnectionState(1) == 2) {
                                    Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device connected");
                                    AudioRoutingController.this.cancelTimer();
                                    AudioRoutingController.this.sendEvent(3, 1);
                                    break;
                                }
                                break block29;
                            }
                            case 2: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device connecting");
                                break;
                            }
                            case -1: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device error");
                                break;
                            }
                            case 0: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device disconnected");
                                AudioRoutingController.this.sendEvent(3, 0);
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device unknown event, state=" + n6);
                                break;
                            }
                        }
                        break block29;
                    }
                    if (string.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                        int n8 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                        int n9 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BluetoothAdapter.ACTION_STATE_CHANGED prev " + n9 + ", " + n8);
                        switch (n8) {
                            case 10: {
                                AudioRoutingController.this.sendEvent(2, 0);
                                break;
                            }
                            case 12: {
                                if (AudioRoutingController.this.mBTAdapter.getProfileConnectionState(2) != 2 && AudioRoutingController.this.mBTAdapter.getProfileConnectionState(1) != 2) break;
                                AudioRoutingController.this.sendEvent(2, 1);
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Logging.e(AudioRoutingController.TAG, "BT broadcast receiver onReceive fail ", exception);
                }
            }
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean bl) {
            this.isRegistered = bl;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") && intent.hasExtra("state")) {
                int n2 = intent.getIntExtra("state", -1);
                if (n2 == 1) {
                    int n3 = intent.getIntExtra("microphone", -1);
                    if (n3 == 1) {
                        Logging.i(AudioRoutingController.TAG, "Headset w/ mic connected");
                        AudioRoutingController.this.sendEvent(1, 0);
                    } else {
                        Logging.i(AudioRoutingController.TAG, "Headset w/o mic connected");
                        AudioRoutingController.this.sendEvent(1, 2);
                    }
                } else if (n2 == 0) {
                    Logging.i(AudioRoutingController.TAG, "Headset disconnected");
                    AudioRoutingController.this.sendEvent(1, -1);
                } else {
                    Logging.i(AudioRoutingController.TAG, "Headset unknown event detected, state=" + n2);
                }
            }
        }
    }
}

