/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import com.coloros.ocs.base.common.api.OnConnectionSucceedListener;
import com.coloros.ocs.mediaunit.MediaUnit;
import com.coloros.ocs.mediaunit.MediaUnitClient;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.internal.Logging;

public class OppoHardwareEarback
implements IHardwareEarback {
    private boolean isConnected = false;
    private Context mContext = null;
    private static String TAG = "AG-OPPO";

    public OppoHardwareEarback(Context context) {
        this.mContext = context;
        this.initialize();
    }

    @Override
    public void initialize() {
        try {
            if (this.mContext != null) {
                MediaUnit.getMediaClient(this.mContext).addOnConnectionSucceedListener(new OnConnectionSucceedListener(){

                    @Override
                    public void onConnectionSucceed() {
                        OppoHardwareEarback.this.isConnected = true;
                    }
                });
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        return this.isConnected;
    }

    @Override
    public int enableEarbackFeature(boolean bl) {
        boolean bl2 = false;
        try {
            if (this.mContext != null && this.isConnected) {
                if (bl) {
                    MediaUnit.getMediaClient(this.mContext).addOnConnectionSucceedListener(new OnConnectionSucceedListener(){

                        @Override
                        public void onConnectionSucceed() {
                            if (OppoHardwareEarback.this.mContext != null) {
                                MediaUnit.getMediaClient(OppoHardwareEarback.this.mContext).requestAudioLoopback();
                            }
                        }
                    });
                } else {
                    MediaUnit.getMediaClient(this.mContext).addOnConnectionSucceedListener(new OnConnectionSucceedListener(){

                        @Override
                        public void onConnectionSucceed() {
                            if (OppoHardwareEarback.this.mContext != null) {
                                MediaUnit.getMediaClient(OppoHardwareEarback.this.mContext).abandonAudioLoopback();
                            }
                        }
                    });
                }
                return 0;
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
        return -1;
    }

    @Override
    public int setHardwareEarbackVolume(int n2) {
        return 0;
    }

    @Override
    public void destroy() {
        try {
            if (this.mContext != null) {
                MediaUnit.getMediaClient(this.mContext);
                MediaUnitClient.release();
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
    }
}

