/*
 * Decompiled with CFR 0.152.
 */
package com.coloros.ocs.mediaunit;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import com.coloros.ocs.base.common.Feature;
import com.coloros.ocs.base.common.api.Api;
import com.coloros.ocs.base.common.api.ColorApi;
import com.coloros.ocs.base.common.api.TaskListenerHolder;
import com.coloros.ocs.base.internal.ClientSettings;
import com.coloros.ocs.base.task.TaskImpl;
import com.coloros.ocs.mediaunit.IKaraokeService;
import com.coloros.ocs.mediaunit.MediaClient;
import com.coloros.ocs.mediaunit.MediaClientBuilder;
import java.util.ArrayList;

public final class MediaUnitClient
extends ColorApi<Api.ApiOptions.NoOptions, MediaUnitClient> {
    private static final String TAG = "MediaUnitClientImpl";
    private static final String BIND_SERVICE_ACTION = "com.coloros.opencapabilityservice";
    private static final String BIND_SERVICE_PACKAGE_NAME = "com.coloros.ocs.opencapabilityservice";
    private static final String BIND_SERVICE_NAME = "com.coloros.ocs.opencapabilityservice.capability.karaoke.KaraokeService";
    private static final Api.ClientKey<MediaClient> CLIENT_KEY = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<MediaClient, Api.ApiOptions.NoOptions> CLIENT_BUILDER = new MediaClientBuilder();
    private static final Api<Api.ApiOptions.NoOptions> API = new Api<Api.ApiOptions.NoOptions>("MediaClient.API", CLIENT_BUILDER, CLIENT_KEY);
    private IKaraokeService mService;
    private final IBinder mICallBack = new Binder();
    private Context mContext;
    private ServiceConnection mConnection;
    private static MediaUnitClient sMediaUnitClient;

    private MediaUnitClient(@NonNull Context context) {
        super(context, API, null, new ClientSettings(context.getPackageName(), 1, new ArrayList<Feature>()));
        this.mContext = context;
        this.init();
    }

    protected static synchronized MediaUnitClient initialize(@NonNull Context context) {
        if (null != sMediaUnitClient) {
            return sMediaUnitClient;
        }
        MediaUnitClient.checkRuntimeEnvironment(context);
        return sMediaUnitClient;
    }

    private static void checkRuntimeEnvironment(@NonNull Context context) {
        sMediaUnitClient = new MediaUnitClient(context);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean hasFeature(String s) {
        return true;
    }

    @Override
    protected void init() {
    }

    private void bindService() {
        this.mConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder service) {
                MediaUnitClient.this.mService = IKaraokeService.Stub.asInterface(service);
                try {
                    MediaUnitClient.this.mService.requestAudioLoopback(MediaUnitClient.this.mICallBack, MediaUnitClient.this.mContext.getPackageName());
                }
                catch (RemoteException e2) {
                    e2.printStackTrace();
                }
            }

            public void onServiceDisconnected(ComponentName className) {
                MediaUnitClient.this.mService = null;
            }
        };
        Intent intent = new Intent(BIND_SERVICE_ACTION);
        String packageName = BIND_SERVICE_PACKAGE_NAME;
        intent.setComponent(new ComponentName(packageName, BIND_SERVICE_NAME));
        this.mContext.bindService(intent, this.mConnection, 1);
    }

    public int requestAudioLoopback() {
        Log.i((String)TAG, (String)("requestAudioLoopback " + this.mICallBack));
        TaskListenerHolder.SuccessNotifier<Void> successListener = new TaskListenerHolder.SuccessNotifier<Void>(){

            @Override
            public void notifyListener(TaskImpl<Void> task) {
                if (MediaUnitClient.this.mService == null) {
                    MediaUnitClient.this.bindService();
                    return;
                }
                try {
                    MediaUnitClient.this.mService.requestAudioLoopback(MediaUnitClient.this.mICallBack, MediaUnitClient.this.mContext.getPackageName());
                }
                catch (RemoteException e2) {
                    e2.printStackTrace();
                }
            }
        };
        TaskListenerHolder.FailureNotifier<Void> failListener = new TaskListenerHolder.FailureNotifier<Void>(){

            @Override
            public void onNotifyListenerFailed(TaskImpl task, int errorCode, String errorMessage) {
                Log.e((String)MediaUnitClient.TAG, (String)("errorCode -- " + errorCode));
            }
        };
        this.doRegisterListener(Looper.myLooper(), successListener, failListener);
        return 0;
    }

    public int abandonAudioLoopback() {
        TaskListenerHolder.SuccessNotifier<Void> successListener = new TaskListenerHolder.SuccessNotifier<Void>(){

            @Override
            public void notifyListener(TaskImpl<Void> task) {
                if (MediaUnitClient.this.mService != null) {
                    try {
                        MediaUnitClient.this.mService.abandonAudioLoopback(MediaUnitClient.this.mContext.getPackageName());
                    }
                    catch (RemoteException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        };
        TaskListenerHolder.FailureNotifier<Void> failListener = new TaskListenerHolder.FailureNotifier<Void>(){

            @Override
            public void onNotifyListenerFailed(TaskImpl task, int errorCode, String errorMessage) {
                Log.e((String)MediaUnitClient.TAG, (String)("errorCode -- " + errorCode));
            }
        };
        this.doRegisterListener(Looper.myLooper(), successListener, failListener);
        return 0;
    }

    private void destroy() {
        this.mContext.unbindService(this.mConnection);
    }

    public static void release() {
        sMediaUnitClient.destroy();
    }
}

