/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.VideoCapture;
import io.agora.rtc.video.VideoCaptureCamera;
import io.agora.rtc.video.VideoCaptureCamera2;

public class VideoCaptureFactory {
    private static final String TAG = "CAM-FACTORY";

    private static boolean isLReleaseOrLater() {
        if ("ocean".equalsIgnoreCase(Build.DEVICE) && "oe106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("trident".equalsIgnoreCase(Build.DEVICE) && "de106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("shark".equalsIgnoreCase(Build.DEVICE) && "skr-a0".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("hnnem-h".equalsIgnoreCase(Build.DEVICE)) {
            return false;
        }
        if ("on7xelte".equals(Build.DEVICE) && "SM-G610F".equals(Build.MODEL)) {
            return false;
        }
        if ("m2c".equals(Build.DEVICE) || "M578CA".equals(Build.MODEL)) {
            return false;
        }
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && (Build.MODEL.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || "SC-02H".equals(Build.MODEL) || "SCV33".equals(Build.MODEL) || "SC-02J".equals(Build.MODEL) || "SCV36".equals(Build.MODEL) || "SM-G892A".equals(Build.MODEL) || "SM-G892U".equals(Build.MODEL) || "SC-03J".equals(Build.MODEL) || "SCV35".equals(Build.MODEL))) {
            return false;
        }
        if ("oneplus".equalsIgnoreCase(Build.MANUFACTURER)) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    public static VideoCapture createVideoCapture(int id, Context context, long nativeVideoCaptureDeviceAndroid) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, id)) {
            return new VideoCaptureCamera2(context, id, nativeVideoCaptureDeviceAndroid);
        }
        return new VideoCaptureCamera(context, id, nativeVideoCaptureDeviceAndroid);
    }

    public static int getNumberOfCameras(Context appContext) {
        return AndroidCameraInfo.getNumberOfCameras(appContext);
    }

    public static String getDeviceName(int id, Context appContext) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(appContext, id)) {
            return VideoCaptureCamera2.getName(id, appContext);
        }
        return VideoCaptureCamera.getName(id);
    }

    public static int getDeviceOrientation(int id, Context appContext) {
        if (VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(appContext, id)) {
            return VideoCaptureCamera2.getSensorOrientation(id, appContext);
        }
        return VideoCaptureCamera.getSensorOrientation(id);
    }

    public static String getCapabilities(int id, Context appContext) {
        String cap = VideoCapture.fetchCapability(id, appContext);
        if (cap == null) {
            Logging.e(TAG, "Capability hasn't been created");
        } else {
            VideoCaptureFactory.printCameraInfo(cap);
        }
        return cap;
    }

    public static int printCameraInfo(String cap) {
        int bytesPerLoop = 150;
        int loopTimes = cap.length() / bytesPerLoop + 1;
        for (int i = 0; i < loopTimes; ++i) {
            try {
                String cameraInfo = "lines = " + loopTimes + ":";
                cameraInfo = i == loopTimes - 1 ? cameraInfo + cap.substring(i * bytesPerLoop, cap.length()) : cameraInfo + cap.substring(i * bytesPerLoop, (i + 1) * bytesPerLoop);
                Logging.d("CameraInfo", cameraInfo);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    static class AndroidCameraInfo {
        private static int sNumberOfSystemCameras = -1;

        AndroidCameraInfo() {
        }

        private static int getNumberOfCameras(Context appContext) {
            if (sNumberOfSystemCameras == -1) {
                if (Build.VERSION.SDK_INT < 23 && appContext.getPackageManager().checkPermission("android.permission.CAMERA", appContext.getPackageName()) != 0) {
                    sNumberOfSystemCameras = 0;
                    Log.e((String)VideoCaptureFactory.TAG, (String)"Missing android.permission.CAMERA permission, no system camera available");
                } else {
                    sNumberOfSystemCameras = 0;
                    if (VideoCaptureFactory.isLReleaseOrLater()) {
                        sNumberOfSystemCameras = VideoCaptureCamera2.getNumberOfCameras(appContext);
                    }
                    if (sNumberOfSystemCameras == 0) {
                        sNumberOfSystemCameras = VideoCaptureCamera.getNumberOfCameras();
                    }
                }
            }
            return sNumberOfSystemCameras;
        }
    }
}

