/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

@TargetApi(value=21)
public class VideoCaptureCamera2
extends VideoCapture {
    private static final boolean DEBUG = false;
    private CameraDevice mCameraDevice = null;
    private CaptureRequest.Builder mPreviewBuilder = null;
    private CameraCaptureSession mCaptureSession = null;
    private ImageReader mImageReader = null;
    private static final double kNanoSecondsToFps = 1.0E-9;
    private static final String TAG = "CAMERA2";
    private CameraState mCameraState = CameraState.STOPPED;
    private CameraManager mManager = null;
    private Handler mMainHandler = new Handler(this.mContext.getMainLooper());
    private HandlerThread mPreviewThread = null;
    private final Object mCameraStateLock = new Object();
    private int mExpectedFrameSize = 0;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 35;
    private byte[] mCaptureData;
    private boolean mFaceDetectSupported;
    private int mFaceDetectMode;
    private boolean mIsAutoFaceFocusEnabled = false;
    private static final MeteringRectangle[] ZERO_WEIGHT_3A_REGION = new MeteringRectangle[]{new MeteringRectangle(0, 0, 0, 0, 0)};
    private MeteringRectangle[] mAFAERegions = ZERO_WEIGHT_3A_REGION;
    private static final float ZOOM_UNSUPPORTED_DEFAULT_VALUE = 1.0f;
    private static final float DEFAULT_VALUE = -1.0f;
    private float mLastZoomRatio = -1.0f;
    private float mCurZoomRatio = 1.0f;
    private float mMaxZoom = -1.0f;
    private Rect mSensorRect = null;
    public CameraManager.AvailabilityCallback mAvailabilityCallback = new CameraManager.AvailabilityCallback(){

        public synchronized void onCameraAvailable(String cameraId) {
            super.onCameraAvailable(cameraId);
            if (VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED && VideoCaptureCamera2.this.tryOpenCamera() != 0) {
                Logging.e(VideoCaptureCamera2.TAG, "start capture failed");
            }
        }

        public synchronized void onCameraUnavailable(String cameraId) {
            super.onCameraUnavailable(cameraId);
            Logging.e(VideoCaptureCamera2.TAG, "Camera " + cameraId + " unavailable");
        }
    };
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){
        private long mLastFocusedTs;

        private void notifyCameraFocusAreaChanged(Rect cropRegion, Rect faceRect) {
            Rect rect = CoordinatesTransform.sensorToNormalizedPreview(faceRect, VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, cropRegion);
            Logging.d(VideoCaptureCamera2.TAG, "face bound = " + faceRect.toString());
            Logging.d(VideoCaptureCamera2.TAG, "rect (-1000, 1000) = " + rect.toString());
            boolean isMirror = false;
            if (VideoCaptureCamera2.this.mId == 1) {
                isMirror = true;
            }
            RectF rectF = CoordinatesTransform.normalizedFaceRect(rect, 0, isMirror);
            Logging.d(VideoCaptureCamera2.TAG, "preview size width = " + VideoCaptureCamera2.this.mCaptureWidth + " height = " + VideoCaptureCamera2.this.mCaptureHeight);
            Logging.d(VideoCaptureCamera2.TAG, "auto face focus left =" + rectF.left + " top = " + rectF.top + " right = " + rectF.right + " bottom = " + rectF.bottom + "isMirror =" + isMirror);
            float x = rectF.left;
            float y = rectF.top;
            float width = rectF.width();
            float height = rectF.height();
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.NotifyCameraFocusAreaChanged(x, y, width, height, VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
            }
        }

        private void process(CaptureResult result) {
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            if (faces != null && faces.length > 0) {
                if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                    if (faces[0].getScore() > 20) {
                        Rect cropRegion = (Rect)result.get(CaptureResult.SCALER_CROP_REGION);
                        this.notifyCameraFocusAreaChanged(cropRegion, faces[0].getBounds());
                    }
                    return;
                }
                if (faces[0].getScore() <= 50) {
                    return;
                }
                VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, new MeteringRectangle[]{new MeteringRectangle(faces[0].getBounds(), 1000)});
                VideoCaptureCamera2.this.addRegionsToCaptureRequestBuilder(VideoCaptureCamera2.this.mPreviewBuilder);
                if (VideoCaptureCamera2.this.mCameraState != CameraState.STARTED) {
                    return;
                }
                try {
                    Rect cropRegion = (Rect)result.get(CaptureResult.SCALER_CROP_REGION);
                    Logging.d(VideoCaptureCamera2.TAG, "cropRegion = " + cropRegion.toString());
                    Logging.d(VideoCaptureCamera2.TAG, "capture size wxh = " + VideoCaptureCamera2.this.mCaptureWidth + " x " + VideoCaptureCamera2.this.mCaptureHeight);
                    this.notifyCameraFocusAreaChanged(cropRegion, faces[0].getBounds());
                    VideoCaptureCamera2.this.mCaptureSession.capture(VideoCaptureCamera2.this.mPreviewBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, null);
                }
                catch (Exception ex) {
                    Logging.e(VideoCaptureCamera2.TAG, "capture: " + ex);
                    return;
                }
                VideoCaptureCamera2.this.createCaptureRequest();
                this.mLastFocusedTs = System.currentTimeMillis();
            } else {
                VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, ZERO_WEIGHT_3A_REGION);
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            if (VideoCaptureCamera2.this.mIsAutoFaceFocusEnabled && VideoCaptureCamera2.this.isAutoFaceFocusSupported()) {
                this.process((CaptureResult)result);
            }
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (null == afState) {
                return;
            }
            if (4 == afState || 5 == afState) {
                VideoCaptureCamera2.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                VideoCaptureCamera2.this.startNormalPreview();
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };

    private static CameraCharacteristics getCameraCharacteristics(Context appContext, int id) {
        CameraManager manager = (CameraManager)appContext.getSystemService("camera");
        try {
            return manager.getCameraCharacteristics(Integer.toString(id));
        }
        catch (CameraAccessException ex) {
            Logging.i(TAG, "getNumberOfCameras: getCameraIdList(): " + (Object)((Object)ex));
        }
        catch (Exception ex) {
            Logging.i(TAG, "getNumberOfCameras: got exception: " + ex);
        }
        return null;
    }

    static boolean isLegacyDevice(Context appContext, int id) {
        try {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id);
            return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
        }
        catch (Throwable e) {
            Logging.w(TAG, "this is a legacy camera device");
            return true;
        }
    }

    static int getNumberOfCameras(Context appContext) {
        CameraManager manager = (CameraManager)appContext.getSystemService("camera");
        try {
            return manager.getCameraIdList().length;
        }
        catch (Exception ex) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): ", ex);
            return 0;
        }
    }

    static String getName(int id, Context appContext) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id);
        if (cameraCharacteristics == null) {
            return null;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        return "camera2 " + id + ", facing " + (facing == 0 ? "front" : "back");
    }

    static int getSensorOrientation(int id, Context appContext) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id);
        if (cameraCharacteristics == null) {
            return -1;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    VideoCaptureCamera2(Context context, int id, long nativeVideoCaptureDeviceAndroid) {
        super(context, id, nativeVideoCaptureDeviceAndroid);
    }

    private void startNormalPreview() {
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        Handler backgroundHandler = new Handler(this.mPreviewThread.getLooper());
        try {
            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, backgroundHandler);
        }
        catch (CameraAccessException e) {
            Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(CameraState state) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = state;
            this.mCameraStateLock.notifyAll();
        }
    }

    private int createCaptureRequest() {
        try {
            this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, null);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -1;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -2;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -3;
        }
        catch (IllegalStateException ex) {
            Logging.e(TAG, "capture:" + ex);
            return -4;
        }
        return 0;
    }

    private static void readImageIntoBuffer(Image image, byte[] data) {
        int width = image.getWidth();
        int height = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        int offset = 0;
        for (int plane = 0; plane < planes.length; ++plane) {
            int planeHeight;
            ByteBuffer buffer = planes[plane].getBuffer();
            if (buffer == null) {
                Logging.e(TAG, "plane " + plane + " buffer is null ");
                break;
            }
            int rowStride = planes[plane].getRowStride();
            int pixelStride = planes[plane].getPixelStride();
            int planeWidth = plane == 0 ? width : width / 2;
            int n = planeHeight = plane == 0 ? height : height / 2;
            if (pixelStride == 1 && rowStride == planeWidth) {
                buffer.get(data, offset, planeWidth * planeHeight);
                offset += planeWidth * planeHeight;
                continue;
            }
            byte[] rowData = new byte[rowStride];
            for (int row = 0; row < planeHeight - 1; ++row) {
                buffer.get(rowData, 0, rowStride);
                for (int col = 0; col < planeWidth; ++col) {
                    data[offset++] = rowData[col * pixelStride];
                }
            }
            buffer.get(rowData, 0, Math.min(rowStride, buffer.remaining()));
            for (int col = 0; col < planeWidth; ++col) {
                data[offset++] = rowData[col * pixelStride];
            }
        }
    }

    private int tryOpenCamera() {
        CrStateListener stateListener = new CrStateListener();
        try {
            this.mManager.openCamera(Integer.toString(this.mId), (CameraDevice.StateCallback)stateListener, this.mMainHandler);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: ", ex);
            return -1;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: ", ex);
            return -2;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: ", ex);
            return -3;
        }
        catch (Exception ex) {
            Logging.e(TAG, "unknown error", ex);
            return -4;
        }
        return 0;
    }

    private void addRegionsToCaptureRequestBuilder(CaptureRequest.Builder builder) {
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        builder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)this.mAFAERegions);
        builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)this.mAFAERegions);
        builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
    }

    private int doStartCapture() {
        int bufSize;
        int maxImages = 2;
        this.mExpectedFrameSize = bufSize = this.mCaptureWidth * this.mCaptureHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
        this.mCaptureData = new byte[this.mExpectedFrameSize];
        this.mImageReader = ImageReader.newInstance((int)this.mCaptureWidth, (int)this.mCaptureHeight, (int)this.mCaptureFormat, (int)2);
        if (this.mPreviewThread == null) {
            this.mPreviewThread = new HandlerThread("CameraPreview");
            this.mPreviewThread.start();
        }
        Handler backgroundHandler = new Handler(this.mPreviewThread.getLooper());
        ImageReaderListener imageReaderListener = new ImageReaderListener();
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)imageReaderListener, backgroundHandler);
        try {
            this.mPreviewBuilder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "createCaptureRequest: ", ex);
            return -1;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "createCaptureRequest: ", ex);
            return -2;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "createCaptureRequest ", ex);
            return -3;
        }
        if (this.mPreviewBuilder == null) {
            Logging.e(TAG, "mPreviewBuilder error");
            return -4;
        }
        this.mPreviewBuilder.addTarget(this.mImageReader.getSurface());
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        this.setFaceDetect(this.mPreviewBuilder, this.mFaceDetectMode);
        ArrayList<Surface> surfaceList = new ArrayList<Surface>(1);
        surfaceList.add(this.mImageReader.getSurface());
        CaptureSessionListener captureSessionListener = new CaptureSessionListener();
        try {
            this.mCameraDevice.createCaptureSession(surfaceList, (CameraCaptureSession.StateCallback)captureSessionListener, null);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "createCaptureSession :", ex);
            return -1;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "createCaptureSession :", ex);
            return -2;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "createCaptureSession :", ex);
            return -3;
        }
        return 0;
    }

    private int doStopCapture() {
        if (this.mPreviewThread != null) {
            this.mPreviewThread.quitSafely();
            this.mPreviewThread = null;
        }
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.abortCaptures();
                this.mCaptureSession = null;
            }
            catch (CameraAccessException ex) {
                Logging.e(TAG, "abortCaptures: ", ex);
                return -1;
            }
            catch (IllegalStateException ex) {
                Logging.e(TAG, "abortCaptures: ", ex);
                return -1;
            }
        }
        if (this.mImageReader != null) {
            this.mImageReader.setOnImageAvailableListener(null, null);
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.close();
            this.mCameraDevice = null;
        }
        return 0;
    }

    @Override
    public int UnRegisterNativeHandle() {
        this.mNativeVideoCaptureDeviceAndroid = 0L;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate() {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState == CameraState.OPENING) {
                Logging.e(TAG, "allocate() invoked while Camera is busy opening/configuring");
                return -1;
            }
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext) == null) {
            VideoCaptureCamera2.createCapabilities(this.mId, this.mContext);
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(this.mNativeVideoCaptureDeviceAndroid);
        }
        this.mCameraNativeOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mManager = (CameraManager)this.mContext.getSystemService("camera");
        int[] availableFDModes = (int[])cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        int maxFDCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (availableFDModes.length > 1 && maxFDCount > 0) {
            this.mFaceDetectSupported = true;
            int modeSum = 0;
            for (int fdMode : availableFDModes) {
                modeSum += fdMode;
            }
            this.mFaceDetectMode = modeSum % 2 != 0 ? 1 : 2;
        }
        Logging.i(TAG, "allocate() face detection: " + this.mFaceDetectMode + " " + maxFDCount + " " + this.mFaceDetectSupported);
        this.mManager.registerAvailabilityCallback(this.mAvailabilityCallback, this.mMainHandler);
        return 0;
    }

    @Override
    public int setCaptureFormat(int format) {
        int androidFormat = VideoCaptureCamera2.translateToAndroidFormat(format);
        if (androidFormat != this.mCaptureFormat) {
            Logging.e(TAG, "For camera2 api, only YUV_420_888 format are supported");
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startCapture(int width, int height, int frameRate) {
        Logging.d(TAG, "startCapture, w=" + width + ", h=" + height + ", fps=" + frameRate);
        this.mCaptureWidth = width;
        this.mCaptureHeight = height;
        this.mCaptureFps = frameRate;
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.EVICTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException ex) {
                    Logging.e(TAG, "CaptureStartedEvent: ", ex);
                }
            }
            if (this.mCameraState == CameraState.STARTED) {
                return 0;
            }
        }
        this.changeCameraStateAndNotify(CameraState.OPENING);
        int res = this.tryOpenCamera();
        if (res != 0) {
            this.changeCameraStateAndNotify(CameraState.STOPPED);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopCapture() {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.EVICTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException ex) {
                    Logging.e(TAG, "CaptureStartedEvent: ", ex);
                }
            }
            if (this.mCameraState == CameraState.EVICTED) {
                this.mCameraState = CameraState.STOPPED;
            }
            if (this.mCameraState == CameraState.STOPPED) {
                return 0;
            }
            this.doStopCapture();
            this.mCameraState = CameraState.STOPPED;
            this.mCameraStateLock.notifyAll();
        }
        return 0;
    }

    @Override
    public boolean isTorchSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Boolean available = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean isFlashSupported = available == null ? false : available;
        return isFlashSupported;
    }

    @Override
    public boolean isFocusSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] availableModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (availableModes != null) {
            for (int i = 0; i < availableModes.length; ++i) {
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] availableModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (availableModes != null) {
            for (int i = 0; i < availableModes.length; ++i) {
                Logging.d(TAG, "isExposureSupported AE mode = " + availableModes[i]);
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isZoomSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        float maxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        return maxZoom > 1.0f;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (!this.isFocusSupported()) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer maxFaceCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        return maxFaceCount > 0;
    }

    @Override
    public int setZoom(float zoomValue) {
        boolean needZoom;
        Log.d((String)"zoom", (String)("setCameraZoom api2 called zoomValue =" + zoomValue));
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setZoom mPreviewBuilder is null");
            return -1;
        }
        if (this.mSensorRect == null) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1;
            }
            this.mSensorRect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        if (Math.abs(this.mMaxZoom - 1.0f) < 0.001f) {
            Logging.w(TAG, "Camera " + this.mId + " does not support camera zoom");
            return -1;
        }
        this.mCurZoomRatio = zoomValue;
        boolean bl = needZoom = this.mCurZoomRatio > 1.0f && this.mCurZoomRatio <= this.mMaxZoom && this.mCurZoomRatio != this.mLastZoomRatio;
        if (!needZoom) {
            return -2;
        }
        Rect zoomRect = this.cropRegionForZoom(this.mCurZoomRatio);
        this.mPreviewBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoomRect);
        this.mLastZoomRatio = this.mCurZoomRatio;
        if (this.mPreviewThread != null) {
            Handler backgroundHandler = new Handler(this.mPreviewThread.getLooper());
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mCaptureCallback, backgroundHandler);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                    return -3;
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    return -4;
                }
            }
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mMaxZoom <= 0.0f) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1.0f;
            }
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        return this.mMaxZoom;
    }

    @Override
    public int setTorchMode(boolean isTorchOn) {
        boolean isFlashSupported;
        Log.d((String)"flash", (String)("setFlashMode isTorchOn " + isTorchOn));
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1;
        }
        Boolean available = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean bl = isFlashSupported = available == null ? false : available;
        if (isFlashSupported) {
            if (this.mPreviewThread != null && this.mPreviewBuilder != null) {
                Handler backgroundHandler = new Handler(this.mPreviewThread.getLooper());
                if (isTorchOn) {
                    this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                } else {
                    this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                }
                if (this.mCaptureSession != null) {
                    try {
                        this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, backgroundHandler);
                        return 0;
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Logging.w(TAG, "flash is not supported");
        }
        return -1;
    }

    @Override
    public int setFocus(float valX, float valY, boolean inPreview) {
        if (valX < 0.0f || valX > 1.0f || valY < 0.0f || valY > 1.0f) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setFocus mPreviewBuilder is null");
            return -1;
        }
        double x = valX;
        double y = valY;
        Rect cropRegion = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (cropRegion == null) {
            return -1;
        }
        int cropWidth = cropRegion.width();
        int cropHeight = cropRegion.height();
        Log.d((String)"test", (String)("crop width = " + cropWidth + " crop height = " + cropHeight + " capture width = " + this.mCaptureWidth + " capture height = " + this.mCaptureHeight));
        int tempX = 0;
        int tempY = 0;
        if (cropWidth * this.mCaptureHeight > cropHeight * this.mCaptureWidth) {
            int tempCropW = cropHeight * this.mCaptureWidth / this.mCaptureHeight;
            tempX = (int)((double)((float)(cropWidth - tempCropW) / 2.0f) + x * (double)tempCropW);
            tempY = (int)(y * (double)cropHeight);
        } else {
            int tempCropH = cropWidth * this.mCaptureHeight / this.mCaptureWidth;
            tempX = (int)(x * (double)cropWidth);
            tempY = (int)((double)((float)(cropHeight - tempCropH) / 2.0f) + y * (double)tempCropH);
        }
        double tapAreaRatio = 0.1;
        Rect rect = new Rect();
        rect.left = VideoCaptureCamera2.clamp((int)((double)tempX - tapAreaRatio / 2.0 * (double)cropWidth), 0, cropWidth);
        rect.right = VideoCaptureCamera2.clamp((int)((double)tempX + tapAreaRatio / 2.0 * (double)cropWidth), 0, cropWidth);
        rect.top = VideoCaptureCamera2.clamp((int)((double)tempY - tapAreaRatio / 2.0 * (double)cropHeight), 0, cropHeight);
        rect.bottom = VideoCaptureCamera2.clamp((int)((double)tempY + tapAreaRatio / 2.0 * (double)cropHeight), 0, cropHeight);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mPreviewThread != null) {
            Handler backgroundHandler = new Handler(this.mPreviewThread.getLooper());
            if (this.mCaptureSession != null) {
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), this.mAfCaptureCallback, backgroundHandler);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                    return -1;
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
                this.NotifyCameraFocusAreaChanged(valX, valY, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
            }
        }
        return 0;
    }

    @Override
    public int setExposure(float valX, float valY, boolean inPreview) {
        Logging.d(TAG, "setExposure called camera api2");
        if (valX < 0.0f || valX > 1.0f || valY < 0.0f || valY > 1.0f) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        if (this.mPreviewBuilder == null) {
            Logging.d(TAG, "setExposure mPreviewBuilder is null");
            return -1;
        }
        double x = valX;
        double y = valY;
        Rect cropRegion = (Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (cropRegion == null) {
            return -1;
        }
        int cropWidth = cropRegion.width();
        int cropHeight = cropRegion.height();
        Logging.d(TAG, "crop width = " + cropWidth + " crop height = " + cropHeight + " capture width = " + this.mCaptureWidth + " capture height = " + this.mCaptureHeight);
        int tempX = 0;
        int tempY = 0;
        if (cropWidth * this.mCaptureHeight > cropHeight * this.mCaptureWidth) {
            int tempCropW = cropHeight * this.mCaptureWidth / this.mCaptureHeight;
            tempX = (int)((double)((float)(cropWidth - tempCropW) / 2.0f) + x * (double)tempCropW);
            tempY = (int)(y * (double)cropHeight);
        } else {
            int tempCropH = cropWidth * this.mCaptureHeight / this.mCaptureWidth;
            tempX = (int)(x * (double)cropWidth);
            tempY = (int)((double)((float)(cropHeight - tempCropH) / 2.0f) + y * (double)tempCropH);
        }
        double tapAreaRatio = 0.1;
        Rect rect = new Rect();
        rect.left = VideoCaptureCamera2.clamp((int)((double)tempX - tapAreaRatio / 2.0 * (double)cropWidth), 0, cropWidth);
        rect.right = VideoCaptureCamera2.clamp((int)((double)tempX + tapAreaRatio / 2.0 * (double)cropWidth), 0, cropWidth);
        rect.top = VideoCaptureCamera2.clamp((int)((double)tempY - tapAreaRatio / 2.0 * (double)cropHeight), 0, cropHeight);
        rect.bottom = VideoCaptureCamera2.clamp((int)((double)tempY + tapAreaRatio / 2.0 * (double)cropHeight), 0, cropHeight);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, null);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                return -1;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return -1;
            }
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraExposureAreaChanged(valX, valY, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setAutoFaceFocus(boolean enable) {
        this.mIsAutoFaceFocusEnabled = enable;
        return 0;
    }

    @Override
    public void deallocate() {
        if (this.mManager != null) {
            this.mManager.unregisterAvailabilityCallback(this.mAvailabilityCallback);
        }
    }

    private void setFaceDetect(CaptureRequest.Builder requestBuilder, int faceDetectMode) {
        if (this.mFaceDetectSupported) {
            requestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)faceDetectMode);
        }
    }

    public static int createCapabilities(int id, Context context) {
        String cap = null;
        CameraCharacteristics ch = VideoCaptureCamera2.getCameraCharacteristics(context, id);
        if (ch == null) {
            return -1;
        }
        StreamConfigurationMap map = (StreamConfigurationMap)ch.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            Logging.e(TAG, "Failed to create capabilities");
            return -1;
        }
        try {
            Logging.i(TAG, "dump configuration map:" + map.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Object> sizes = new ArrayList<Size>(Arrays.asList(map.getOutputSizes(35)));
        if ("SM-G9300".equals(Build.MODEL)) {
            ArrayList preferSizes = new ArrayList();
            for (int i = 0; i < sizes.size(); ++i) {
                if (((Size)sizes.get(i)).getHeight() < 720) continue;
                preferSizes.add(sizes.get(i));
            }
            sizes = preferSizes;
        }
        String cap_id = "\"id\":" + id + ",";
        String cap_res_header = "\"resolution\":";
        String cap_res_value = "";
        for (int i = 0; i < sizes.size(); ++i) {
            String ss = "{\"w\":" + ((Size)sizes.get(i)).getWidth() + ",\"h\":" + ((Size)sizes.get(i)).getHeight() + "}";
            cap_res_value = i != sizes.size() - 1 ? cap_res_value + ss + "," : cap_res_value + ss;
        }
        String cap_fmt_header = "\"format\":";
        String cap_fmt_value = "" + VideoCaptureCamera2.translateToEngineFormat(35);
        String cap_fps_header = "\"fps\":";
        String cap_fps_value = "30";
        cap = "{" + cap_id + cap_res_header + "[" + cap_res_value + "]," + cap_fmt_header + "[" + cap_fmt_value + "]," + cap_fps_header + "[" + cap_fps_value + "]}";
        VideoCaptureCamera2.cacheCapability(id, context, cap);
        return 0;
    }

    private Rect cropRegionForZoom(float ratio) {
        int xCenter = this.mSensorRect.width() / 2;
        int yCenter = this.mSensorRect.height() / 2;
        int xDelta = (int)(0.5f * (float)this.mSensorRect.width() / ratio);
        int yDelta = (int)(0.5f * (float)this.mSensorRect.height() / ratio);
        return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
    }

    private static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    private boolean isMeteringAreaAFSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) >= 1;
    }

    static /* synthetic */ MeteringRectangle[] access$402(VideoCaptureCamera2 x0, MeteringRectangle[] x1) {
        x0.mAFAERegions = x1;
        return x1;
    }

    static /* synthetic */ Object access$1700(VideoCaptureCamera2 x0) {
        return x0.mCameraStateLock;
    }

    static /* synthetic */ byte[] access$1800(VideoCaptureCamera2 x0) {
        return x0.mCaptureData;
    }

    static /* synthetic */ void access$1900(Image x0, byte[] x1) {
        VideoCaptureCamera2.readImageIntoBuffer(x0, x1);
    }

    static /* synthetic */ int access$2000(VideoCaptureCamera2 x0) {
        return x0.mExpectedFrameSize;
    }

    private class ImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private ImageReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onImageAvailable(ImageReader reader) {
            block17: {
                block16: {
                    image = null;
                    var3_3 = VideoCaptureCamera2.access$1700(VideoCaptureCamera2.this);
                    // MONITORENTER : var3_3
                    if (VideoCaptureCamera2.access$000(VideoCaptureCamera2.this) != CameraState.STARTED || reader == null) {
                        // MONITOREXIT : var3_3
                        return;
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 40->51)] { 
lbl-1000:
                    // 1 sources

                    {
                        image = reader.acquireLatestImage();
                        if (image != null) break block16;
                        // MONITOREXIT : var3_3
                        if (image == null) return;
                    }
                    image.close();
                    return;
                }
                try {
                    if (image.getFormat() == 35 && image.getPlanes().length == 3) break block17;
                    Logging.e("CAMERA2", "Unexpected image format: " + image.getFormat() + "or #planes:" + image.getPlanes().length);
                    // MONITOREXIT : var3_3
                    if (image == null) return;
                }
lbl21:
                // 4 sources

                catch (IllegalStateException ex) {
                    Logging.e("CAMERA2", "acquireLastest Image():", ex);
                    return;
                }
                image.close();
                return;
            }
            if (reader.getWidth() != image.getWidth()) throw new IllegalStateException("ImageReader size " + reader.getWidth() + "x" + reader.getHeight() + " did not match Image size: " + image.getWidth() + "x" + image.getHeight());
            if (reader.getHeight() != image.getHeight()) {
                throw new IllegalStateException("ImageReader size " + reader.getWidth() + "x" + reader.getHeight() + " did not match Image size: " + image.getWidth() + "x" + image.getHeight());
            }
            VideoCaptureCamera2.access$1900(image, VideoCaptureCamera2.access$1800(VideoCaptureCamera2.this));
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.ProvideCameraFrame(VideoCaptureCamera2.access$1800(VideoCaptureCamera2.this), VideoCaptureCamera2.access$2000(VideoCaptureCamera2.this), VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid);
            } else {
                Logging.w("CAMERA2", "warning mNativeVideoCaptureDeviceAndroid = 0, error");
            }
            // MONITOREXIT : var3_3
            if (image == null) return;
            image.close();
            return;
            finally {
                if (image != null) {
                    image.close();
                }
            }
        }
    }

    private class CaptureSessionListener
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionListener() {
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mCaptureSession = cameraCaptureSession;
            if (VideoCaptureCamera2.this.createCaptureRequest() != 0) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Fail to setup capture session");
                }
            } else {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STARTED);
            }
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Logging.e(VideoCaptureCamera2.TAG, "onConfigureFailed");
            if (VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            }
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera session configuration error");
            }
        }
    }

    private class CrStateListener
    extends CameraDevice.StateCallback {
        private CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            if (VideoCaptureCamera2.this.doStartCapture() < 0) {
                VideoCaptureCamera2.this.doStopCapture();
                if (VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                    VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                }
                Logging.e(VideoCaptureCamera2.TAG, "Camera startCapture failed!!");
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Error configuring camera");
                }
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            if (VideoCaptureCamera2.this.mCameraState != CameraState.STOPPED) {
                Logging.w(VideoCaptureCamera2.TAG, "camera client is evicted by other application");
                if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                    VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera device evicted by other application");
                }
                Logging.i(VideoCaptureCamera2.TAG, "Camera device enter state: EVICTED");
                if (VideoCaptureCamera2.this.mCameraDevice != null) {
                    VideoCaptureCamera2.this.mCameraDevice.close();
                    VideoCaptureCamera2.this.mCameraDevice = null;
                }
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.EVICTED);
                return;
            }
        }

        public void onError(CameraDevice cameraDevice, int error) {
            if (VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                return;
            }
            if (VideoCaptureCamera2.this.mCameraDevice != null) {
                VideoCaptureCamera2.this.mCameraDevice.close();
                VideoCaptureCamera2.this.mCameraDevice = null;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            Logging.e(VideoCaptureCamera2.TAG, "CameraDevice Error :" + Integer.toString(error));
            if (VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera2.this.onCameraError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera device error" + Integer.toString(error));
            }
        }
    }

    private static enum CameraState {
        OPENING,
        STARTED,
        EVICTED,
        STOPPED;

    }
}

