/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.SurfaceHolder;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.ViERenderer;
import io.agora.rtc.video.VideoCapture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class VideoCaptureCamera
extends VideoCapture
implements Camera.PreviewCallback,
SurfaceHolder.Callback {
    private static final String TAG = "CAMERA1";
    private static final boolean DEBUG = false;
    protected Camera mCamera;
    protected ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private ReentrantLock mCaptureLock = new ReentrantLock();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private boolean isFaceDetectionStarted = false;
    private SurfaceHolder mLocalPreview = null;
    private SurfaceTexture mDummySurfaceTexture = null;
    private boolean mOwnsBuffers = false;
    private final int mNumCaptureBuffers = 3;
    private int mExpectedFrameSize = 0;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 17;
    private static final long CAMERA_OPEN_REQUEST_INTERVAL = 2000L;
    private HandlerThread mCameraRecoverHandlerThread = null;
    private Handler mHandler = null;
    private Object mRecoverThreadObjectLock = new Object();
    private Object mObjectLock = new Object();
    private boolean mIsAutoFaceFocusEnabled = false;

    VideoCaptureCamera(Context context, int id, long nativeVideoCaptureDeviceAndroid) {
        super(context, id, nativeVideoCaptureDeviceAndroid);
    }

    protected static Camera.CameraInfo getCameraInfo(int id) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)id, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "getCameraInfo: Camera.getCameraInfo: ", ex);
            return null;
        }
        return cameraInfo;
    }

    static int getNumberOfCameras() {
        return Camera.getNumberOfCameras();
    }

    static String getName(int id) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(id);
        if (cameraInfo == null) {
            return null;
        }
        return "camera " + id + ", facing " + (cameraInfo.facing == 1 ? "front" : "back");
    }

    static int getSensorOrientation(int id) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(id);
        if (cameraInfo == null) {
            return -1;
        }
        return cameraInfo.orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int UnRegisterNativeHandle() {
        Logging.d(TAG, "UnRegisterNativeHandle called");
        Object object = this.mRecoverThreadObjectLock;
        synchronized (object) {
            this.mNativeVideoCaptureDeviceAndroid = 0L;
        }
        return 0;
    }

    @Override
    public int allocate() {
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "allocate: Camera.open: ", ex);
            return -1;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            this.mCamera.release();
            this.mCamera = null;
            return -2;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext) == null) {
            this.createCapabilities();
        }
        this.mCameraNativeOrientation = cameraInfo.orientation;
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setCaptureFormat(int format) {
        Logging.d(TAG, "setCaptureFormat: " + format);
        this.mCaptureFormat = VideoCaptureCamera.translateToAndroidFormat(format);
        if (this.mCaptureFormat == 0) {
            Logging.e(TAG, "setCaptureFormat failed, unkonwn format: " + format);
            return -1;
        }
        return 0;
    }

    private int tryStartCapture(int width, int height, int frameRate) {
        if (this.mCamera == null) {
            Logging.e(TAG, "Camera not initialized %d" + this.mId);
            return -1;
        }
        Logging.i(TAG, "tryStartCapture: " + width + "*" + height + ", frameRate: " + frameRate + ", isCaptureRunning: " + this.isCaptureRunning + ", isSurfaceReady: " + this.isSurfaceReady + ", isCaptureStarted: " + this.isCaptureStarted);
        if (this.isCaptureRunning || !this.isCaptureStarted) {
            Logging.w(TAG, "tryStartCapture return");
            return 0;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setPreviewSize(width, height);
        parameters.setPreviewFormat(this.mCaptureFormat);
        parameters.setPreviewFrameRate(frameRate);
        this.setAdvancedCameraParameters(parameters);
        this.setDeviceSpecificParameters(parameters);
        this.mCamera.setParameters(parameters);
        int bufSize = width * height * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
        bufSize += 4096;
        byte[] buffer = null;
        for (int i = 0; i < 3; ++i) {
            buffer = new byte[bufSize];
            this.mCamera.addCallbackBuffer(buffer);
        }
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        this.mOwnsBuffers = true;
        this.mCamera.setErrorCallback(new Camera.ErrorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(int error, Camera camera) {
                Logging.e(VideoCaptureCamera.TAG, "onError: error code" + error);
                if (error == 2 || error == 100 || error == 1) {
                    if (VideoCaptureCamera.this.mCamera != null) {
                        VideoCaptureCamera.this.stopCapture();
                        VideoCaptureCamera.this.mCaptureLock.lock();
                        if (VideoCaptureCamera.this.mCamera != null) {
                            VideoCaptureCamera.this.mCamera.release();
                            VideoCaptureCamera.this.mCamera = null;
                        }
                        VideoCaptureCamera.this.mCaptureLock.unlock();
                    }
                    Object object = VideoCaptureCamera.this.mRecoverThreadObjectLock;
                    synchronized (object) {
                        if (VideoCaptureCamera.this.mCameraRecoverHandlerThread == null) {
                            VideoCaptureCamera.this.mCameraRecoverHandlerThread = new HandlerThread("camera-recover-thread");
                            VideoCaptureCamera.this.mCameraRecoverHandlerThread.start();
                            if (VideoCaptureCamera.this.mCameraRecoverHandlerThread != null) {
                                VideoCaptureCamera.this.mHandler = new Handler(VideoCaptureCamera.this.mCameraRecoverHandlerThread.getLooper());
                            }
                        }
                        if (VideoCaptureCamera.this.mHandler != null) {
                            VideoCaptureCamera.this.mHandler.postDelayed(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = VideoCaptureCamera.this.mRecoverThreadObjectLock;
                                    synchronized (object) {
                                        Logging.i(VideoCaptureCamera.TAG, "native handle = " + VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid);
                                        if (VideoCaptureCamera.this.isForeground() && null == VideoCaptureCamera.this.mCamera && VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid != 0L) {
                                            VideoCaptureCamera.this.allocate();
                                            VideoCaptureCamera.this.startCapture(VideoCaptureCamera.this.mCaptureWidth, VideoCaptureCamera.this.mCaptureHeight, VideoCaptureCamera.this.mCaptureFps);
                                            return;
                                        }
                                        if (VideoCaptureCamera.this.mHandler != null) {
                                            VideoCaptureCamera.this.mHandler.postDelayed((Runnable)this, 2000L);
                                        }
                                    }
                                }
                            }, 2000L);
                        }
                    }
                }
            }
        });
        this.mCamera.startPreview();
        if (this.isAutoFaceFocusSupported()) {
            this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){
                private long mLastFocusedTs;

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    if (faces == null || faces.length == 0 || camera == null || !VideoCaptureCamera.this.mIsAutoFaceFocusEnabled) {
                        return;
                    }
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (faces[0].score > 20) {
                            VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faces[0].rect);
                        }
                        return;
                    }
                    if (faces[0].score <= 50) {
                        Logging.i(VideoCaptureCamera.TAG, "face score = " + faces[0].score);
                        return;
                    }
                    try {
                        ArrayList<Camera.Area> focusList = new ArrayList<Camera.Area>();
                        Camera.Area firstFace = new Camera.Area(faces[0].rect, 1000);
                        focusList.add(firstFace);
                        if (camera.getParameters().getMaxNumFocusAreas() > 0) {
                            camera.getParameters().setFocusAreas(focusList);
                        }
                        if (camera.getParameters().getMaxNumMeteringAreas() > 0) {
                            camera.getParameters().setMeteringAreas(focusList);
                        }
                        VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faces[0].rect);
                        camera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean success, Camera camera) {
                                Logging.d(VideoCaptureCamera.TAG, "auto face focus called api1 every 3 seconds");
                                try {
                                    if (camera != null) {
                                        camera.cancelAutoFocus();
                                    }
                                }
                                catch (RuntimeException e) {
                                    Logging.w(VideoCaptureCamera.TAG, "Exception in cancelAutoFocus: " + Log.getStackTraceString((Throwable)e));
                                }
                            }
                        });
                        this.mLastFocusedTs = System.currentTimeMillis();
                    }
                    catch (RuntimeException e) {
                        Logging.w(VideoCaptureCamera.TAG, "Exception in onFaceDetection callback: " + Log.getStackTraceString((Throwable)e));
                    }
                }
            });
            Logging.i(TAG, "enable face detection");
            this.mCamera.startFaceDetection();
            this.isFaceDetectionStarted = true;
        }
        this.mPreviewBufferLock.lock();
        this.mExpectedFrameSize = bufSize;
        this.isCaptureRunning = true;
        this.mPreviewBufferLock.unlock();
        parameters = this.mCamera.getParameters();
        Logging.e(TAG, "Params: " + parameters.flatten());
        return 0;
    }

    private void notifyCameraFocusAreaChanged(Rect faceRect) {
        boolean isMirror = false;
        if (this.mId == 1) {
            isMirror = true;
        }
        RectF rectF = CoordinatesTransform.normalizedFaceRect(faceRect, 0, isMirror);
        float x = rectF.left;
        float y = rectF.top;
        float width = rectF.width();
        float height = rectF.height();
        Logging.d(TAG, "auto face focus left =" + rectF.left + " top = " + rectF.top + " right = " + rectF.right + " bottom = " + rectF.bottom);
        this.NotifyCameraFocusAreaChanged(x, y, width, height, this.mNativeVideoCaptureDeviceAndroid);
    }

    @Override
    public int setZoom(float zoomValue) {
        Camera.Parameters parameters;
        int zoomRatio = (int)(zoomValue * 100.0f + 0.5f);
        List<Integer> zoomRatios = this.getZoomRatios();
        if (zoomRatios == null) {
            return -1;
        }
        int zoomLevel = 0;
        for (int i = 0; i < zoomRatios.size(); ++i) {
            int temp = zoomRatios.get(i);
            if (zoomRatio > temp) continue;
            zoomLevel = i;
            break;
        }
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            int maxZoom = parameters.getMaxZoom();
            if (zoomLevel > maxZoom) {
                Logging.w(TAG, "zoom value is larger than maxZoom value");
                return -1;
            }
            parameters.setZoom(zoomLevel);
            this.mCamera.setParameters(parameters);
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mCamera != null) {
            List<Integer> zoomRatios;
            Camera.Parameters parameters = this.getCameraParameters();
            int maxZoom = 0;
            if (this.isZoomSupported(parameters)) {
                maxZoom = parameters.getMaxZoom();
            }
            if ((zoomRatios = this.getZoomRatios()) != null && zoomRatios.size() > maxZoom) {
                return (float)zoomRatios.get(maxZoom).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    @Override
    public int setTorchMode(boolean isTorchOn) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            List supportedFlashModes = parameters.getSupportedFlashModes();
            if (supportedFlashModes != null && supportedFlashModes.contains("torch")) {
                if (isTorchOn) {
                    parameters.setFlashMode("torch");
                } else {
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFocus(float x, float y, boolean inPreview) {
        Logging.d(TAG, "setFocus called camera api1");
        if (this.mCamera == null) {
            return -1;
        }
        if (x < 0.0f || x > 1.0f || y < 0.0f || y > 1.0f) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        Rect focusRect = VideoCaptureCamera.calculateTapArea(x, y, 1.0f);
        Rect meteringRect = VideoCaptureCamera.calculateTapArea(x, y, 1.5f);
        this.mCamera.cancelAutoFocus();
        Camera.Parameters params = this.getCameraParameters();
        if (params == null) {
            return -1;
        }
        if (params.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Logging.i(TAG, "focus areas not supported");
        }
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Logging.i(TAG, "metering areas not supported");
        }
        final String currentFocusMode = params.getFocusMode();
        if (VideoCaptureCamera.isSupported("macro", params.getSupportedFocusModes())) {
            params.setFocusMode("macro");
            Object object = this.mObjectLock;
            synchronized (object) {
                this.mCamera.setParameters(params);
            }
        } else {
            Logging.i("focus", "FOCUS_MODE_MACRO is not supported");
        }
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAutoFocus(boolean success, Camera camera) {
                Camera.Parameters params = camera.getParameters();
                params.setFocusMode(currentFocusMode);
                Object object = VideoCaptureCamera.this.mObjectLock;
                synchronized (object) {
                    camera.setParameters(params);
                }
            }
        });
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraFocusAreaChanged(x, y, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setExposure(float x, float y, boolean inPreview) {
        Logging.d(TAG, "setExposure called camera api1 x = " + x + " y = " + y);
        if (this.mCamera == null) {
            return -1;
        }
        if (x < 0.0f || x > 1.0f || y < 0.0f || y > 1.0f) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        Rect meteringRect = VideoCaptureCamera.calculateTapArea(x, y, 1.5f);
        if (this.mCamera != null) {
            Camera.Parameters params = this.getCameraParameters();
            if (params == null) {
                return -1;
            }
            if (params.getMaxNumMeteringAreas() > 0) {
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(meteringRect, 800));
                params.setMeteringAreas(meteringAreas);
            } else {
                Logging.i(TAG, "metering areas not supported");
            }
            this.mCamera.setParameters(params);
            this.mCamera.startPreview();
        }
        if (this.mNativeVideoCaptureDeviceAndroid != 0L) {
            this.NotifyCameraExposureAreaChanged(x, y, 0.0f, 0.0f, this.mNativeVideoCaptureDeviceAndroid);
        }
        return 0;
    }

    @Override
    public int setAutoFaceFocus(boolean enable) {
        this.mIsAutoFaceFocusEnabled = enable;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startCapture(int width, int height, int frameRate) {
        int res;
        block14: {
            if (this.mCamera == null) {
                Logging.e(TAG, "startCapture: camera is null!!");
                return -1;
            }
            res = 0;
            this.mLocalPreview = ViERenderer.GetLocalRenderer();
            if (this.mLocalPreview != null) {
                if (this.mLocalPreview.getSurface() != null && this.mLocalPreview.getSurface().isValid()) {
                    this.surfaceCreated(this.mLocalPreview);
                }
                this.mLocalPreview.addCallback((SurfaceHolder.Callback)this);
            } else {
                this.mCaptureLock.lock();
                try {
                    this.mDummySurfaceTexture = new SurfaceTexture(42);
                    this.mCamera.setPreviewTexture(this.mDummySurfaceTexture);
                }
                catch (Exception e) {
                    Logging.e(TAG, "failed to startPreview, invalid surfaceTexture!");
                    this.mDummySurfaceTexture = null;
                    res = -1;
                    return res;
                }
                finally {
                    this.mCaptureLock.unlock();
                    if (res == 0) break block14;
                    return res;
                }
            }
        }
        this.mCaptureLock.lock();
        this.isCaptureStarted = true;
        this.mCaptureWidth = width;
        this.mCaptureHeight = height;
        this.mCaptureFps = frameRate;
        try {
            res = this.tryStartCapture(width, height, frameRate);
        }
        catch (Throwable t) {
            Logging.e(TAG, "try start capture failed " + t);
            res = -1;
        }
        finally {
            this.mCaptureLock.unlock();
        }
        return res;
    }

    @Override
    public int stopCapture() {
        if (!this.isCaptureStarted) {
            Logging.w(TAG, "already stop capture");
            return 0;
        }
        try {
            if (this.isFaceDetectionStarted) {
                this.mCamera.stopFaceDetection();
                this.mCamera.setFaceDetectionListener(null);
                this.isFaceDetectionStarted = false;
            }
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Failed to stop face detection", e);
        }
        try {
            this.mPreviewBufferLock.lock();
            this.isCaptureRunning = false;
            this.mCamera.stopPreview();
            this.mPreviewBufferLock.unlock();
            this.mCamera.setErrorCallback(null);
            this.mCamera.setPreviewCallbackWithBuffer(null);
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Failed to stop camera", e);
            return -1;
        }
        this.isCaptureStarted = false;
        return 0;
    }

    @Override
    public boolean isTorchSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return VideoCaptureCamera.isSupported("torch", parameters.getSupportedFlashModes());
        }
        return false;
    }

    @Override
    public boolean isFocusSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            boolean isFocusSupported = parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", parameters.getSupportedFocusModes());
            return isFocusSupported;
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        Camera.Parameters parameters;
        boolean isExposureSupported = false;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            isExposureSupported = parameters.getMaxNumMeteringAreas() > 0;
        }
        return isExposureSupported;
    }

    @Override
    public boolean isZoomSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.isZoomSupported();
        }
        return false;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        Camera.Parameters parameters;
        return this.mCamera != null && (parameters = this.getCameraParameters()) != null && parameters.getMaxNumDetectedFaces() > 0 && parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", parameters.getSupportedFocusModes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate() {
        if (this.mCamera == null) {
            return;
        }
        Object object = this.mRecoverThreadObjectLock;
        synchronized (object) {
            this.mNativeVideoCaptureDeviceAndroid = 0L;
            this.stopCapture();
            this.mCaptureLock.lock();
            if (this.mCamera != null) {
                this.mCamera.release();
                this.mCamera = null;
            }
            this.mCaptureLock.unlock();
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
            if (this.mCameraRecoverHandlerThread != null) {
                this.mCameraRecoverHandlerThread.quit();
                this.mCameraRecoverHandlerThread = null;
                this.mHandler = null;
            }
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        try {
            this.mPreviewBufferLock.lock();
            if (data == null || !this.isCaptureRunning) {
                return;
            }
            if (data.length == this.mExpectedFrameSize && this.mNativeVideoCaptureDeviceAndroid != 0L) {
                this.ProvideCameraFrame(data, this.mExpectedFrameSize, this.mNativeVideoCaptureDeviceAndroid);
            } else if (this.mNativeVideoCaptureDeviceAndroid == 0L) {
                Logging.w(TAG, "warning mNativeVideoCaptureDeviceAndroid = 0, error");
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
            if (camera != null && this.isCaptureRunning) {
                camera.addCallbackBuffer(data);
            }
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mCaptureLock.lock();
        try {
            if (this.mCamera != null) {
                this.mCamera.stopPreview();
                this.mCamera.setPreviewDisplay(holder);
            }
        }
        catch (IOException ioe) {
            Logging.e(TAG, "Failed to set preview surface!", ioe);
        }
        catch (RuntimeException re) {
            Logging.e(TAG, "Failed to stop preview!", re);
        }
        this.mCaptureLock.unlock();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mCaptureLock.lock();
        try {
            if (this.mCamera != null) {
                this.mCamera.setPreviewDisplay(null);
            }
        }
        catch (IOException e) {
            Logging.e(TAG, "Failed to clear preview surface!", e);
        }
        this.mCaptureLock.unlock();
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported == null ? false : supported.indexOf(value) >= 0;
    }

    private void setAdvancedCameraParameters(Camera.Parameters parameters) {
        String sceneMode;
        String antibandingSupported;
        String focusMode;
        String whiteBalance;
        String flashMode = "off";
        if (VideoCaptureCamera.isSupported(flashMode, parameters.getSupportedFlashModes())) {
            Logging.i(TAG, "AgoraVideo set flash mode = FLASH_MODE_OFF");
            parameters.setFlashMode(flashMode);
        }
        if (VideoCaptureCamera.isSupported(whiteBalance = "auto", parameters.getSupportedWhiteBalance())) {
            Logging.i(TAG, "AgoraVideo set white blance = WHITE_BALANCE_AUTO");
            parameters.setWhiteBalance(whiteBalance);
        }
        if (VideoCaptureCamera.isSupported(focusMode = "continuous-video", parameters.getSupportedFocusModes())) {
            Logging.i(TAG, "AgoraVideo set Focus mode = FOCUS_MODE_CONTINUOUS_VIDEO");
            parameters.setFocusMode(focusMode);
        }
        if (VideoCaptureCamera.isSupported(antibandingSupported = "auto", parameters.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = ANTIBANDING_AUTO");
            parameters.setAntibanding(antibandingSupported);
        }
        if (VideoCaptureCamera.isSupported(sceneMode = "auto", parameters.getSupportedSceneModes())) {
            Logging.i(TAG, "AgoraVideo set sence mode = " + sceneMode);
            if (parameters.getSceneMode() != sceneMode) {
                parameters.setSceneMode(sceneMode);
            }
        }
    }

    private void setDeviceSpecificParameters(Camera.Parameters parameters) {
        String device = DeviceUtils.getDeviceId();
        String cpuName = DeviceUtils.getCpuName();
        String cpuABI = DeviceUtils.getCpuABI();
        int cpuCores = DeviceUtils.getNumberOfCPUCores();
        int maxFreq = DeviceUtils.getCPUMaxFreqKHz();
        Logging.i(TAG, "Current Device: " + device);
        Logging.i(TAG, "CPU name: " + cpuName + ", with " + cpuCores + " cores, arch: " + cpuABI + ", max Freq: " + maxFreq);
        if (device.contains("xiaomi/mi note")) {
            Logging.i(TAG, "set MiNote config");
            parameters.set("scene-detect", "on");
            parameters.set("xiaomi-still-beautify-values", "i:3");
            parameters.set("skinToneEnhancement", "enable");
            parameters.set("auto-exposure", "center-weighted");
        }
        if (device.contains("oppo/r7c/r7c")) {
            Logging.i(TAG, "set oppo r7c config");
            parameters.set("skinToneEnhancement", 1);
            parameters.set("face-beautify", 100);
            parameters.set("auto-exposure", "center-weighted");
        }
    }

    public Camera.Parameters getCameraParameters() {
        Camera.Parameters parameters;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "getCameraParameters: Camera.getParameters: ", ex);
            if (this.mCamera != null) {
                this.mCamera.release();
                this.mCamera = null;
            }
            return null;
        }
        return parameters;
    }

    public int createCapabilities() {
        String cap = null;
        Camera.Parameters param = this.getCameraParameters();
        if (param != null) {
            String cap_id = "\"id\":" + this.mId + ",";
            String cap_res_header = "\"resolution\":";
            String cap_res_value = "";
            List sizes = param.getSupportedPreviewSizes();
            for (int i = 0; i < sizes.size(); ++i) {
                String ss = "{\"w\":" + ((Camera.Size)sizes.get((int)i)).width + ",\"h\":" + ((Camera.Size)sizes.get((int)i)).height + "}";
                cap_res_value = i != sizes.size() - 1 ? cap_res_value + ss + "," : cap_res_value + ss;
            }
            String cap_fmt_header = "\"format\":";
            String cap_fmt_value = "";
            List fmts = param.getSupportedPreviewFormats();
            if (VideoCapture.isEmulator()) {
                fmts.remove((Object)842094169);
            }
            for (int i = 0; i < fmts.size(); ++i) {
                int fmt = VideoCaptureCamera.translateToEngineFormat((Integer)fmts.get(i));
                cap_fmt_value = i != fmts.size() - 1 ? cap_fmt_value + fmt + "," : cap_fmt_value + fmt;
            }
            String cap_fps_header = "\"fps\":";
            String cap_fps_value = "";
            List framerates = param.getSupportedPreviewFrameRates();
            for (int i = 0; i < framerates.size(); ++i) {
                int fps = (Integer)framerates.get(i);
                cap_fps_value = i != framerates.size() - 1 ? cap_fps_value + fps + "," : cap_fps_value + fps;
            }
            cap = "{" + cap_id + cap_res_header + "[" + cap_res_value + "]," + cap_fmt_header + "[" + cap_fmt_value + "]," + cap_fps_header + "[" + cap_fps_value + "]}";
        }
        VideoCaptureCamera.cacheCapability(this.mId, this.mContext, cap);
        return 0;
    }

    private List<Integer> getZoomRatios() {
        Camera.Parameters parameters;
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            return parameters.getZoomRatios();
        }
        return null;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            boolean isZoomSupported = parameters.isZoomSupported();
            if (isZoomSupported) {
                return true;
            }
            Logging.w(TAG, "camera zoom is not supported ");
            return false;
        }
        return false;
    }

    private static Rect calculateTapArea(float x, float y, float coefficient) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x * 2000.0f - 1000.0f);
        int centerY = (int)(y * 2000.0f - 1000.0f);
        int halfAreaSize = areaSize / 2;
        RectF rectF = new RectF((float)VideoCaptureCamera.clamp(centerX - halfAreaSize, -1000, 1000), (float)VideoCaptureCamera.clamp(centerY - halfAreaSize, -1000, 1000), (float)VideoCaptureCamera.clamp(centerX + halfAreaSize, -1000, 1000), (float)VideoCaptureCamera.clamp(centerY + halfAreaSize, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    private boolean isForeground() {
        if (this.mContext != null) {
            ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
            List processes = activityManager.getRunningAppProcesses();
            if (processes == null) {
                Logging.e(TAG, "List of RunningAppProcessInfo is null");
                return false;
            }
            for (int i = 0; i < processes.size(); ++i) {
                ActivityManager.RunningAppProcessInfo processInfo = (ActivityManager.RunningAppProcessInfo)processes.get(i);
                if (processInfo == null) {
                    Logging.e(TAG, "ActivityManager.RunningAppProcessInfo is null");
                    continue;
                }
                if (!processInfo.processName.equals(this.mContext.getPackageName()) || processInfo.importance != 100) continue;
                return true;
            }
        }
        return false;
    }
}

