/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class VideoCapture {
    private static final int kVideoI420 = 0;
    private static final int kVideoYV12 = 1;
    private static final int kVideoYUY2 = 2;
    private static final int kVideoNV12 = 11;
    private static final int kVideoNV21 = 12;
    private static final int kVideoUnknown = 99;
    protected int mCameraNativeOrientation;
    protected final Context mContext;
    protected final int mId;
    protected long mNativeVideoCaptureDeviceAndroid;
    private int mLastRotation = -1;

    VideoCapture(Context context, int id, long nativeVideoCaptureDeviceAndroid) {
        this.mContext = context;
        this.mId = id;
        this.mNativeVideoCaptureDeviceAndroid = nativeVideoCaptureDeviceAndroid;
    }

    public abstract int allocate();

    public abstract int setCaptureFormat(int var1);

    public abstract int startCapture(int var1, int var2, int var3);

    public abstract int stopCapture();

    public abstract boolean isTorchSupported();

    public abstract boolean isFocusSupported();

    public abstract boolean isZoomSupported();

    public abstract boolean isAutoFaceFocusSupported();

    public abstract int setZoom(float var1);

    public abstract float getMaxZoom();

    public abstract int setTorchMode(boolean var1);

    public abstract int setFocus(float var1, float var2, boolean var3);

    public abstract int setAutoFaceFocus(boolean var1);

    public abstract boolean isExposureSupported();

    public abstract int setExposure(float var1, float var2, boolean var3);

    public abstract int UnRegisterNativeHandle();

    public abstract void deallocate();

    public native void ProvideCameraFrame(byte[] var1, int var2, long var3);

    public native void ProvideCameraTexture(byte[] var1, int var2, long var3);

    public native boolean isAutoFaceFocusEnabled(long var1);

    public native void NotifyCameraFocusAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyCameraExposureAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void onCameraError(long var1, String var3);

    public static String fetchCapability(int id, Context appContext) {
        String PREFS_NAME = "CamCaps2";
        SharedPreferences caps = appContext.getSharedPreferences(PREFS_NAME, 0);
        return caps.getString("Cam_" + id, null);
    }

    public static void cacheCapability(int id, Context appContext, String cap) {
        String PREFS_NAME = "CamCaps2";
        SharedPreferences caps = appContext.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = caps.edit();
        editor.putString("Cam_" + id, cap);
        editor.commit();
    }

    public static int translateToEngineFormat(int fmt) {
        switch (fmt) {
            case 17: {
                return 12;
            }
            case 842094169: {
                return 1;
            }
            case 35: {
                return 0;
            }
            case 20: {
                return 2;
            }
        }
        return 99;
    }

    public static int translateToAndroidFormat(int fmt) {
        switch (fmt) {
            case 12: {
                return 17;
            }
            case 1: {
                return 842094169;
            }
            case 0: {
                return 35;
            }
            case 2: {
                return 20;
            }
        }
        return 0;
    }

    public static boolean isEmulator() {
        if ("nokia".equalsIgnoreCase(Build.MANUFACTURER) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
            return false;
        }
        String result = "";
        try {
            String[] args = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder cmd = new ProcessBuilder(args);
            Process process = cmd.start();
            StringBuffer sb = new StringBuffer();
            String readLine = "";
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
            while ((readLine = responseReader.readLine()) != null) {
                sb.append(readLine);
            }
            responseReader.close();
            result = sb.toString().toLowerCase();
        }
        catch (IOException ex) {
            return false;
        }
        return result.contains("intel") || result.contains("amd");
    }

    private int checkOrientation() {
        Display display;
        if (this.mContext != null && this.mContext.getSystemService("window") != null && (display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                int orientation = display.getRotation();
                return orientation;
            }
            catch (RuntimeException exception) {
                Logging.e("VideoCapture", "video capture checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }
}

