/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Process;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ViESurfaceRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "ViESurfaceRenderer";
    private Bitmap bitmap = null;
    private ByteBuffer byteBuffer = null;
    private SurfaceHolder surfaceHolder;
    private Rect source = new Rect();
    private Rect dest = new Rect();
    private float topScale = 0.0f;
    private float bottomScale = 1.0f;
    private float leftScale = 0.0f;
    private float rightScale = 1.0f;

    public ViESurfaceRenderer(SurfaceView view) {
        Log.i((String)TAG, (String)("surface view " + view));
        this.surfaceHolder = view.getHolder();
        if (this.surfaceHolder == null) {
            return;
        }
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.surfaceCreated(this.surfaceHolder);
    }

    private void changeDestRect(int dstWidth, int dstHeight) {
        this.dest.right = (int)((float)this.dest.left + Math.abs(this.leftScale - this.rightScale) * (float)dstWidth);
        this.dest.bottom = (int)((float)this.dest.top + Math.abs(this.topScale - this.bottomScale) * (float)dstHeight);
        Log.i((String)TAG, (String)("ViESurfaceRender::surfaceChanged in_width:" + dstWidth + " in_height:" + dstHeight + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom + " dest scale " + this.rightScale + " bottom scale " + this.bottomScale));
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int in_width, int in_height) {
        this.changeDestRect(in_width, in_height);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            Rect surface = this.surfaceHolder.getSurfaceFrame();
            if (surface != null) {
                this.changeDestRect(surface.right - surface.left, surface.bottom - surface.top);
                Log.i((String)TAG, (String)("ViESurfaceRender::surfaceCreated dst.left:" + surface.left + " dst.top:" + surface.top + " dst.dest:" + surface.right + " dst.bottom:" + surface.bottom + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom));
            }
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d((String)TAG, (String)"ViESurfaceRenderer::surfaceDestroyed");
        this.bitmap = null;
        this.byteBuffer = null;
    }

    public Bitmap CreateBitmap(int width, int height) {
        Log.d((String)TAG, (String)("CreateByteBitmap " + width + ":" + height));
        if (this.bitmap == null) {
            try {
                Process.setThreadPriority((int)-4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.changeDestRect(width, height);
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        this.source.left = 0;
        this.source.top = 0;
        this.source.bottom = height;
        this.source.right = width;
        return this.bitmap;
    }

    public ByteBuffer CreateByteBuffer(int width, int height) {
        Log.i((String)TAG, (String)("CreateByteBuffer " + width + " * " + height));
        if (this.bitmap == null) {
            this.bitmap = this.CreateBitmap(width, height);
            this.byteBuffer = ByteBuffer.allocateDirect(width * height * 2);
        }
        return this.byteBuffer;
    }

    public void SetCoordinates(float left, float top, float right, float bottom) {
        Log.i((String)TAG, (String)("SetCoordinates " + left + "," + top + " : " + right + "," + bottom));
        this.leftScale = left;
        this.topScale = top;
        this.rightScale = right;
        this.bottomScale = bottom;
    }

    private void saveBitmapToJPEG(int width, int height) {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        this.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteOutStream);
        try {
            FileOutputStream output = new FileOutputStream(String.format("/sdcard/render_%d.jpg", System.currentTimeMillis()));
            output.write(byteOutStream.toByteArray());
            output.flush();
            output.close();
            Log.i((String)TAG, (String)("saved jpg " + output.toString()));
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"save jpg failed", (Throwable)e);
        }
    }

    public void DrawByteBuffer() {
        if (this.byteBuffer == null) {
            Log.w((String)TAG, (String)"DrawByteBuffer null");
            return;
        }
        this.byteBuffer.rewind();
        this.bitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
        this.DrawBitmap();
    }

    public void DrawBitmap() {
        if (this.bitmap == null) {
            return;
        }
        Canvas canvas = this.surfaceHolder.lockCanvas();
        if (canvas != null) {
            canvas.drawBitmap(this.bitmap, this.source, this.dest, null);
            this.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
}

