/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.res.Configuration;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class ViEAndroidGLES20
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private static String TAG = "ViEAndroidGLES20";
    private static final boolean DEBUG = false;
    private boolean surfaceCreated = false;
    private boolean openGLCreated = false;
    private boolean nativeFunctionsRegisted = false;
    private ReentrantLock nativeFunctionLock = new ReentrantLock();
    private long nativeObject = 0L;
    private int viewWidth = 0;
    private int viewHeight = 0;
    private int nativeGLPragram = 0;
    private int[] nativeGLTextureId = new int[]{0, 0, 0};
    private boolean nativeGLResourceUpdated = false;
    private int mLastRotation = -1;

    public static boolean UseOpenGL2(Object renderWindow) {
        return ViEAndroidGLES20.class.isInstance(renderWindow);
    }

    public ViEAndroidGLES20(Context context) {
        super(context);
        this.init(false, 0, 0);
    }

    public ViEAndroidGLES20(Context context, boolean translucent, int depth, int stencil) {
        super(context);
        this.init(translucent, depth, stencil);
    }

    private void init(boolean translucent, int depth, int stencil) {
        if (translucent) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(translucent ? new ConfigChooser(8, 8, 8, 8, depth, stencil) : new ConfigChooser(5, 6, 5, 0, depth, stencil));
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    private static void checkEglError(String prompt, EGL10 egl) {
        int error;
        while ((error = egl.eglGetError()) != 12288) {
            try {
                Logging.e(TAG, String.format("%s: EGL error: 0x%x", prompt, error));
            }
            catch (Exception e) {
                Log.e((String)"AGORA_SDK", (String)"egl error!!, video may not displayed!!");
            }
        }
    }

    public static boolean IsSupported(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        return info.reqGlEsVersion >= 131072;
    }

    public void onDrawFrame(GL10 gl) {
        this.updateOrientation();
        this.nativeFunctionLock.lock();
        if (!this.nativeFunctionsRegisted || !this.surfaceCreated) {
            this.nativeFunctionLock.unlock();
            return;
        }
        if (!this.openGLCreated) {
            if (0 != this.CreateOpenGLNative(this.nativeObject, this.viewWidth, this.viewHeight)) {
                return;
            }
            this.openGLCreated = true;
        }
        this.DrawNative(this.nativeObject);
        this.nativeFunctionLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.surfaceCreated = true;
        this.viewWidth = width;
        this.viewHeight = height;
        Log.i((String)"AGORA_SDK", (String)("Surface changed to width " + width + " height " + height));
        this.nativeFunctionLock.lock();
        try {
            if (this.nativeFunctionsRegisted && this.CreateOpenGLNative(this.nativeObject, width, height) == 0) {
                this.openGLCreated = true;
            }
        }
        catch (Exception ex) {
            Log.w((String)"AGORA_SDK", (String)"Exception occurs when create RtcEngine");
        }
        finally {
            this.nativeFunctionLock.unlock();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateOrientation();
    }

    private int checkOrientation() {
        Display display;
        if (this.getContext() != null && this.getContext().getSystemService("window") != null && (display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                int orientation = display.getRotation();
                return orientation;
            }
            catch (RuntimeException exception) {
                Logging.e(TAG, "checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }

    private void updateOrientation() {
        int orientation = this.checkOrientation();
        if (orientation != this.mLastRotation) {
            this.nativeFunctionLock.lock();
            if (this.nativeFunctionsRegisted) {
                this.OnCfgChangedNative(this.nativeObject, orientation);
            }
            this.mLastRotation = orientation;
            this.nativeFunctionLock.unlock();
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
    }

    public void RegisterNativeObject(long nativeObject) {
        this.nativeFunctionLock.lock();
        this.nativeObject = nativeObject;
        this.nativeFunctionsRegisted = true;
        this.nativeFunctionLock.unlock();
    }

    public void DeRegisterNativeObject() {
        this.nativeFunctionLock.lock();
        this.nativeFunctionsRegisted = false;
        this.openGLCreated = false;
        this.nativeObject = 0L;
        this.nativeFunctionLock.unlock();
        this.releaseOpenGLResource();
    }

    public void ReDraw() {
        if (this.surfaceCreated) {
            this.requestRender();
        }
    }

    public void UpdateOpenGLResource(int[] value) {
        this.nativeGLPragram = value[0];
        for (int i = 0; i < 3; ++i) {
            this.nativeGLTextureId[i] = value[i + 1];
        }
        this.nativeGLResourceUpdated = true;
        Logging.i(TAG, "UpdateOpenGLResource, program = " + value[0] + " texture[0~2] = " + value[1] + " ," + value[2] + " ," + value[3]);
    }

    public void releaseOpenGLResource() {
        if (!this.nativeGLResourceUpdated) {
            return;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Logging.i(TAG, "releaseOpenGLResource, value = " + ViEAndroidGLES20.this.nativeGLPragram + " ," + ViEAndroidGLES20.this.nativeGLTextureId[0] + " ," + ViEAndroidGLES20.this.nativeGLTextureId[1] + " ," + ViEAndroidGLES20.this.nativeGLTextureId[2]);
                GLES20.glDeleteProgram((int)ViEAndroidGLES20.this.nativeGLPragram);
                GLES20.glDeleteTextures((int)3, (int[])ViEAndroidGLES20.this.nativeGLTextureId, (int)0);
                int error = GLES20.glGetError();
                if (error != 0) {
                    Logging.e(TAG, "glDelete error: " + error);
                }
            }
        });
        this.nativeGLResourceUpdated = false;
    }

    private native int CreateOpenGLNative(long var1, int var3, int var4);

    private native void DrawNative(long var1);

    private native void OnCfgChangedNative(long var1, int var3);

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int r, int g, int b, int a, int depth, int stencil) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttribs2, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                Logging.w(TAG, "no configurations found");
                return null;
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttribs2, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void printConfigs(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            int numConfigs = configs.length;
            Logging.w(TAG, String.format("%d configurations", numConfigs));
            for (int i = 0; i < numConfigs; ++i) {
                Logging.w(TAG, String.format("Configuration %d:\n", i));
                this.printConfig(egl, display, configs[i]);
            }
        }

        private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attributes = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] value = new int[1];
            for (int i = 0; i < attributes.length; ++i) {
                int attribute = attributes[i];
                String name = names[i];
                if (egl.eglGetConfigAttrib(display, config, attribute, value)) {
                    Logging.w(TAG, String.format("  %s: %d\n", name, value[0]));
                    continue;
                }
                while (egl.eglGetError() != 12288) {
                }
            }
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            ViEAndroidGLES20.checkEglError("Before eglCreateContext", egl);
            int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            ViEAndroidGLES20.checkEglError("After eglCreateContext", egl);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }
}

