/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.EglBase10;
import io.agora.rtc.gl.EglBase14;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGLContext;

@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 3000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static MediaCodecVideoEncoder runningInstance = null;
    private static MediaCodecVideoEncoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static String codecOmxName = null;
    private static Set<String> hwEncoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    private EglBase eglBase;
    private int width;
    private int height;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private final Matrix rotateMatrix = new Matrix();
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.MTK.", "OMX.IMG.TOPAZ.", "OMX.hisi.", "OMX.k3.", "OMX.amlogic.", "OMX.rk."};
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final String[] H264_HW_QCOM_EXCEPTION_MODELS = new String[]{"mi note lte", "redmi note 4x", "1605-a01", "aosp on hammerhead", "lm-x210", "oppo r9s"};
    private static final String[] MTK_NO_ADJUSTMENT_MODELS = new String[]{"vivo y83a", "vivo x21i", "vivo X21i A"};
    private static final int VIDEO_ControlRateVariable = 1;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
    private static final int[] supportedSurfaceColorList = new int[]{2130708361};
    private VideoCodecType type;
    private int colorFormat;
    private ByteBuffer configData = null;
    private long lastKeyFrameTimeMs = 0L;
    private int keyFrameIntervalInMsec = 0;
    private long lastResetForQcomTimeMs = 0L;
    private int converted_bps;
    private int lastSetFps;
    private boolean qcomExceptionModel = false;
    private static final int BASE_FRAME_RATE_FOR_MTK = 30;
    private static final int BASE_FRAME_RATE_FOR_EXYNOS = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_TOPAZ = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_HISI = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_K3 = 30;
    private static final int BASE_FRAME_RATE_FOR_AMLOGIC = 30;
    private static final int KBPS_TO_BPS_FACTOR = 900;
    private static final int KBPS_TO_BPS_FACTOR_QCOM = 950;
    private ChipProperties chipProperties = null;
    private FileOutputStream fos = null;

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback errorCallback) {
        Logging.d(TAG, "Set error callback");
        MediaCodecVideoEncoder.errorCallback = errorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        try {
            return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList) != null;
        }
        catch (Exception e) {
            Logging.e(TAG, "isH264HwSupported failed!");
            return false;
        }
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        try {
            return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedSurfaceColorList) != null;
        }
        catch (Exception e) {
            Logging.e(TAG, "isH264HwSupportedUsingTextures failed!");
            return false;
        }
    }

    public static boolean isQcomHWEncoder() {
        if (codecOmxName != null && !codecOmxName.startsWith("OMX.qcom.")) {
            Logging.i(TAG, "Qualcomm HW encoder false");
            return false;
        }
        Logging.i(TAG, "Qualcomm HW encoder true");
        return true;
    }

    private static EncoderProperties findHwEncoder(String mime, String[] supportedHwCodecPrefixes, int[] colorList) {
        try {
            return MediaCodecVideoEncoder.do_findHwEncoder(mime, supportedHwCodecPrefixes, colorList);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static EncoderProperties do_findHwEncoder(String mime, String[] supportedHwCodecPrefixes, int[] colorList) {
        List<String> exceptionModels;
        boolean test_texture;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        boolean bl = test_texture = colorList[0] == 2130708361;
        if (mime.equals(H264_MIME_TYPE) && (exceptionModels = Arrays.asList(H264_HW_EXCEPTION_MODELS)).contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return null;
        }
        Logging.i(TAG, "Model: " + Build.MODEL);
        Logging.i(TAG, "hardware: " + Build.HARDWARE);
        if (Build.HARDWARE.equalsIgnoreCase("kirin970") && !test_texture) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (!info.isEncoder()) continue;
            String name = null;
            for (String mimeType : info.getSupportedTypes()) {
                if (!mimeType.equals(mime)) continue;
                name = info.getName();
                break;
            }
            if (name == null) continue;
            if (!MediaCodecVideoEncoder.checkMinSDKVersion(name, test_texture)) {
                Logging.e(TAG, "Check min sdk version failed, " + name);
                continue;
            }
            Logging.i(TAG, "Found candidate encoder " + name);
            boolean supportedCodec = false;
            for (String hwCodecPrefix : supportedHwCodecPrefixes) {
                if (!name.startsWith(hwCodecPrefix)) continue;
                supportedCodec = true;
                break;
            }
            if (!supportedCodec && !test_texture) continue;
            codecOmxName = name;
            if (name.startsWith("OMX.amlogic.")) {
                if (test_texture) {
                    return new EncoderProperties(name, 2130708361, true);
                }
                return new EncoderProperties(name, 19, true);
            }
            MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(mime);
            boolean YUV420SemiPlanarOk = false;
            for (int colorFormat : capabilities.colorFormats) {
                if (21 == colorFormat) {
                    YUV420SemiPlanarOk = true;
                }
                Logging.d(TAG, "   Color: 0x" + Integer.toHexString(colorFormat));
            }
            for (int supportedColorFormat : colorList) {
                for (int codecColorFormat : capabilities.colorFormats) {
                    if (codecColorFormat != supportedColorFormat) continue;
                    if (codecColorFormat == 19 && YUV420SemiPlanarOk && (name.startsWith("OMX.IMG.TOPAZ.") || name.startsWith("OMX.hisi.") || name.startsWith("OMX.k3."))) {
                        Logging.i(TAG, "TOPAZ,force use COLOR_FormatYUV420SemiPlanar");
                        Logging.i(TAG, "Found target encoder for mime " + mime + " : " + name + ". Color: 0x" + Integer.toHexString(21));
                        return new EncoderProperties(name, 21, supportedCodec);
                    }
                    Logging.i(TAG, "Found target encoder for mime " + mime + " : " + name + ". Color: 0x" + Integer.toHexString(codecColorFormat));
                    return new EncoderProperties(name, codecColorFormat, supportedCodec);
                }
            }
        }
        return null;
    }

    private void checkOnMediaCodecThread() {
    }

    public static void printStackTrace() {
        StackTraceElement[] mediaCodecStackTraces;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (mediaCodecStackTraces = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            for (StackTraceElement stackTrace : mediaCodecStackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    static MediaCodec createByCodecName(String codecName) {
        try {
            return MediaCodec.createByCodecName((String)codecName);
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean initEncode(int codec, int width, int height, int Kbps, int fps, int init_fps, int keyinterval, int profile, android.opengl.EGLContext sharedContext) {
        try {
            if (this.createEncoder(codec, width, height, Kbps, fps, init_fps, keyinterval, profile, sharedContext != null)) {
                if (sharedContext != null) {
                    EglBase14.Context egl14Context = new EglBase14.Context(sharedContext);
                    this.eglBase = new EglBase14(egl14Context, EglBase.CONFIG_RECORDABLE);
                    this.inputSurface = this.mediaCodec.createInputSurface();
                    this.eglBase.createSurface(this.inputSurface);
                    this.drawer = new GlRectDrawer();
                }
                this.mediaCodec.start();
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
                return true;
            }
            Logging.e(TAG, "failed to create hardware encoder!!");
            return false;
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to create hardware encoder,", e);
            this.release();
            return false;
        }
    }

    boolean initEncode(int codec, int width, int height, int Kbps, int fps, int init_fps, int keyinterval, int profile, EGLContext sharedContext) {
        try {
            if (this.createEncoder(codec, width, height, Kbps, fps, init_fps, keyinterval, profile, sharedContext != null)) {
                if (sharedContext != null) {
                    EglBase10.Context egl10Context = new EglBase10.Context(sharedContext);
                    this.eglBase = new EglBase10(egl10Context, EglBase.CONFIG_RECORDABLE);
                    this.inputSurface = this.mediaCodec.createInputSurface();
                    this.eglBase.createSurface(this.inputSurface);
                    this.drawer = new GlRectDrawer();
                }
                this.mediaCodec.start();
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
                return true;
            }
            Logging.e(TAG, "failed to create hardware encoder!!");
            return false;
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to create hardware encoder,", e);
            this.release();
            return false;
        }
    }

    private boolean createEncoder(int codec, int width, int height, int Kbps, int fps, int init_fps, int keyinterval, int profile, boolean useSurface) throws RuntimeException {
        Logging.i(TAG, "Java initEncode: " + (Object)((Object)VideoCodecType.values()[codec]) + " : " + width + " x " + height + ". @ " + Kbps + " Kbps. Fps: " + fps + " key interval: " + keyinterval + "s. Encode from texture : " + useSurface);
        this.width = width;
        this.height = height;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        EncoderProperties properties = null;
        String mime = null;
        if (fps < 1) {
            fps = 1;
        }
        if (keyinterval < 1) {
            keyinterval = 1;
        }
        this.lastSetFps = fps;
        this.keyFrameIntervalInMsec = keyinterval * 1000;
        this.lastKeyFrameTimeMs = 0L;
        this.lastResetForQcomTimeMs = SystemClock.elapsedRealtime();
        VideoCodecType type = VideoCodecType.values()[codec];
        if (type == VideoCodecType.VIDEO_CODEC_VP8) {
            mime = VP8_MIME_TYPE;
            properties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, useSurface ? supportedSurfaceColorList : supportedColorList);
        } else if (type == VideoCodecType.VIDEO_CODEC_VP9) {
            mime = VP9_MIME_TYPE;
            properties = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedH264HwCodecPrefixes, useSurface ? supportedSurfaceColorList : supportedColorList);
        } else if (type == VideoCodecType.VIDEO_CODEC_H264) {
            mime = H264_MIME_TYPE;
            properties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, useSurface ? supportedSurfaceColorList : supportedColorList);
        }
        if (properties == null) {
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)type));
        }
        runningInstance = this;
        this.colorFormat = properties.colorFormat;
        this.chipProperties = this.getChipProperties(properties.codecName, fps);
        Logging.i(TAG, "Color format: " + this.colorFormat);
        this.converted_bps = this.convertBitRate(Kbps, fps);
        this.mediaCodecThread = Thread.currentThread();
        MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
        if (Build.VERSION.SDK_INT >= this.chipProperties.highProfileMinSdkVersion && profile == 100) {
            Logging.i(TAG, "Set high profile and level");
            format.setInteger("profile", 8);
            format.setInteger("level", 512);
        }
        format.setInteger("bitrate", this.converted_bps);
        if (properties.codecName.startsWith("OMX.rk.")) {
            format.setInteger("bitrate-mode", 2);
        } else if (!this.qcomExceptionModel) {
            format.setInteger("bitrate-mode", 1);
        }
        format.setInteger("color-format", properties.colorFormat);
        if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.NO_ADJUSTMENT) {
            format.setInteger("frame-rate", init_fps);
        } else {
            format.setInteger("frame-rate", this.chipProperties.initFrameRate);
        }
        if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) {
            format.setInteger("i-frame-interval", keyinterval);
        } else {
            format.setInteger("i-frame-interval", keyinterval + 1);
        }
        Logging.d(TAG, "  Format: " + format);
        this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(properties.codecName);
        this.type = type;
        if (this.mediaCodec == null) {
            throw new RuntimeException("Can not create media encoder");
        }
        this.mediaCodec.configure(format, null, null, 1);
        return true;
    }

    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] inputBuffers = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + inputBuffers.length);
        return inputBuffers;
    }

    boolean encodeBuffer(boolean isKeyframe, int inputBuffer, int size, long presentationTimestampUs) {
        this.checkOnMediaCodecThread();
        long curTimeMs = SystemClock.elapsedRealtime();
        if (this.lastKeyFrameTimeMs == 0L) {
            this.lastKeyFrameTimeMs = curTimeMs;
        }
        try {
            if (isKeyframe || this.chipProperties.bitrateAdjustmentType != BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT && curTimeMs - this.lastKeyFrameTimeMs >= (long)this.keyFrameIntervalInMsec) {
                if (isKeyframe) {
                    Logging.i(TAG, "Sync frame request");
                }
                Bundle b = new Bundle();
                b.putInt("request-sync", 0);
                this.mediaCodec.setParameters(b);
                this.lastKeyFrameTimeMs = curTimeMs;
            }
            this.mediaCodec.queueInputBuffer(inputBuffer, 0, size, presentationTimestampUs, 0);
            return true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "encodeBuffer failed", e);
            return false;
        }
    }

    boolean encodeTexture(boolean isKeyframe, int oesTextureId, int textureType, float[] transformationMatrix, int textureWidth, int textureHeight, int actual_width, int actual_height, int rotation, long presentationTimestampUs) {
        this.checkOnMediaCodecThread();
        long curTimeMs = SystemClock.elapsedRealtime();
        if (this.lastKeyFrameTimeMs == 0L) {
            this.lastKeyFrameTimeMs = curTimeMs;
        }
        try {
            int rotatedHeight;
            int rotatedWidth;
            if (isKeyframe || this.chipProperties.bitrateAdjustmentType != BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT && curTimeMs - this.lastKeyFrameTimeMs >= (long)this.keyFrameIntervalInMsec) {
                if (isKeyframe) {
                    Logging.i(TAG, "Sync frame request");
                }
                Bundle b = new Bundle();
                b.putInt("request-sync", 0);
                this.mediaCodec.setParameters(b);
                this.lastKeyFrameTimeMs = curTimeMs;
            }
            Logging.d(TAG, "enter encodeTexture:" + textureWidth + "x" + textureHeight + "->" + this.width + "x" + this.height);
            this.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            if (rotation == 90 || rotation == 270) {
                rotatedWidth = textureHeight;
                rotatedHeight = textureWidth;
            } else {
                rotatedWidth = textureWidth;
                rotatedHeight = textureHeight;
            }
            this.rotateMatrix.reset();
            this.rotateMatrix.preTranslate(0.5f, 0.5f);
            this.rotateMatrix.preRotate((float)rotation);
            this.rotateMatrix.preTranslate(-0.5f, -0.5f);
            Matrix finalMatrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformationMatrix);
            finalMatrix.preConcat(this.rotateMatrix);
            float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(finalMatrix);
            if (textureType == 10) {
                this.drawer.drawRgb(oesTextureId, finalGlMatrix, rotatedWidth, rotatedHeight, 0, 0, this.width, this.height, actual_width, actual_height);
            } else {
                this.drawer.drawOes(oesTextureId, finalGlMatrix, rotatedWidth, rotatedHeight, 0, 0, this.width, this.height, actual_width, actual_height);
            }
            this.eglBase.swapBuffers();
            return true;
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "encodeTexture failed", e);
            return false;
        }
    }

    private static int distance(float x0, float y0, float x1, float y1) {
        return (int)Math.round(Math.hypot(x1 - x0, y1 - y0));
    }

    void release() {
        Logging.i(TAG, "Java releaseEncoder");
        this.checkOnMediaCodecThread();
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        final CaughtException caughtException = new CaughtException();
        boolean stopHung = false;
        if (this.mediaCodec != null) {
            final CountDownLatch releaseDone = new CountDownLatch(1);
            Runnable runMediaCodecRelease = new Runnable(){
                {
                }

                @Override
                public void run() {
                    Logging.i(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception e) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder stop failed", e);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception e) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", e);
                        caughtException.e = e;
                    }
                    Logging.i(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                    releaseDone.countDown();
                }
            };
            new Thread(runMediaCodecRelease).start();
            if (!ThreadUtils.awaitUninterruptibly(releaseDone, 3000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                stopHung = true;
            }
            this.mediaCodec = null;
        }
        this.mediaCodecThread = null;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        if (stopHung) {
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException.e != null) {
            RuntimeException runtimeException = new RuntimeException(caughtException.e);
            runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), runtimeException.getStackTrace()));
            throw runtimeException;
        }
        Logging.i(TAG, "Java releaseEncoder done");
    }

    private static boolean checkMinSDKVersion(String chipName, boolean isTexture) {
        if (isTexture) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (chipName.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (chipName.startsWith("OMX.MTK.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (chipName.startsWith("OMX.Exynos.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (chipName.startsWith("OMX.IMG.TOPAZ.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (chipName.startsWith("OMX.k3.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private ChipProperties getChipProperties(String chipName, int fps) {
        if (chipName.startsWith("OMX.qcom.")) {
            List<String> qcomExceptModels = Arrays.asList(H264_HW_QCOM_EXCEPTION_MODELS);
            if (qcomExceptModels.contains(Build.MODEL.toLowerCase())) {
                Logging.w(TAG, "Qcom Exception Model: " + Build.MODEL);
                this.qcomExceptionModel = true;
                return new ChipProperties(chipName, BitrateAdjustmentType.NO_ADJUSTMENT, true, fps, fps, 21);
            }
            this.qcomExceptionModel = false;
            return new ChipProperties(chipName, BitrateAdjustmentType.NO_ADJUSTMENT, false, fps, fps, 21);
        }
        if (chipName.startsWith("OMX.MTK.")) {
            String hardware_str = Build.HARDWARE;
            Logging.i(TAG, "MTK hardware: " + hardware_str);
            if (hardware_str.equalsIgnoreCase("mt6763") || hardware_str.equalsIgnoreCase("mt6763t")) {
                return new ChipProperties(chipName, BitrateAdjustmentType.NO_ADJUSTMENT, false, fps, fps, 21);
            }
            List<String> mtkNoAdjustmentModels = Arrays.asList(MTK_NO_ADJUSTMENT_MODELS);
            if (mtkNoAdjustmentModels.contains(Build.MODEL)) {
                return new ChipProperties(chipName, BitrateAdjustmentType.NO_ADJUSTMENT, false, fps, fps, 21);
            }
            if (hardware_str.equalsIgnoreCase("mt6735")) {
                return new ChipProperties(chipName, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, fps, fps, Integer.MAX_VALUE);
            }
            return new ChipProperties(chipName, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, fps, fps, 21);
        }
        if (chipName.startsWith("OMX.Exynos.")) {
            if (Build.MODEL.equalsIgnoreCase("MX4 Pro")) {
                return new ChipProperties(chipName, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, fps, fps, Integer.MAX_VALUE);
            }
            return new ChipProperties(chipName, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, 21);
        }
        if (chipName.startsWith("OMX.IMG.TOPAZ.")) {
            if (Build.HARDWARE.equalsIgnoreCase("hi6250")) {
                return new ChipProperties(chipName, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, fps, fps, Integer.MAX_VALUE);
            }
            return new ChipProperties(chipName, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        if (chipName.startsWith("OMX.hisi.")) {
            return new ChipProperties(chipName, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, fps, fps, Integer.MAX_VALUE);
        }
        if (chipName.startsWith("OMX.k3.")) {
            return new ChipProperties(chipName, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, 21);
        }
        if (chipName.startsWith("OMX.amlogic.")) {
            Logging.i(TAG, "getChipProperties for amlogic");
            return new ChipProperties(chipName, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        if (chipName.startsWith("OMX.rk.")) {
            return new ChipProperties(chipName, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        Logging.i(TAG, "getChipProperties from unsupported chip list");
        return new ChipProperties(chipName, BitrateAdjustmentType.NO_ADJUSTMENT, false, fps, fps, 23);
    }

    private int convertBitRate(int Kbps, int fps) {
        if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT) {
            if (this.chipProperties.chipName.startsWith("OMX.rk.")) {
                return 1000 * Kbps * this.chipProperties.baseFrameRate / fps;
            }
            return 900 * Kbps * this.chipProperties.baseFrameRate / fps;
        }
        if (this.chipProperties.chipName.startsWith("OMX.qcom.")) {
            return 950 * Kbps;
        }
        return 900 * Kbps;
    }

    private int setRates(int Kbps, int fps) {
        this.checkOnMediaCodecThread();
        Logging.d(TAG, "Bwe setRates: " + Kbps + " Kbps");
        boolean fps_changed = fps > 0 && fps != this.lastSetFps;
        this.lastSetFps = fps > 0 ? fps : this.lastSetFps;
        int new_bps = this.convertBitRate(Kbps, this.lastSetFps);
        try {
            if (fps_changed && this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) {
                this.converted_bps = new_bps;
                return 0;
            }
            if (new_bps > this.converted_bps) {
                this.converted_bps = new_bps;
                Bundle params = new Bundle();
                params.putInt("video-bitrate", this.converted_bps);
                this.mediaCodec.setParameters(params);
                Logging.i(TAG, "setRates up to : " + this.converted_bps + " bps(converted) " + this.lastSetFps + " fps");
                return 1;
            }
            int minDownStep = 0;
            if (this.chipProperties.chipName.startsWith("OMX.qcom.")) {
                if (this.qcomExceptionModel) {
                    minDownStep = 25000;
                } else {
                    int n = minDownStep = this.converted_bps > 200000 ? 25000 : 15000;
                }
            }
            if (new_bps < this.converted_bps - minDownStep) {
                this.converted_bps = new_bps;
                if (this.chipProperties.isNeedResetWhenDownBps) {
                    long nowms = SystemClock.elapsedRealtime();
                    if (nowms - this.lastResetForQcomTimeMs >= 2000L) {
                        this.lastResetForQcomTimeMs = nowms;
                        return 0;
                    }
                    return 2;
                }
                Bundle params = new Bundle();
                params.putInt("video-bitrate", this.converted_bps);
                this.mediaCodec.setParameters(params);
                Logging.i(TAG, "setRates down to : " + this.converted_bps + " bps(converted) " + this.lastSetFps + " fps");
            }
            return 1;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "setRates failed", e);
            return 0;
        }
    }

    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "dequeueIntputBuffer failed", e);
            return -2;
        }
    }

    OutputBufferInfo dequeueOutputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int result = this.mediaCodec.dequeueOutputBuffer(info, 0L);
            if (result >= 0) {
                boolean isConfigFrame;
                boolean bl = isConfigFrame = (info.flags & 2) != 0;
                if (isConfigFrame) {
                    Logging.d(TAG, "Config frame generated. Offset: " + info.offset + ". Size: " + info.size);
                    this.configData = ByteBuffer.allocateDirect(info.size);
                    this.outputBuffers[result].position(info.offset);
                    this.outputBuffers[result].limit(info.offset + info.size);
                    this.configData.put(this.outputBuffers[result]);
                    this.mediaCodec.releaseOutputBuffer(result, false);
                    result = this.mediaCodec.dequeueOutputBuffer(info, 0L);
                }
            }
            if (result >= 0) {
                boolean isKeyFrame;
                ByteBuffer outputBuffer = this.outputBuffers[result].duplicate();
                outputBuffer.position(info.offset);
                outputBuffer.limit(info.offset + info.size);
                boolean bl = isKeyFrame = (info.flags & 1) != 0;
                if (isKeyFrame) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (isKeyFrame && this.type == VideoCodecType.VIDEO_CODEC_H264) {
                    Logging.d(TAG, "Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size);
                    ByteBuffer keyFrameBuffer = ByteBuffer.allocateDirect(this.configData.capacity() + info.size);
                    this.configData.rewind();
                    keyFrameBuffer.put(this.configData);
                    keyFrameBuffer.put(outputBuffer);
                    keyFrameBuffer.position(0);
                    OutputBufferInfo out = new OutputBufferInfo(result, keyFrameBuffer, isKeyFrame, info.presentationTimeUs, info.size + this.configData.capacity());
                    return out;
                }
                OutputBufferInfo out = new OutputBufferInfo(result, outputBuffer.slice(), isKeyFrame, info.presentationTimeUs, info.size);
                return out;
            }
            if (result == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
            if (result == -2) {
                return this.dequeueOutputBuffer();
            }
            if (result == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + result);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "dequeueOutputBuffer failed", e);
            return new OutputBufferInfo(-1, null, false, -1L, 0);
        }
    }

    boolean releaseOutputBuffer(int index) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(index, false);
            return true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "releaseOutputBuffer failed", e);
            return false;
        }
    }

    void dumpIntoFile(OutputBufferInfo buf) {
        if (this.fos == null) {
            try {
                String fileName = String.format("/sdcard/java_dump_video_%d_%d.h264", this.width, this.height);
                this.fos = new FileOutputStream(fileName, true);
            }
            catch (Exception e) {
                Logging.i(TAG, "dumpIntoFile: failed to open java_dump_video.h264");
                return;
            }
        }
        if (buf != null && buf.index >= 0) {
            Logging.i(TAG, "Dump nal: " + buf.buffer);
            try {
                byte[] dst = new byte[buf.buffer.remaining()];
                buf.buffer.get(dst);
                this.fos.write(dst, 0, buf.size);
            }
            catch (Exception e) {
                Logging.e(TAG, "Run: 4.1 Exception ", e);
            }
        }
    }

    static class OutputBufferInfo {
        public final int size;
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int index, ByteBuffer buffer, boolean isKeyFrame, long presentationTimestampUs, int size) {
            this.index = index;
            this.buffer = buffer;
            this.isKeyFrame = isKeyFrame;
            this.presentationTimestampUs = presentationTimestampUs;
            this.size = size;
        }
    }

    private static class ChipProperties {
        public final String chipName;
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final boolean isNeedResetWhenDownBps;
        public final int baseFrameRate;
        public final int initFrameRate;
        public final int highProfileMinSdkVersion;

        ChipProperties(String chipName, BitrateAdjustmentType bitrateAdjustmentType, boolean isNeedResetWhenDownBps, int baseFrameRate, int initFrameRate, int highProfileMinSdkVersion) {
            this.chipName = chipName;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            this.isNeedResetWhenDownBps = isNeedResetWhenDownBps;
            this.baseFrameRate = baseFrameRate;
            this.initFrameRate = initFrameRate;
            this.highProfileMinSdkVersion = highProfileMinSdkVersion;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        ACTUAL_FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    private static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final boolean supportedList;

        public EncoderProperties(String codecName, int colorFormat, boolean supportedList) {
            this.codecName = codecName;
            this.colorFormat = colorFormat;
            this.supportedList = supportedList;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

