/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.hardware.Camera;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;

public class CameraUtil {
    private static final String TAG = "CAMERA_UTIL";

    public static int getCameraDisplayOrientation(Context context, int cameraId) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int result = 90;
        if (context != null && context.getSystemService("window") != null) {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            if (display == null) {
                Logging.e(TAG, "display is null");
                return result;
            }
            int rotation = display.getRotation();
            int degrees = 0;
            switch (rotation) {
                case 0: {
                    degrees = 0;
                    break;
                }
                case 1: {
                    degrees = 90;
                    break;
                }
                case 2: {
                    degrees = 180;
                    break;
                }
                case 3: {
                    degrees = 270;
                }
            }
            if (info.facing == 1) {
                result = (info.orientation + degrees) % 360;
                result = (360 - result) % 360;
            } else {
                result = (info.orientation - degrees + 360) % 360;
            }
        }
        return result;
    }
}

