/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.hardware.Camera;
import io.agora.rtc.internal.Logging;
import java.util.ArrayList;
import java.util.List;

public class CameraHelper {
    private static final String TAG = "CameraHelper";

    public static boolean checkPermission() {
        try {
            return true;
        }
        catch (Exception e) {
            Logging.e(TAG, "exception in check permission", e);
            return false;
        }
    }

    public static Capability createCapability(int id, int facing, Camera.Parameters param) {
        List sizes = param.getSupportedPreviewSizes();
        List fpsRanges = param.getSupportedPreviewFpsRange();
        if (sizes.isEmpty() || fpsRanges.isEmpty()) {
            Logging.e(TAG, "failed get preview size/fps, parameters = " + param.flatten());
            throw new IllegalArgumentException(param.flatten());
        }
        Camera.Size maxSize = (Camera.Size)sizes.get(0);
        for (Camera.Size s : sizes) {
            if (s.width * s.height <= maxSize.width * maxSize.height) continue;
            maxSize = s;
        }
        int maxFps = ((int[])fpsRanges.get(0))[1] / 1000;
        Logging.d(TAG, "creaet capability for camera " + id + " : width: " + maxSize.width + " , height: " + maxSize.height + " max fps: " + maxFps);
        return new Capability(id, facing, maxSize.width, maxSize.height, maxFps);
    }

    public static synchronized List<Capability> getCameraCapability() {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        int numberOfCameras = Camera.getNumberOfCameras();
        if (numberOfCameras < 1) {
            throw new RuntimeException("no camera device");
        }
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            Camera camera = Camera.open((int)i);
            Camera.Parameters param = camera.getParameters();
            capabilities.add(CameraHelper.createCapability(i, info.facing, param));
            camera.release();
            camera = null;
        }
        return capabilities;
    }

    public static class Capability {
        public static final int CAMERA_FACING_FRONT = 1;
        public static final int CAMERA_FACING_BACK = 0;
        public int width;
        public int height;
        public int maxFps;
        public int id;
        public int facing;

        public Capability(int id, int facing, int w, int h, int fps) {
            this.id = id;
            this.facing = facing;
            this.width = w;
            this.height = h;
            this.maxFps = fps;
        }
    }
}

