/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Log;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.VideoFrame;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class YuvUtils {
    private static final String TAG = YuvUtils.class.getSimpleName();
    public static final int I420 = 35;
    public static final int NV21 = 17;

    public static boolean supportedImageFormat(Image image) {
        int format = image.getFormat();
        switch (format) {
            case 17: 
            case 35: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    public static byte[] getImageData(Image image, int imageFormat) {
        if (imageFormat != 35 && imageFormat != 17) {
            throw new IllegalArgumentException("only support COLOR_FormatI420 and COLOR_FormatNV21");
        }
        if (!YuvUtils.supportedImageFormat(image)) {
            throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
        }
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        for (int i = 0; i < planes.length; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    if (imageFormat == 35) {
                        channelOffset = width * height;
                        outputStride = 1;
                        break;
                    }
                    if (imageFormat != 17) break;
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    if (imageFormat == 35) {
                        channelOffset = (int)((double)(width * height) * 1.25);
                        outputStride = 1;
                        break;
                    }
                    if (imageFormat != 17) break;
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    public static boolean writeNV21ToFile(byte[] imageData, int width, int height, String filePath) {
        YuvImage yuvImage = new YuvImage(imageData, 17, width, height, null);
        Rect area = new Rect(0, 0, width, height);
        try {
            File f = new File(filePath);
            f.createNewFile();
            FileOutputStream fos = new FileOutputStream(f);
            yuvImage.compressToJpeg(area, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)ex.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRawData(byte[] data, String filePath) {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            File f = new File(filePath);
            f.createNewFile();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(data);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write420ImageToFile(Image image, String filePath) {
        if (image == null) {
            return;
        }
        byte[] nv21 = YuvUtils.yuv420toNV21(image);
        try {
            YuvImage yuvImage = new YuvImage(nv21, 17, image.getWidth(), image.getHeight(), null);
            ByteArrayOutputStream outBitmap = new ByteArrayOutputStream();
            yuvImage.compressToJpeg(new Rect(0, 0, image.getWidth(), image.getHeight()), 100, (OutputStream)outBitmap);
            File f = new File(filePath);
            f.createNewFile();
            FileOutputStream fos = null;
            fos = new FileOutputStream(f);
            fos.write(outBitmap.toByteArray());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public static byte[] yuv420toNV21(Image image) {
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        for (int i = 0; i < planes.length; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    public static byte[] yuv420toNV21(byte[] data, int width, int height) {
        JavaI420Buffer buffer = JavaI420Buffer.createYUV(data, width, height);
        byte[] yuv420 = YuvUtils.yuv420toNV21(buffer, width, height);
        return yuv420;
    }

    public static byte[] yuv420toNV21(VideoFrame.I420Buffer i420, int width, int height) {
        Rect crop = new Rect(0, 0, width, height);
        int format = 35;
        Plane[] planes = new Plane[3];
        Plane yPlane = new Plane(i420.getDataY(), i420.getStrideY(), 1);
        Plane uPlane = new Plane(i420.getDataU(), i420.getStrideU(), 1);
        Plane vPlane = new Plane(i420.getDataV(), i420.getStrideV(), 1);
        planes[0] = yPlane;
        planes[1] = uPlane;
        planes[2] = vPlane;
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        for (int i = 0; i < planes.length; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
        }
        return data;
    }

    public static void writeRgbaToFile(Buffer buffer, int width, int height, String filePath) {
        try {
            File f = new File(filePath);
            f.createNewFile();
            FileOutputStream fos = null;
            fos = new FileOutputStream(f);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer(buffer);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
    }

    static class Plane {
        private ByteBuffer buffer;
        private int rowStride;
        private int pixelStride;

        public Plane(ByteBuffer buffer, int rowStride, int pixelStride) {
            this.buffer = buffer;
            this.rowStride = rowStride;
            this.pixelStride = pixelStride;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getRowStride() {
            return this.rowStride;
        }

        public int getPixelStride() {
            return this.pixelStride;
        }
    }
}

