/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.content.Context;
import android.view.WindowManager;
import io.agora.rtc.internal.RtcEngineImpl;

public class AgoraUtils {
    private static final String TAG = "AgoraUtils";

    public static boolean ensureNativeLibsInitialized() {
        return RtcEngineImpl.initializeNativeLibs();
    }

    public static int getFrameOrientation(int displayRotation, int sensorOrientation, boolean isFrontFacing, boolean compensateForMirroring) {
        int result;
        if (isFrontFacing) {
            result = (sensorOrientation + displayRotation) % 360;
            if (compensateForMirroring) {
                result = (360 - result) % 360;
            }
        } else {
            result = (sensorOrientation - displayRotation + 360) % 360;
        }
        return result;
    }

    public static int getDisplayRotation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int rotation = windowManager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static String getAppStorageDir(Context context) {
        if (context == null) {
            return null;
        }
        int res = context.checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE");
        if (res == 0) {
            return "/sdcard/" + context.getApplicationInfo().packageName;
        }
        return null;
    }
}

